package zio.aws.imagebuilder.model
import scala.jdk.CollectionConverters.*
sealed trait LifecyclePolicyResourceType {
  def unwrap: software.amazon.awssdk.services.imagebuilder.model.LifecyclePolicyResourceType
}
object LifecyclePolicyResourceType {
  def wrap(
      value: software.amazon.awssdk.services.imagebuilder.model.LifecyclePolicyResourceType
  ): zio.aws.imagebuilder.model.LifecyclePolicyResourceType = value match {
    case software.amazon.awssdk.services.imagebuilder.model.LifecyclePolicyResourceType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.imagebuilder.model.LifecyclePolicyResourceType.AMI_IMAGE =>
      val r = AMI_IMAGE
      r
    case software.amazon.awssdk.services.imagebuilder.model.LifecyclePolicyResourceType.CONTAINER_IMAGE =>
      val r = CONTAINER_IMAGE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.imagebuilder.model.LifecyclePolicyResourceType {
    override def unwrap
        : software.amazon.awssdk.services.imagebuilder.model.LifecyclePolicyResourceType =
      software.amazon.awssdk.services.imagebuilder.model.LifecyclePolicyResourceType.UNKNOWN_TO_SDK_VERSION
  }
  case object AMI_IMAGE
      extends zio.aws.imagebuilder.model.LifecyclePolicyResourceType {
    override def unwrap
        : software.amazon.awssdk.services.imagebuilder.model.LifecyclePolicyResourceType =
      software.amazon.awssdk.services.imagebuilder.model.LifecyclePolicyResourceType.AMI_IMAGE
  }
  case object CONTAINER_IMAGE
      extends zio.aws.imagebuilder.model.LifecyclePolicyResourceType {
    override def unwrap
        : software.amazon.awssdk.services.imagebuilder.model.LifecyclePolicyResourceType =
      software.amazon.awssdk.services.imagebuilder.model.LifecyclePolicyResourceType.CONTAINER_IMAGE
  }
}
