package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.{VersionNumber, ResourceName}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class LifecyclePolicyResourceSelectionRecipe(
    name: ResourceName,
    semanticVersion: VersionNumber
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.LifecyclePolicyResourceSelectionRecipe = {
    import LifecyclePolicyResourceSelectionRecipe.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.LifecyclePolicyResourceSelectionRecipe
      .builder()
      .name(ResourceName.unwrap(name): java.lang.String)
      .semanticVersion(VersionNumber.unwrap(semanticVersion): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.imagebuilder.model.LifecyclePolicyResourceSelectionRecipe.ReadOnly =
    zio.aws.imagebuilder.model.LifecyclePolicyResourceSelectionRecipe
      .wrap(buildAwsValue())
}
object LifecyclePolicyResourceSelectionRecipe {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.LifecyclePolicyResourceSelectionRecipe
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.imagebuilder.model.LifecyclePolicyResourceSelectionRecipe =
      zio.aws.imagebuilder.model
        .LifecyclePolicyResourceSelectionRecipe(name, semanticVersion)
    def name: ResourceName
    def semanticVersion: VersionNumber
    def getName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(name)
    def getSemanticVersion: ZIO[Any, Nothing, VersionNumber] =
      ZIO.succeed(semanticVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.LifecyclePolicyResourceSelectionRecipe
  ) extends zio.aws.imagebuilder.model.LifecyclePolicyResourceSelectionRecipe.ReadOnly {
    override val name: ResourceName =
      zio.aws.imagebuilder.model.primitives.ResourceName(impl.name())
    override val semanticVersion: VersionNumber =
      zio.aws.imagebuilder.model.primitives
        .VersionNumber(impl.semanticVersion())
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.LifecyclePolicyResourceSelectionRecipe
  ): zio.aws.imagebuilder.model.LifecyclePolicyResourceSelectionRecipe.ReadOnly =
    new Wrapper(impl)
}
