package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.{TagValue, TagKey}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class LifecyclePolicyResourceSelection(
    recipes: Optional[Iterable[
      zio.aws.imagebuilder.model.LifecyclePolicyResourceSelectionRecipe
    ]] = Optional.Absent,
    tagMap: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.LifecyclePolicyResourceSelection = {
    import LifecyclePolicyResourceSelection.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.LifecyclePolicyResourceSelection
      .builder()
      .optionallyWith(
        recipes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.recipes)
      .optionallyWith(
        tagMap.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tagMap)
      .build()
  }
  def asReadOnly
      : zio.aws.imagebuilder.model.LifecyclePolicyResourceSelection.ReadOnly =
    zio.aws.imagebuilder.model.LifecyclePolicyResourceSelection
      .wrap(buildAwsValue())
}
object LifecyclePolicyResourceSelection {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.LifecyclePolicyResourceSelection
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.imagebuilder.model.LifecyclePolicyResourceSelection =
      zio.aws.imagebuilder.model.LifecyclePolicyResourceSelection(
        recipes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        tagMap.map(value => value)
      )
    def recipes: Optional[List[
      zio.aws.imagebuilder.model.LifecyclePolicyResourceSelectionRecipe.ReadOnly
    ]]
    def tagMap: Optional[Map[TagKey, TagValue]]
    def getRecipes: ZIO[Any, AwsError, List[
      zio.aws.imagebuilder.model.LifecyclePolicyResourceSelectionRecipe.ReadOnly
    ]] = AwsError.unwrapOptionField("recipes", recipes)
    def getTagMap: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tagMap", tagMap)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.LifecyclePolicyResourceSelection
  ) extends zio.aws.imagebuilder.model.LifecyclePolicyResourceSelection.ReadOnly {
    override val recipes: Optional[List[
      zio.aws.imagebuilder.model.LifecyclePolicyResourceSelectionRecipe.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.recipes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.imagebuilder.model.LifecyclePolicyResourceSelectionRecipe
            .wrap(item)
        }.toList
      )
    override val tagMap: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tagMap())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.imagebuilder.model.primitives.TagKey(
              key
            ) -> zio.aws.imagebuilder.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.LifecyclePolicyResourceSelection
  ): zio.aws.imagebuilder.model.LifecyclePolicyResourceSelection.ReadOnly =
    new Wrapper(impl)
}
