package zio.aws.imagebuilder.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.imagebuilder.model.primitives.{
  LifecyclePolicyDetailFilterRetainAtLeast,
  LifecyclePolicyDetailFilterValue
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class LifecyclePolicyDetailFilter(
    `type`: zio.aws.imagebuilder.model.LifecyclePolicyDetailFilterType,
    value: LifecyclePolicyDetailFilterValue,
    unit: Optional[zio.aws.imagebuilder.model.LifecyclePolicyTimeUnit] =
      Optional.Absent,
    retainAtLeast: Optional[LifecyclePolicyDetailFilterRetainAtLeast] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.LifecyclePolicyDetailFilter = {
    import LifecyclePolicyDetailFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.LifecyclePolicyDetailFilter
      .builder()
      .`type`(`type`.unwrap)
      .value(LifecyclePolicyDetailFilterValue.unwrap(value): Integer)
      .optionallyWith(unit.map(value => value.unwrap))(_.unit)
      .optionallyWith(
        retainAtLeast.map(value =>
          LifecyclePolicyDetailFilterRetainAtLeast.unwrap(value): Integer
        )
      )(_.retainAtLeast)
      .build()
  }
  def asReadOnly
      : zio.aws.imagebuilder.model.LifecyclePolicyDetailFilter.ReadOnly =
    zio.aws.imagebuilder.model.LifecyclePolicyDetailFilter.wrap(buildAwsValue())
}
object LifecyclePolicyDetailFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.LifecyclePolicyDetailFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.LifecyclePolicyDetailFilter =
      zio.aws.imagebuilder.model.LifecyclePolicyDetailFilter(
        `type`,
        value,
        unit.map(value => value),
        retainAtLeast.map(value => value)
      )
    def `type`: zio.aws.imagebuilder.model.LifecyclePolicyDetailFilterType
    def value: LifecyclePolicyDetailFilterValue
    def unit: Optional[zio.aws.imagebuilder.model.LifecyclePolicyTimeUnit]
    def retainAtLeast: Optional[LifecyclePolicyDetailFilterRetainAtLeast]
    def getType: ZIO[
      Any,
      Nothing,
      zio.aws.imagebuilder.model.LifecyclePolicyDetailFilterType
    ] = ZIO.succeed(`type`)
    def getValue: ZIO[Any, Nothing, LifecyclePolicyDetailFilterValue] =
      ZIO.succeed(value)
    def getUnit: ZIO[
      Any,
      AwsError,
      zio.aws.imagebuilder.model.LifecyclePolicyTimeUnit
    ] = AwsError.unwrapOptionField("unit", unit)
    def getRetainAtLeast
        : ZIO[Any, AwsError, LifecyclePolicyDetailFilterRetainAtLeast] =
      AwsError.unwrapOptionField("retainAtLeast", retainAtLeast)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.LifecyclePolicyDetailFilter
  ) extends zio.aws.imagebuilder.model.LifecyclePolicyDetailFilter.ReadOnly {
    override val `type`
        : zio.aws.imagebuilder.model.LifecyclePolicyDetailFilterType =
      zio.aws.imagebuilder.model.LifecyclePolicyDetailFilterType
        .wrap(impl.`type`())
    override val value: LifecyclePolicyDetailFilterValue =
      zio.aws.imagebuilder.model.primitives
        .LifecyclePolicyDetailFilterValue(impl.value())
    override val unit
        : Optional[zio.aws.imagebuilder.model.LifecyclePolicyTimeUnit] =
      zio.aws.core.internal
        .optionalFromNullable(impl.unit())
        .map(value =>
          zio.aws.imagebuilder.model.LifecyclePolicyTimeUnit.wrap(value)
        )
    override val retainAtLeast
        : Optional[LifecyclePolicyDetailFilterRetainAtLeast] =
      zio.aws.core.internal
        .optionalFromNullable(impl.retainAtLeast())
        .map(value =>
          zio.aws.imagebuilder.model.primitives
            .LifecyclePolicyDetailFilterRetainAtLeast(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.LifecyclePolicyDetailFilter
  ): zio.aws.imagebuilder.model.LifecyclePolicyDetailFilter.ReadOnly =
    new Wrapper(impl)
}
