package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.{
  TagValue,
  TagKey,
  AccountId,
  NonEmptyString
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class LifecyclePolicyDetailExclusionRulesAmis(
    isPublic: Optional[Boolean] = Optional.Absent,
    regions: Optional[Iterable[NonEmptyString]] = Optional.Absent,
    sharedAccounts: Optional[Iterable[AccountId]] = Optional.Absent,
    lastLaunched: Optional[
      zio.aws.imagebuilder.model.LifecyclePolicyDetailExclusionRulesAmisLastLaunched
    ] = Optional.Absent,
    tagMap: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.LifecyclePolicyDetailExclusionRulesAmis = {
    import LifecyclePolicyDetailExclusionRulesAmis.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.LifecyclePolicyDetailExclusionRulesAmis
      .builder()
      .optionallyWith(isPublic.map(value => value: java.lang.Boolean))(
        _.isPublic
      )
      .optionallyWith(
        regions.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.regions)
      .optionallyWith(
        sharedAccounts.map(value =>
          value.map { item =>
            AccountId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.sharedAccounts)
      .optionallyWith(lastLaunched.map(value => value.buildAwsValue()))(
        _.lastLaunched
      )
      .optionallyWith(
        tagMap.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tagMap)
      .build()
  }
  def asReadOnly
      : zio.aws.imagebuilder.model.LifecyclePolicyDetailExclusionRulesAmis.ReadOnly =
    zio.aws.imagebuilder.model.LifecyclePolicyDetailExclusionRulesAmis
      .wrap(buildAwsValue())
}
object LifecyclePolicyDetailExclusionRulesAmis {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.LifecyclePolicyDetailExclusionRulesAmis
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.imagebuilder.model.LifecyclePolicyDetailExclusionRulesAmis =
      zio.aws.imagebuilder.model.LifecyclePolicyDetailExclusionRulesAmis(
        isPublic.map(value => value),
        regions.map(value => value),
        sharedAccounts.map(value => value),
        lastLaunched.map(value => value.asEditable),
        tagMap.map(value => value)
      )
    def isPublic: Optional[Boolean]
    def regions: Optional[List[NonEmptyString]]
    def sharedAccounts: Optional[List[AccountId]]
    def lastLaunched: Optional[
      zio.aws.imagebuilder.model.LifecyclePolicyDetailExclusionRulesAmisLastLaunched.ReadOnly
    ]
    def tagMap: Optional[Map[TagKey, TagValue]]
    def getIsPublic: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isPublic", isPublic)
    def getRegions: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("regions", regions)
    def getSharedAccounts: ZIO[Any, AwsError, List[AccountId]] =
      AwsError.unwrapOptionField("sharedAccounts", sharedAccounts)
    def getLastLaunched: ZIO[
      Any,
      AwsError,
      zio.aws.imagebuilder.model.LifecyclePolicyDetailExclusionRulesAmisLastLaunched.ReadOnly
    ] = AwsError.unwrapOptionField("lastLaunched", lastLaunched)
    def getTagMap: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tagMap", tagMap)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.LifecyclePolicyDetailExclusionRulesAmis
  ) extends zio.aws.imagebuilder.model.LifecyclePolicyDetailExclusionRulesAmis.ReadOnly {
    override val isPublic: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isPublic())
      .map(value => value: Boolean)
    override val regions: Optional[List[NonEmptyString]] = zio.aws.core.internal
      .optionalFromNullable(impl.regions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.imagebuilder.model.primitives.NonEmptyString(item)
        }.toList
      )
    override val sharedAccounts: Optional[List[AccountId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sharedAccounts())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.imagebuilder.model.primitives.AccountId(item)
          }.toList
        )
    override val lastLaunched: Optional[
      zio.aws.imagebuilder.model.LifecyclePolicyDetailExclusionRulesAmisLastLaunched.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.lastLaunched())
      .map(value =>
        zio.aws.imagebuilder.model.LifecyclePolicyDetailExclusionRulesAmisLastLaunched
          .wrap(value)
      )
    override val tagMap: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tagMap())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.imagebuilder.model.primitives.TagKey(
              key
            ) -> zio.aws.imagebuilder.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.LifecyclePolicyDetailExclusionRulesAmis
  ): zio.aws.imagebuilder.model.LifecyclePolicyDetailExclusionRulesAmis.ReadOnly =
    new Wrapper(impl)
}
