package zio.aws.imagebuilder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class LifecyclePolicyDetail(
    action: zio.aws.imagebuilder.model.LifecyclePolicyDetailAction,
    filter: zio.aws.imagebuilder.model.LifecyclePolicyDetailFilter,
    exclusionRules: Optional[
      zio.aws.imagebuilder.model.LifecyclePolicyDetailExclusionRules
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.LifecyclePolicyDetail = {
    import LifecyclePolicyDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.LifecyclePolicyDetail
      .builder()
      .action(action.buildAwsValue())
      .filter(filter.buildAwsValue())
      .optionallyWith(exclusionRules.map(value => value.buildAwsValue()))(
        _.exclusionRules
      )
      .build()
  }
  def asReadOnly: zio.aws.imagebuilder.model.LifecyclePolicyDetail.ReadOnly =
    zio.aws.imagebuilder.model.LifecyclePolicyDetail.wrap(buildAwsValue())
}
object LifecyclePolicyDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.LifecyclePolicyDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.LifecyclePolicyDetail =
      zio.aws.imagebuilder.model.LifecyclePolicyDetail(
        action.asEditable,
        filter.asEditable,
        exclusionRules.map(value => value.asEditable)
      )
    def action: zio.aws.imagebuilder.model.LifecyclePolicyDetailAction.ReadOnly
    def filter: zio.aws.imagebuilder.model.LifecyclePolicyDetailFilter.ReadOnly
    def exclusionRules: Optional[
      zio.aws.imagebuilder.model.LifecyclePolicyDetailExclusionRules.ReadOnly
    ]
    def getAction: ZIO[
      Any,
      Nothing,
      zio.aws.imagebuilder.model.LifecyclePolicyDetailAction.ReadOnly
    ] = ZIO.succeed(action)
    def getFilter: ZIO[
      Any,
      Nothing,
      zio.aws.imagebuilder.model.LifecyclePolicyDetailFilter.ReadOnly
    ] = ZIO.succeed(filter)
    def getExclusionRules: ZIO[
      Any,
      AwsError,
      zio.aws.imagebuilder.model.LifecyclePolicyDetailExclusionRules.ReadOnly
    ] = AwsError.unwrapOptionField("exclusionRules", exclusionRules)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.LifecyclePolicyDetail
  ) extends zio.aws.imagebuilder.model.LifecyclePolicyDetail.ReadOnly {
    override val action
        : zio.aws.imagebuilder.model.LifecyclePolicyDetailAction.ReadOnly =
      zio.aws.imagebuilder.model.LifecyclePolicyDetailAction.wrap(impl.action())
    override val filter
        : zio.aws.imagebuilder.model.LifecyclePolicyDetailFilter.ReadOnly =
      zio.aws.imagebuilder.model.LifecyclePolicyDetailFilter.wrap(impl.filter())
    override val exclusionRules: Optional[
      zio.aws.imagebuilder.model.LifecyclePolicyDetailExclusionRules.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.exclusionRules())
      .map(value =>
        zio.aws.imagebuilder.model.LifecyclePolicyDetailExclusionRules
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.LifecyclePolicyDetail
  ): zio.aws.imagebuilder.model.LifecyclePolicyDetail.ReadOnly = new Wrapper(
    impl
  )
}
