package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.NonEmptyString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class LifecycleExecutionResourceState(
    status: Optional[
      zio.aws.imagebuilder.model.LifecycleExecutionResourceStatus
    ] = Optional.Absent,
    reason: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.LifecycleExecutionResourceState = {
    import LifecycleExecutionResourceState.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.LifecycleExecutionResourceState
      .builder()
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        reason.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.reason)
      .build()
  }
  def asReadOnly
      : zio.aws.imagebuilder.model.LifecycleExecutionResourceState.ReadOnly =
    zio.aws.imagebuilder.model.LifecycleExecutionResourceState
      .wrap(buildAwsValue())
}
object LifecycleExecutionResourceState {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.LifecycleExecutionResourceState
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.LifecycleExecutionResourceState =
      zio.aws.imagebuilder.model.LifecycleExecutionResourceState(
        status.map(value => value),
        reason.map(value => value)
      )
    def status
        : Optional[zio.aws.imagebuilder.model.LifecycleExecutionResourceStatus]
    def reason: Optional[NonEmptyString]
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.imagebuilder.model.LifecycleExecutionResourceStatus
    ] = AwsError.unwrapOptionField("status", status)
    def getReason: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("reason", reason)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.LifecycleExecutionResourceState
  ) extends zio.aws.imagebuilder.model.LifecycleExecutionResourceState.ReadOnly {
    override val status: Optional[
      zio.aws.imagebuilder.model.LifecycleExecutionResourceStatus
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value =>
        zio.aws.imagebuilder.model.LifecycleExecutionResourceStatus.wrap(value)
      )
    override val reason: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.reason())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.LifecycleExecutionResourceState
  ): zio.aws.imagebuilder.model.LifecycleExecutionResourceState.ReadOnly =
    new Wrapper(impl)
}
