package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.NonEmptyString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class LifecycleExecutionResourceAction(
    name: Optional[
      zio.aws.imagebuilder.model.LifecycleExecutionResourceActionName
    ] = Optional.Absent,
    reason: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.LifecycleExecutionResourceAction = {
    import LifecycleExecutionResourceAction.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.LifecycleExecutionResourceAction
      .builder()
      .optionallyWith(name.map(value => value.unwrap))(_.name)
      .optionallyWith(
        reason.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.reason)
      .build()
  }
  def asReadOnly
      : zio.aws.imagebuilder.model.LifecycleExecutionResourceAction.ReadOnly =
    zio.aws.imagebuilder.model.LifecycleExecutionResourceAction
      .wrap(buildAwsValue())
}
object LifecycleExecutionResourceAction {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.LifecycleExecutionResourceAction
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.imagebuilder.model.LifecycleExecutionResourceAction =
      zio.aws.imagebuilder.model.LifecycleExecutionResourceAction(
        name.map(value => value),
        reason.map(value => value)
      )
    def name: Optional[
      zio.aws.imagebuilder.model.LifecycleExecutionResourceActionName
    ]
    def reason: Optional[NonEmptyString]
    def getName: ZIO[
      Any,
      AwsError,
      zio.aws.imagebuilder.model.LifecycleExecutionResourceActionName
    ] = AwsError.unwrapOptionField("name", name)
    def getReason: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("reason", reason)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.LifecycleExecutionResourceAction
  ) extends zio.aws.imagebuilder.model.LifecycleExecutionResourceAction.ReadOnly {
    override val name: Optional[
      zio.aws.imagebuilder.model.LifecycleExecutionResourceActionName
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value =>
        zio.aws.imagebuilder.model.LifecycleExecutionResourceActionName
          .wrap(value)
      )
    override val reason: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.reason())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.LifecycleExecutionResourceAction
  ): zio.aws.imagebuilder.model.LifecycleExecutionResourceAction.ReadOnly =
    new Wrapper(impl)
}
