package zio.aws.imagebuilder.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.imagebuilder.model.primitives.{DateTimeTimestamp, NonEmptyString}
import scala.jdk.CollectionConverters.*
final case class LifecycleExecutionResource(
    accountId: Optional[NonEmptyString] = Optional.Absent,
    resourceId: Optional[NonEmptyString] = Optional.Absent,
    state: Optional[
      zio.aws.imagebuilder.model.LifecycleExecutionResourceState
    ] = Optional.Absent,
    action: Optional[
      zio.aws.imagebuilder.model.LifecycleExecutionResourceAction
    ] = Optional.Absent,
    region: Optional[NonEmptyString] = Optional.Absent,
    snapshots: Optional[
      Iterable[zio.aws.imagebuilder.model.LifecycleExecutionSnapshotResource]
    ] = Optional.Absent,
    imageUris: Optional[Iterable[NonEmptyString]] = Optional.Absent,
    startTime: Optional[DateTimeTimestamp] = Optional.Absent,
    endTime: Optional[DateTimeTimestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.LifecycleExecutionResource = {
    import LifecycleExecutionResource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.LifecycleExecutionResource
      .builder()
      .optionallyWith(
        accountId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.accountId)
      .optionallyWith(
        resourceId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.resourceId)
      .optionallyWith(state.map(value => value.buildAwsValue()))(_.state)
      .optionallyWith(action.map(value => value.buildAwsValue()))(_.action)
      .optionallyWith(
        region.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.region)
      .optionallyWith(
        snapshots.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.snapshots)
      .optionallyWith(
        imageUris.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.imageUris)
      .optionallyWith(
        startTime.map(value => DateTimeTimestamp.unwrap(value): Instant)
      )(_.startTime)
      .optionallyWith(
        endTime.map(value => DateTimeTimestamp.unwrap(value): Instant)
      )(_.endTime)
      .build()
  }
  def asReadOnly
      : zio.aws.imagebuilder.model.LifecycleExecutionResource.ReadOnly =
    zio.aws.imagebuilder.model.LifecycleExecutionResource.wrap(buildAwsValue())
}
object LifecycleExecutionResource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.LifecycleExecutionResource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.LifecycleExecutionResource =
      zio.aws.imagebuilder.model.LifecycleExecutionResource(
        accountId.map(value => value),
        resourceId.map(value => value),
        state.map(value => value.asEditable),
        action.map(value => value.asEditable),
        region.map(value => value),
        snapshots.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        imageUris.map(value => value),
        startTime.map(value => value),
        endTime.map(value => value)
      )
    def accountId: Optional[NonEmptyString]
    def resourceId: Optional[NonEmptyString]
    def state: Optional[
      zio.aws.imagebuilder.model.LifecycleExecutionResourceState.ReadOnly
    ]
    def action: Optional[
      zio.aws.imagebuilder.model.LifecycleExecutionResourceAction.ReadOnly
    ]
    def region: Optional[NonEmptyString]
    def snapshots: Optional[List[
      zio.aws.imagebuilder.model.LifecycleExecutionSnapshotResource.ReadOnly
    ]]
    def imageUris: Optional[List[NonEmptyString]]
    def startTime: Optional[DateTimeTimestamp]
    def endTime: Optional[DateTimeTimestamp]
    def getAccountId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getResourceId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("resourceId", resourceId)
    def getState: ZIO[
      Any,
      AwsError,
      zio.aws.imagebuilder.model.LifecycleExecutionResourceState.ReadOnly
    ] = AwsError.unwrapOptionField("state", state)
    def getAction: ZIO[
      Any,
      AwsError,
      zio.aws.imagebuilder.model.LifecycleExecutionResourceAction.ReadOnly
    ] = AwsError.unwrapOptionField("action", action)
    def getRegion: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("region", region)
    def getSnapshots: ZIO[Any, AwsError, List[
      zio.aws.imagebuilder.model.LifecycleExecutionSnapshotResource.ReadOnly
    ]] = AwsError.unwrapOptionField("snapshots", snapshots)
    def getImageUris: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("imageUris", imageUris)
    def getStartTime: ZIO[Any, AwsError, DateTimeTimestamp] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getEndTime: ZIO[Any, AwsError, DateTimeTimestamp] =
      AwsError.unwrapOptionField("endTime", endTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.LifecycleExecutionResource
  ) extends zio.aws.imagebuilder.model.LifecycleExecutionResource.ReadOnly {
    override val accountId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.accountId())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val resourceId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceId())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val state: Optional[
      zio.aws.imagebuilder.model.LifecycleExecutionResourceState.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.state())
      .map(value =>
        zio.aws.imagebuilder.model.LifecycleExecutionResourceState.wrap(value)
      )
    override val action: Optional[
      zio.aws.imagebuilder.model.LifecycleExecutionResourceAction.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.action())
      .map(value =>
        zio.aws.imagebuilder.model.LifecycleExecutionResourceAction.wrap(value)
      )
    override val region: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.region())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val snapshots: Optional[List[
      zio.aws.imagebuilder.model.LifecycleExecutionSnapshotResource.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.snapshots())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.imagebuilder.model.LifecycleExecutionSnapshotResource
            .wrap(item)
        }.toList
      )
    override val imageUris: Optional[List[NonEmptyString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.imageUris())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.imagebuilder.model.primitives.NonEmptyString(item)
          }.toList
        )
    override val startTime: Optional[DateTimeTimestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.startTime())
      .map(value =>
        zio.aws.imagebuilder.model.primitives.DateTimeTimestamp(value)
      )
    override val endTime: Optional[DateTimeTimestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.endTime())
      .map(value =>
        zio.aws.imagebuilder.model.primitives.DateTimeTimestamp(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.LifecycleExecutionResource
  ): zio.aws.imagebuilder.model.LifecycleExecutionResource.ReadOnly =
    new Wrapper(impl)
}
