package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.{
  OrganizationalUnitArn,
  OrganizationArn,
  NonEmptyString,
  AccountId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class LaunchPermissionConfiguration(
    userIds: Optional[Iterable[AccountId]] = Optional.Absent,
    userGroups: Optional[Iterable[NonEmptyString]] = Optional.Absent,
    organizationArns: Optional[Iterable[OrganizationArn]] = Optional.Absent,
    organizationalUnitArns: Optional[Iterable[OrganizationalUnitArn]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.LaunchPermissionConfiguration = {
    import LaunchPermissionConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.LaunchPermissionConfiguration
      .builder()
      .optionallyWith(
        userIds.map(value =>
          value.map { item =>
            AccountId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.userIds)
      .optionallyWith(
        userGroups.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.userGroups)
      .optionallyWith(
        organizationArns.map(value =>
          value.map { item =>
            OrganizationArn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.organizationArns)
      .optionallyWith(
        organizationalUnitArns.map(value =>
          value.map { item =>
            OrganizationalUnitArn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.organizationalUnitArns)
      .build()
  }
  def asReadOnly
      : zio.aws.imagebuilder.model.LaunchPermissionConfiguration.ReadOnly =
    zio.aws.imagebuilder.model.LaunchPermissionConfiguration
      .wrap(buildAwsValue())
}
object LaunchPermissionConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.LaunchPermissionConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.LaunchPermissionConfiguration =
      zio.aws.imagebuilder.model.LaunchPermissionConfiguration(
        userIds.map(value => value),
        userGroups.map(value => value),
        organizationArns.map(value => value),
        organizationalUnitArns.map(value => value)
      )
    def userIds: Optional[List[AccountId]]
    def userGroups: Optional[List[NonEmptyString]]
    def organizationArns: Optional[List[OrganizationArn]]
    def organizationalUnitArns: Optional[List[OrganizationalUnitArn]]
    def getUserIds: ZIO[Any, AwsError, List[AccountId]] =
      AwsError.unwrapOptionField("userIds", userIds)
    def getUserGroups: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("userGroups", userGroups)
    def getOrganizationArns: ZIO[Any, AwsError, List[OrganizationArn]] =
      AwsError.unwrapOptionField("organizationArns", organizationArns)
    def getOrganizationalUnitArns
        : ZIO[Any, AwsError, List[OrganizationalUnitArn]] = AwsError
      .unwrapOptionField("organizationalUnitArns", organizationalUnitArns)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.LaunchPermissionConfiguration
  ) extends zio.aws.imagebuilder.model.LaunchPermissionConfiguration.ReadOnly {
    override val userIds: Optional[List[AccountId]] = zio.aws.core.internal
      .optionalFromNullable(impl.userIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.imagebuilder.model.primitives.AccountId(item)
        }.toList
      )
    override val userGroups: Optional[List[NonEmptyString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.userGroups())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.imagebuilder.model.primitives.NonEmptyString(item)
          }.toList
        )
    override val organizationArns: Optional[List[OrganizationArn]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.organizationArns())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.imagebuilder.model.primitives.OrganizationArn(item)
          }.toList
        )
    override val organizationalUnitArns: Optional[List[OrganizationalUnitArn]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.organizationalUnitArns())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.imagebuilder.model.primitives.OrganizationalUnitArn(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.LaunchPermissionConfiguration
  ): zio.aws.imagebuilder.model.LaunchPermissionConfiguration.ReadOnly =
    new Wrapper(impl)
}
