package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.{
  InstanceProfileNameType,
  ImageBuilderArn,
  TagValue,
  InstanceType,
  DateTime,
  NullableBoolean,
  NonEmptyString,
  ResourceName,
  TagKey
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class InfrastructureConfiguration(
    arn: Optional[ImageBuilderArn] = Optional.Absent,
    name: Optional[ResourceName] = Optional.Absent,
    description: Optional[NonEmptyString] = Optional.Absent,
    instanceTypes: Optional[Iterable[InstanceType]] = Optional.Absent,
    instanceProfileName: Optional[InstanceProfileNameType] = Optional.Absent,
    securityGroupIds: Optional[Iterable[NonEmptyString]] = Optional.Absent,
    subnetId: Optional[NonEmptyString] = Optional.Absent,
    logging: Optional[zio.aws.imagebuilder.model.Logging] = Optional.Absent,
    keyPair: Optional[NonEmptyString] = Optional.Absent,
    terminateInstanceOnFailure: Optional[NullableBoolean] = Optional.Absent,
    snsTopicArn: Optional[NonEmptyString] = Optional.Absent,
    dateCreated: Optional[DateTime] = Optional.Absent,
    dateUpdated: Optional[DateTime] = Optional.Absent,
    resourceTags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    instanceMetadataOptions: Optional[
      zio.aws.imagebuilder.model.InstanceMetadataOptions
    ] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    placement: Optional[zio.aws.imagebuilder.model.Placement] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.InfrastructureConfiguration = {
    import InfrastructureConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.InfrastructureConfiguration
      .builder()
      .optionallyWith(
        arn.map(value => ImageBuilderArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        name.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        instanceTypes.map(value =>
          value.map { item =>
            InstanceType.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.instanceTypes)
      .optionallyWith(
        instanceProfileName.map(value =>
          InstanceProfileNameType.unwrap(value): java.lang.String
        )
      )(_.instanceProfileName)
      .optionallyWith(
        securityGroupIds.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroupIds)
      .optionallyWith(
        subnetId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.subnetId)
      .optionallyWith(logging.map(value => value.buildAwsValue()))(_.logging)
      .optionallyWith(
        keyPair.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.keyPair)
      .optionallyWith(
        terminateInstanceOnFailure.map(value => value: java.lang.Boolean)
      )(_.terminateInstanceOnFailure)
      .optionallyWith(
        snsTopicArn.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.snsTopicArn)
      .optionallyWith(
        dateCreated.map(value => DateTime.unwrap(value): java.lang.String)
      )(_.dateCreated)
      .optionallyWith(
        dateUpdated.map(value => DateTime.unwrap(value): java.lang.String)
      )(_.dateUpdated)
      .optionallyWith(
        resourceTags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.resourceTags)
      .optionallyWith(
        instanceMetadataOptions.map(value => value.buildAwsValue())
      )(_.instanceMetadataOptions)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(placement.map(value => value.buildAwsValue()))(
        _.placement
      )
      .build()
  }
  def asReadOnly
      : zio.aws.imagebuilder.model.InfrastructureConfiguration.ReadOnly =
    zio.aws.imagebuilder.model.InfrastructureConfiguration.wrap(buildAwsValue())
}
object InfrastructureConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.InfrastructureConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.InfrastructureConfiguration =
      zio.aws.imagebuilder.model.InfrastructureConfiguration(
        arn.map(value => value),
        name.map(value => value),
        description.map(value => value),
        instanceTypes.map(value => value),
        instanceProfileName.map(value => value),
        securityGroupIds.map(value => value),
        subnetId.map(value => value),
        logging.map(value => value.asEditable),
        keyPair.map(value => value),
        terminateInstanceOnFailure.map(value => value),
        snsTopicArn.map(value => value),
        dateCreated.map(value => value),
        dateUpdated.map(value => value),
        resourceTags.map(value => value),
        instanceMetadataOptions.map(value => value.asEditable),
        tags.map(value => value),
        placement.map(value => value.asEditable)
      )
    def arn: Optional[ImageBuilderArn]
    def name: Optional[ResourceName]
    def description: Optional[NonEmptyString]
    def instanceTypes: Optional[List[InstanceType]]
    def instanceProfileName: Optional[InstanceProfileNameType]
    def securityGroupIds: Optional[List[NonEmptyString]]
    def subnetId: Optional[NonEmptyString]
    def logging: Optional[zio.aws.imagebuilder.model.Logging.ReadOnly]
    def keyPair: Optional[NonEmptyString]
    def terminateInstanceOnFailure: Optional[NullableBoolean]
    def snsTopicArn: Optional[NonEmptyString]
    def dateCreated: Optional[DateTime]
    def dateUpdated: Optional[DateTime]
    def resourceTags: Optional[Map[TagKey, TagValue]]
    def instanceMetadataOptions
        : Optional[zio.aws.imagebuilder.model.InstanceMetadataOptions.ReadOnly]
    def tags: Optional[Map[TagKey, TagValue]]
    def placement: Optional[zio.aws.imagebuilder.model.Placement.ReadOnly]
    def getArn: ZIO[Any, AwsError, ImageBuilderArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("description", description)
    def getInstanceTypes: ZIO[Any, AwsError, List[InstanceType]] =
      AwsError.unwrapOptionField("instanceTypes", instanceTypes)
    def getInstanceProfileName: ZIO[Any, AwsError, InstanceProfileNameType] =
      AwsError.unwrapOptionField("instanceProfileName", instanceProfileName)
    def getSecurityGroupIds: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("securityGroupIds", securityGroupIds)
    def getSubnetId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("subnetId", subnetId)
    def getLogging
        : ZIO[Any, AwsError, zio.aws.imagebuilder.model.Logging.ReadOnly] =
      AwsError.unwrapOptionField("logging", logging)
    def getKeyPair: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("keyPair", keyPair)
    def getTerminateInstanceOnFailure: ZIO[Any, AwsError, NullableBoolean] =
      AwsError.unwrapOptionField(
        "terminateInstanceOnFailure",
        terminateInstanceOnFailure
      )
    def getSnsTopicArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("snsTopicArn", snsTopicArn)
    def getDateCreated: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("dateCreated", dateCreated)
    def getDateUpdated: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("dateUpdated", dateUpdated)
    def getResourceTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("resourceTags", resourceTags)
    def getInstanceMetadataOptions: ZIO[
      Any,
      AwsError,
      zio.aws.imagebuilder.model.InstanceMetadataOptions.ReadOnly
    ] = AwsError.unwrapOptionField(
      "instanceMetadataOptions",
      instanceMetadataOptions
    )
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getPlacement
        : ZIO[Any, AwsError, zio.aws.imagebuilder.model.Placement.ReadOnly] =
      AwsError.unwrapOptionField("placement", placement)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.InfrastructureConfiguration
  ) extends zio.aws.imagebuilder.model.InfrastructureConfiguration.ReadOnly {
    override val arn: Optional[ImageBuilderArn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value =>
        zio.aws.imagebuilder.model.primitives.ImageBuilderArn(value)
      )
    override val name: Optional[ResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.imagebuilder.model.primitives.ResourceName(value))
    override val description: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val instanceTypes: Optional[List[InstanceType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceTypes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.imagebuilder.model.primitives.InstanceType(item)
          }.toList
        )
    override val instanceProfileName: Optional[InstanceProfileNameType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceProfileName())
        .map(value =>
          zio.aws.imagebuilder.model.primitives.InstanceProfileNameType(value)
        )
    override val securityGroupIds: Optional[List[NonEmptyString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityGroupIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.imagebuilder.model.primitives.NonEmptyString(item)
          }.toList
        )
    override val subnetId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.subnetId())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val logging
        : Optional[zio.aws.imagebuilder.model.Logging.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.logging())
        .map(value => zio.aws.imagebuilder.model.Logging.wrap(value))
    override val keyPair: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.keyPair())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val terminateInstanceOnFailure: Optional[NullableBoolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.terminateInstanceOnFailure())
        .map(value => value: NullableBoolean)
    override val snsTopicArn: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.snsTopicArn())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val dateCreated: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.dateCreated())
      .map(value => zio.aws.imagebuilder.model.primitives.DateTime(value))
    override val dateUpdated: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.dateUpdated())
      .map(value => zio.aws.imagebuilder.model.primitives.DateTime(value))
    override val resourceTags: Optional[Map[TagKey, TagValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceTags())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.imagebuilder.model.primitives.TagKey(
                key
              ) -> zio.aws.imagebuilder.model.primitives.TagValue(value)
            })
            .toMap
        )
    override val instanceMetadataOptions: Optional[
      zio.aws.imagebuilder.model.InstanceMetadataOptions.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceMetadataOptions())
      .map(value =>
        zio.aws.imagebuilder.model.InstanceMetadataOptions.wrap(value)
      )
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.imagebuilder.model.primitives.TagKey(
              key
            ) -> zio.aws.imagebuilder.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val placement
        : Optional[zio.aws.imagebuilder.model.Placement.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.placement())
        .map(value => zio.aws.imagebuilder.model.Placement.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.InfrastructureConfiguration
  ): zio.aws.imagebuilder.model.InfrastructureConfiguration.ReadOnly =
    new Wrapper(impl)
}
