package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.{
  RoleNameOrArn,
  InfrastructureConfigurationArn,
  TagValue,
  Uri,
  VersionNumber,
  ClientToken,
  OsVersion,
  NonEmptyString,
  TagKey
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ImportDiskImageRequest(
    name: NonEmptyString,
    semanticVersion: VersionNumber,
    description: Optional[NonEmptyString] = Optional.Absent,
    platform: NonEmptyString,
    osVersion: OsVersion,
    executionRole: Optional[RoleNameOrArn] = Optional.Absent,
    infrastructureConfigurationArn: InfrastructureConfigurationArn,
    uri: Uri,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    clientToken: ClientToken
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.ImportDiskImageRequest = {
    import ImportDiskImageRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.ImportDiskImageRequest
      .builder()
      .name(NonEmptyString.unwrap(name): java.lang.String)
      .semanticVersion(VersionNumber.unwrap(semanticVersion): java.lang.String)
      .optionallyWith(
        description.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.description)
      .platform(NonEmptyString.unwrap(platform): java.lang.String)
      .osVersion(OsVersion.unwrap(osVersion): java.lang.String)
      .optionallyWith(
        executionRole.map(value =>
          RoleNameOrArn.unwrap(value): java.lang.String
        )
      )(_.executionRole)
      .infrastructureConfigurationArn(
        InfrastructureConfigurationArn.unwrap(
          infrastructureConfigurationArn
        ): java.lang.String
      )
      .uri(Uri.unwrap(uri): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .clientToken(ClientToken.unwrap(clientToken): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.imagebuilder.model.ImportDiskImageRequest.ReadOnly =
    zio.aws.imagebuilder.model.ImportDiskImageRequest.wrap(buildAwsValue())
}
object ImportDiskImageRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.ImportDiskImageRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.ImportDiskImageRequest =
      zio.aws.imagebuilder.model.ImportDiskImageRequest(
        name,
        semanticVersion,
        description.map(value => value),
        platform,
        osVersion,
        executionRole.map(value => value),
        infrastructureConfigurationArn,
        uri,
        tags.map(value => value),
        clientToken
      )
    def name: NonEmptyString
    def semanticVersion: VersionNumber
    def description: Optional[NonEmptyString]
    def platform: NonEmptyString
    def osVersion: OsVersion
    def executionRole: Optional[RoleNameOrArn]
    def infrastructureConfigurationArn: InfrastructureConfigurationArn
    def uri: Uri
    def tags: Optional[Map[TagKey, TagValue]]
    def clientToken: ClientToken
    def getName: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(name)
    def getSemanticVersion: ZIO[Any, Nothing, VersionNumber] =
      ZIO.succeed(semanticVersion)
    def getDescription: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("description", description)
    def getPlatform: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(platform)
    def getOsVersion: ZIO[Any, Nothing, OsVersion] = ZIO.succeed(osVersion)
    def getExecutionRole: ZIO[Any, AwsError, RoleNameOrArn] =
      AwsError.unwrapOptionField("executionRole", executionRole)
    def getInfrastructureConfigurationArn
        : ZIO[Any, Nothing, InfrastructureConfigurationArn] =
      ZIO.succeed(infrastructureConfigurationArn)
    def getUri: ZIO[Any, Nothing, Uri] = ZIO.succeed(uri)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getClientToken: ZIO[Any, Nothing, ClientToken] =
      ZIO.succeed(clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.ImportDiskImageRequest
  ) extends zio.aws.imagebuilder.model.ImportDiskImageRequest.ReadOnly {
    override val name: NonEmptyString =
      zio.aws.imagebuilder.model.primitives.NonEmptyString(impl.name())
    override val semanticVersion: VersionNumber =
      zio.aws.imagebuilder.model.primitives
        .VersionNumber(impl.semanticVersion())
    override val description: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val platform: NonEmptyString =
      zio.aws.imagebuilder.model.primitives.NonEmptyString(impl.platform())
    override val osVersion: OsVersion =
      zio.aws.imagebuilder.model.primitives.OsVersion(impl.osVersion())
    override val executionRole: Optional[RoleNameOrArn] = zio.aws.core.internal
      .optionalFromNullable(impl.executionRole())
      .map(value => zio.aws.imagebuilder.model.primitives.RoleNameOrArn(value))
    override val infrastructureConfigurationArn
        : InfrastructureConfigurationArn = zio.aws.imagebuilder.model.primitives
      .InfrastructureConfigurationArn(impl.infrastructureConfigurationArn())
    override val uri: Uri =
      zio.aws.imagebuilder.model.primitives.Uri(impl.uri())
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.imagebuilder.model.primitives.TagKey(
              key
            ) -> zio.aws.imagebuilder.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val clientToken: ClientToken =
      zio.aws.imagebuilder.model.primitives.ClientToken(impl.clientToken())
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.ImportDiskImageRequest
  ): zio.aws.imagebuilder.model.ImportDiskImageRequest.ReadOnly = new Wrapper(
    impl
  )
}
