package zio.aws.imagebuilder.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.imagebuilder.model.primitives.{
  RoleNameOrArn,
  ImageBuilderArn,
  TagValue,
  Arn,
  DateTime,
  VersionNumber,
  LifecycleExecutionId,
  OsVersion,
  NullableBoolean,
  DateTimeTimestamp,
  ResourceName,
  TagKey
}
import scala.jdk.CollectionConverters.*
final case class Image(
    arn: Optional[ImageBuilderArn] = Optional.Absent,
    `type`: Optional[zio.aws.imagebuilder.model.ImageType] = Optional.Absent,
    name: Optional[ResourceName] = Optional.Absent,
    version: Optional[VersionNumber] = Optional.Absent,
    platform: Optional[zio.aws.imagebuilder.model.Platform] = Optional.Absent,
    enhancedImageMetadataEnabled: Optional[NullableBoolean] = Optional.Absent,
    osVersion: Optional[OsVersion] = Optional.Absent,
    state: Optional[zio.aws.imagebuilder.model.ImageState] = Optional.Absent,
    imageRecipe: Optional[zio.aws.imagebuilder.model.ImageRecipe] =
      Optional.Absent,
    containerRecipe: Optional[zio.aws.imagebuilder.model.ContainerRecipe] =
      Optional.Absent,
    sourcePipelineName: Optional[ResourceName] = Optional.Absent,
    sourcePipelineArn: Optional[Arn] = Optional.Absent,
    infrastructureConfiguration: Optional[
      zio.aws.imagebuilder.model.InfrastructureConfiguration
    ] = Optional.Absent,
    distributionConfiguration: Optional[
      zio.aws.imagebuilder.model.DistributionConfiguration
    ] = Optional.Absent,
    imageTestsConfiguration: Optional[
      zio.aws.imagebuilder.model.ImageTestsConfiguration
    ] = Optional.Absent,
    dateCreated: Optional[DateTime] = Optional.Absent,
    outputResources: Optional[zio.aws.imagebuilder.model.OutputResources] =
      Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    buildType: Optional[zio.aws.imagebuilder.model.BuildType] = Optional.Absent,
    imageSource: Optional[zio.aws.imagebuilder.model.ImageSource] =
      Optional.Absent,
    scanState: Optional[zio.aws.imagebuilder.model.ImageScanState] =
      Optional.Absent,
    imageScanningConfiguration: Optional[
      zio.aws.imagebuilder.model.ImageScanningConfiguration
    ] = Optional.Absent,
    deprecationTime: Optional[DateTimeTimestamp] = Optional.Absent,
    lifecycleExecutionId: Optional[LifecycleExecutionId] = Optional.Absent,
    executionRole: Optional[RoleNameOrArn] = Optional.Absent,
    workflows: Optional[
      Iterable[zio.aws.imagebuilder.model.WorkflowConfiguration]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.Image = {
    import Image.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.Image
      .builder()
      .optionallyWith(
        arn.map(value => ImageBuilderArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        name.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        version.map(value => VersionNumber.unwrap(value): java.lang.String)
      )(_.version)
      .optionallyWith(platform.map(value => value.unwrap))(_.platform)
      .optionallyWith(
        enhancedImageMetadataEnabled.map(value => value: java.lang.Boolean)
      )(_.enhancedImageMetadataEnabled)
      .optionallyWith(
        osVersion.map(value => OsVersion.unwrap(value): java.lang.String)
      )(_.osVersion)
      .optionallyWith(state.map(value => value.buildAwsValue()))(_.state)
      .optionallyWith(imageRecipe.map(value => value.buildAwsValue()))(
        _.imageRecipe
      )
      .optionallyWith(containerRecipe.map(value => value.buildAwsValue()))(
        _.containerRecipe
      )
      .optionallyWith(
        sourcePipelineName.map(value =>
          ResourceName.unwrap(value): java.lang.String
        )
      )(_.sourcePipelineName)
      .optionallyWith(
        sourcePipelineArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.sourcePipelineArn)
      .optionallyWith(
        infrastructureConfiguration.map(value => value.buildAwsValue())
      )(_.infrastructureConfiguration)
      .optionallyWith(
        distributionConfiguration.map(value => value.buildAwsValue())
      )(_.distributionConfiguration)
      .optionallyWith(
        imageTestsConfiguration.map(value => value.buildAwsValue())
      )(_.imageTestsConfiguration)
      .optionallyWith(
        dateCreated.map(value => DateTime.unwrap(value): java.lang.String)
      )(_.dateCreated)
      .optionallyWith(outputResources.map(value => value.buildAwsValue()))(
        _.outputResources
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(buildType.map(value => value.unwrap))(_.buildType)
      .optionallyWith(imageSource.map(value => value.unwrap))(_.imageSource)
      .optionallyWith(scanState.map(value => value.buildAwsValue()))(
        _.scanState
      )
      .optionallyWith(
        imageScanningConfiguration.map(value => value.buildAwsValue())
      )(_.imageScanningConfiguration)
      .optionallyWith(
        deprecationTime.map(value => DateTimeTimestamp.unwrap(value): Instant)
      )(_.deprecationTime)
      .optionallyWith(
        lifecycleExecutionId.map(value =>
          LifecycleExecutionId.unwrap(value): java.lang.String
        )
      )(_.lifecycleExecutionId)
      .optionallyWith(
        executionRole.map(value =>
          RoleNameOrArn.unwrap(value): java.lang.String
        )
      )(_.executionRole)
      .optionallyWith(
        workflows.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.workflows)
      .build()
  }
  def asReadOnly: zio.aws.imagebuilder.model.Image.ReadOnly =
    zio.aws.imagebuilder.model.Image.wrap(buildAwsValue())
}
object Image {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.Image
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.Image =
      zio.aws.imagebuilder.model.Image(
        arn.map(value => value),
        `type`.map(value => value),
        name.map(value => value),
        version.map(value => value),
        platform.map(value => value),
        enhancedImageMetadataEnabled.map(value => value),
        osVersion.map(value => value),
        state.map(value => value.asEditable),
        imageRecipe.map(value => value.asEditable),
        containerRecipe.map(value => value.asEditable),
        sourcePipelineName.map(value => value),
        sourcePipelineArn.map(value => value),
        infrastructureConfiguration.map(value => value.asEditable),
        distributionConfiguration.map(value => value.asEditable),
        imageTestsConfiguration.map(value => value.asEditable),
        dateCreated.map(value => value),
        outputResources.map(value => value.asEditable),
        tags.map(value => value),
        buildType.map(value => value),
        imageSource.map(value => value),
        scanState.map(value => value.asEditable),
        imageScanningConfiguration.map(value => value.asEditable),
        deprecationTime.map(value => value),
        lifecycleExecutionId.map(value => value),
        executionRole.map(value => value),
        workflows.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def arn: Optional[ImageBuilderArn]
    def `type`: Optional[zio.aws.imagebuilder.model.ImageType]
    def name: Optional[ResourceName]
    def version: Optional[VersionNumber]
    def platform: Optional[zio.aws.imagebuilder.model.Platform]
    def enhancedImageMetadataEnabled: Optional[NullableBoolean]
    def osVersion: Optional[OsVersion]
    def state: Optional[zio.aws.imagebuilder.model.ImageState.ReadOnly]
    def imageRecipe: Optional[zio.aws.imagebuilder.model.ImageRecipe.ReadOnly]
    def containerRecipe
        : Optional[zio.aws.imagebuilder.model.ContainerRecipe.ReadOnly]
    def sourcePipelineName: Optional[ResourceName]
    def sourcePipelineArn: Optional[Arn]
    def infrastructureConfiguration: Optional[
      zio.aws.imagebuilder.model.InfrastructureConfiguration.ReadOnly
    ]
    def distributionConfiguration: Optional[
      zio.aws.imagebuilder.model.DistributionConfiguration.ReadOnly
    ]
    def imageTestsConfiguration
        : Optional[zio.aws.imagebuilder.model.ImageTestsConfiguration.ReadOnly]
    def dateCreated: Optional[DateTime]
    def outputResources
        : Optional[zio.aws.imagebuilder.model.OutputResources.ReadOnly]
    def tags: Optional[Map[TagKey, TagValue]]
    def buildType: Optional[zio.aws.imagebuilder.model.BuildType]
    def imageSource: Optional[zio.aws.imagebuilder.model.ImageSource]
    def scanState: Optional[zio.aws.imagebuilder.model.ImageScanState.ReadOnly]
    def imageScanningConfiguration: Optional[
      zio.aws.imagebuilder.model.ImageScanningConfiguration.ReadOnly
    ]
    def deprecationTime: Optional[DateTimeTimestamp]
    def lifecycleExecutionId: Optional[LifecycleExecutionId]
    def executionRole: Optional[RoleNameOrArn]
    def workflows: Optional[
      List[zio.aws.imagebuilder.model.WorkflowConfiguration.ReadOnly]
    ]
    def getArn: ZIO[Any, AwsError, ImageBuilderArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getType: ZIO[Any, AwsError, zio.aws.imagebuilder.model.ImageType] =
      AwsError.unwrapOptionField("type", `type`)
    def getName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("name", name)
    def getVersion: ZIO[Any, AwsError, VersionNumber] =
      AwsError.unwrapOptionField("version", version)
    def getPlatform: ZIO[Any, AwsError, zio.aws.imagebuilder.model.Platform] =
      AwsError.unwrapOptionField("platform", platform)
    def getEnhancedImageMetadataEnabled: ZIO[Any, AwsError, NullableBoolean] =
      AwsError.unwrapOptionField(
        "enhancedImageMetadataEnabled",
        enhancedImageMetadataEnabled
      )
    def getOsVersion: ZIO[Any, AwsError, OsVersion] =
      AwsError.unwrapOptionField("osVersion", osVersion)
    def getState
        : ZIO[Any, AwsError, zio.aws.imagebuilder.model.ImageState.ReadOnly] =
      AwsError.unwrapOptionField("state", state)
    def getImageRecipe
        : ZIO[Any, AwsError, zio.aws.imagebuilder.model.ImageRecipe.ReadOnly] =
      AwsError.unwrapOptionField("imageRecipe", imageRecipe)
    def getContainerRecipe: ZIO[
      Any,
      AwsError,
      zio.aws.imagebuilder.model.ContainerRecipe.ReadOnly
    ] = AwsError.unwrapOptionField("containerRecipe", containerRecipe)
    def getSourcePipelineName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("sourcePipelineName", sourcePipelineName)
    def getSourcePipelineArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("sourcePipelineArn", sourcePipelineArn)
    def getInfrastructureConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.imagebuilder.model.InfrastructureConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "infrastructureConfiguration",
      infrastructureConfiguration
    )
    def getDistributionConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.imagebuilder.model.DistributionConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "distributionConfiguration",
      distributionConfiguration
    )
    def getImageTestsConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.imagebuilder.model.ImageTestsConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "imageTestsConfiguration",
      imageTestsConfiguration
    )
    def getDateCreated: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("dateCreated", dateCreated)
    def getOutputResources: ZIO[
      Any,
      AwsError,
      zio.aws.imagebuilder.model.OutputResources.ReadOnly
    ] = AwsError.unwrapOptionField("outputResources", outputResources)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getBuildType: ZIO[Any, AwsError, zio.aws.imagebuilder.model.BuildType] =
      AwsError.unwrapOptionField("buildType", buildType)
    def getImageSource
        : ZIO[Any, AwsError, zio.aws.imagebuilder.model.ImageSource] =
      AwsError.unwrapOptionField("imageSource", imageSource)
    def getScanState: ZIO[
      Any,
      AwsError,
      zio.aws.imagebuilder.model.ImageScanState.ReadOnly
    ] = AwsError.unwrapOptionField("scanState", scanState)
    def getImageScanningConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.imagebuilder.model.ImageScanningConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "imageScanningConfiguration",
      imageScanningConfiguration
    )
    def getDeprecationTime: ZIO[Any, AwsError, DateTimeTimestamp] =
      AwsError.unwrapOptionField("deprecationTime", deprecationTime)
    def getLifecycleExecutionId: ZIO[Any, AwsError, LifecycleExecutionId] =
      AwsError.unwrapOptionField("lifecycleExecutionId", lifecycleExecutionId)
    def getExecutionRole: ZIO[Any, AwsError, RoleNameOrArn] =
      AwsError.unwrapOptionField("executionRole", executionRole)
    def getWorkflows: ZIO[Any, AwsError, List[
      zio.aws.imagebuilder.model.WorkflowConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField("workflows", workflows)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.Image
  ) extends zio.aws.imagebuilder.model.Image.ReadOnly {
    override val arn: Optional[ImageBuilderArn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value =>
        zio.aws.imagebuilder.model.primitives.ImageBuilderArn(value)
      )
    override val `type`: Optional[zio.aws.imagebuilder.model.ImageType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.imagebuilder.model.ImageType.wrap(value))
    override val name: Optional[ResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.imagebuilder.model.primitives.ResourceName(value))
    override val version: Optional[VersionNumber] = zio.aws.core.internal
      .optionalFromNullable(impl.version())
      .map(value => zio.aws.imagebuilder.model.primitives.VersionNumber(value))
    override val platform: Optional[zio.aws.imagebuilder.model.Platform] =
      zio.aws.core.internal
        .optionalFromNullable(impl.platform())
        .map(value => zio.aws.imagebuilder.model.Platform.wrap(value))
    override val enhancedImageMetadataEnabled: Optional[NullableBoolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enhancedImageMetadataEnabled())
        .map(value => value: NullableBoolean)
    override val osVersion: Optional[OsVersion] = zio.aws.core.internal
      .optionalFromNullable(impl.osVersion())
      .map(value => zio.aws.imagebuilder.model.primitives.OsVersion(value))
    override val state
        : Optional[zio.aws.imagebuilder.model.ImageState.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.imagebuilder.model.ImageState.wrap(value))
    override val imageRecipe
        : Optional[zio.aws.imagebuilder.model.ImageRecipe.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.imageRecipe())
        .map(value => zio.aws.imagebuilder.model.ImageRecipe.wrap(value))
    override val containerRecipe
        : Optional[zio.aws.imagebuilder.model.ContainerRecipe.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.containerRecipe())
        .map(value => zio.aws.imagebuilder.model.ContainerRecipe.wrap(value))
    override val sourcePipelineName: Optional[ResourceName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourcePipelineName())
        .map(value => zio.aws.imagebuilder.model.primitives.ResourceName(value))
    override val sourcePipelineArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.sourcePipelineArn())
      .map(value => zio.aws.imagebuilder.model.primitives.Arn(value))
    override val infrastructureConfiguration: Optional[
      zio.aws.imagebuilder.model.InfrastructureConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.infrastructureConfiguration())
      .map(value =>
        zio.aws.imagebuilder.model.InfrastructureConfiguration.wrap(value)
      )
    override val distributionConfiguration: Optional[
      zio.aws.imagebuilder.model.DistributionConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.distributionConfiguration())
      .map(value =>
        zio.aws.imagebuilder.model.DistributionConfiguration.wrap(value)
      )
    override val imageTestsConfiguration: Optional[
      zio.aws.imagebuilder.model.ImageTestsConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.imageTestsConfiguration())
      .map(value =>
        zio.aws.imagebuilder.model.ImageTestsConfiguration.wrap(value)
      )
    override val dateCreated: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.dateCreated())
      .map(value => zio.aws.imagebuilder.model.primitives.DateTime(value))
    override val outputResources
        : Optional[zio.aws.imagebuilder.model.OutputResources.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.outputResources())
        .map(value => zio.aws.imagebuilder.model.OutputResources.wrap(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.imagebuilder.model.primitives.TagKey(
              key
            ) -> zio.aws.imagebuilder.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val buildType: Optional[zio.aws.imagebuilder.model.BuildType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.buildType())
        .map(value => zio.aws.imagebuilder.model.BuildType.wrap(value))
    override val imageSource: Optional[zio.aws.imagebuilder.model.ImageSource] =
      zio.aws.core.internal
        .optionalFromNullable(impl.imageSource())
        .map(value => zio.aws.imagebuilder.model.ImageSource.wrap(value))
    override val scanState
        : Optional[zio.aws.imagebuilder.model.ImageScanState.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scanState())
        .map(value => zio.aws.imagebuilder.model.ImageScanState.wrap(value))
    override val imageScanningConfiguration: Optional[
      zio.aws.imagebuilder.model.ImageScanningConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.imageScanningConfiguration())
      .map(value =>
        zio.aws.imagebuilder.model.ImageScanningConfiguration.wrap(value)
      )
    override val deprecationTime: Optional[DateTimeTimestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deprecationTime())
        .map(value =>
          zio.aws.imagebuilder.model.primitives.DateTimeTimestamp(value)
        )
    override val lifecycleExecutionId: Optional[LifecycleExecutionId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lifecycleExecutionId())
        .map(value =>
          zio.aws.imagebuilder.model.primitives.LifecycleExecutionId(value)
        )
    override val executionRole: Optional[RoleNameOrArn] = zio.aws.core.internal
      .optionalFromNullable(impl.executionRole())
      .map(value => zio.aws.imagebuilder.model.primitives.RoleNameOrArn(value))
    override val workflows: Optional[
      List[zio.aws.imagebuilder.model.WorkflowConfiguration.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.workflows())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.imagebuilder.model.WorkflowConfiguration.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.Image
  ): zio.aws.imagebuilder.model.Image.ReadOnly = new Wrapper(impl)
}
