package zio.aws.imagebuilder.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.imagebuilder.model.primitives.{
  WorkflowStepInputs,
  WorkflowStepDescription,
  WorkflowStepOutputs,
  WorkflowExecutionId,
  DateTime,
  ImageBuildVersionArn,
  WorkflowStepExecutionId,
  WorkflowStepAction,
  WorkflowBuildVersionArn,
  WorkflowStepName,
  WorkflowStepTimeoutSecondsInteger,
  WorkflowStepMessage,
  NonEmptyString
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class GetWorkflowStepExecutionResponse(
    requestId: Optional[NonEmptyString] = Optional.Absent,
    stepExecutionId: Optional[WorkflowStepExecutionId] = Optional.Absent,
    workflowBuildVersionArn: Optional[WorkflowBuildVersionArn] =
      Optional.Absent,
    workflowExecutionId: Optional[WorkflowExecutionId] = Optional.Absent,
    imageBuildVersionArn: Optional[ImageBuildVersionArn] = Optional.Absent,
    name: Optional[WorkflowStepName] = Optional.Absent,
    description: Optional[WorkflowStepDescription] = Optional.Absent,
    action: Optional[WorkflowStepAction] = Optional.Absent,
    status: Optional[zio.aws.imagebuilder.model.WorkflowStepExecutionStatus] =
      Optional.Absent,
    rollbackStatus: Optional[
      zio.aws.imagebuilder.model.WorkflowStepExecutionRollbackStatus
    ] = Optional.Absent,
    message: Optional[WorkflowStepMessage] = Optional.Absent,
    inputs: Optional[WorkflowStepInputs] = Optional.Absent,
    outputs: Optional[WorkflowStepOutputs] = Optional.Absent,
    startTime: Optional[DateTime] = Optional.Absent,
    endTime: Optional[DateTime] = Optional.Absent,
    onFailure: Optional[NonEmptyString] = Optional.Absent,
    timeoutSeconds: Optional[WorkflowStepTimeoutSecondsInteger] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.GetWorkflowStepExecutionResponse = {
    import GetWorkflowStepExecutionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.GetWorkflowStepExecutionResponse
      .builder()
      .optionallyWith(
        requestId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.requestId)
      .optionallyWith(
        stepExecutionId.map(value =>
          WorkflowStepExecutionId.unwrap(value): java.lang.String
        )
      )(_.stepExecutionId)
      .optionallyWith(
        workflowBuildVersionArn.map(value =>
          WorkflowBuildVersionArn.unwrap(value): java.lang.String
        )
      )(_.workflowBuildVersionArn)
      .optionallyWith(
        workflowExecutionId.map(value =>
          WorkflowExecutionId.unwrap(value): java.lang.String
        )
      )(_.workflowExecutionId)
      .optionallyWith(
        imageBuildVersionArn.map(value =>
          ImageBuildVersionArn.unwrap(value): java.lang.String
        )
      )(_.imageBuildVersionArn)
      .optionallyWith(
        name.map(value => WorkflowStepName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value =>
          WorkflowStepDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        action.map(value => WorkflowStepAction.unwrap(value): java.lang.String)
      )(_.action)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(rollbackStatus.map(value => value.unwrap))(
        _.rollbackStatus
      )
      .optionallyWith(
        message.map(value =>
          WorkflowStepMessage.unwrap(value): java.lang.String
        )
      )(_.message)
      .optionallyWith(
        inputs.map(value => WorkflowStepInputs.unwrap(value): java.lang.String)
      )(_.inputs)
      .optionallyWith(
        outputs.map(value =>
          WorkflowStepOutputs.unwrap(value): java.lang.String
        )
      )(_.outputs)
      .optionallyWith(
        startTime.map(value => DateTime.unwrap(value): java.lang.String)
      )(_.startTime)
      .optionallyWith(
        endTime.map(value => DateTime.unwrap(value): java.lang.String)
      )(_.endTime)
      .optionallyWith(
        onFailure.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.onFailure)
      .optionallyWith(
        timeoutSeconds.map(value =>
          WorkflowStepTimeoutSecondsInteger.unwrap(value): Integer
        )
      )(_.timeoutSeconds)
      .build()
  }
  def asReadOnly
      : zio.aws.imagebuilder.model.GetWorkflowStepExecutionResponse.ReadOnly =
    zio.aws.imagebuilder.model.GetWorkflowStepExecutionResponse
      .wrap(buildAwsValue())
}
object GetWorkflowStepExecutionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.GetWorkflowStepExecutionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.imagebuilder.model.GetWorkflowStepExecutionResponse =
      zio.aws.imagebuilder.model.GetWorkflowStepExecutionResponse(
        requestId.map(value => value),
        stepExecutionId.map(value => value),
        workflowBuildVersionArn.map(value => value),
        workflowExecutionId.map(value => value),
        imageBuildVersionArn.map(value => value),
        name.map(value => value),
        description.map(value => value),
        action.map(value => value),
        status.map(value => value),
        rollbackStatus.map(value => value),
        message.map(value => value),
        inputs.map(value => value),
        outputs.map(value => value),
        startTime.map(value => value),
        endTime.map(value => value),
        onFailure.map(value => value),
        timeoutSeconds.map(value => value)
      )
    def requestId: Optional[NonEmptyString]
    def stepExecutionId: Optional[WorkflowStepExecutionId]
    def workflowBuildVersionArn: Optional[WorkflowBuildVersionArn]
    def workflowExecutionId: Optional[WorkflowExecutionId]
    def imageBuildVersionArn: Optional[ImageBuildVersionArn]
    def name: Optional[WorkflowStepName]
    def description: Optional[WorkflowStepDescription]
    def action: Optional[WorkflowStepAction]
    def status: Optional[zio.aws.imagebuilder.model.WorkflowStepExecutionStatus]
    def rollbackStatus: Optional[
      zio.aws.imagebuilder.model.WorkflowStepExecutionRollbackStatus
    ]
    def message: Optional[WorkflowStepMessage]
    def inputs: Optional[WorkflowStepInputs]
    def outputs: Optional[WorkflowStepOutputs]
    def startTime: Optional[DateTime]
    def endTime: Optional[DateTime]
    def onFailure: Optional[NonEmptyString]
    def timeoutSeconds: Optional[WorkflowStepTimeoutSecondsInteger]
    def getRequestId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("requestId", requestId)
    def getStepExecutionId: ZIO[Any, AwsError, WorkflowStepExecutionId] =
      AwsError.unwrapOptionField("stepExecutionId", stepExecutionId)
    def getWorkflowBuildVersionArn
        : ZIO[Any, AwsError, WorkflowBuildVersionArn] = AwsError
      .unwrapOptionField("workflowBuildVersionArn", workflowBuildVersionArn)
    def getWorkflowExecutionId: ZIO[Any, AwsError, WorkflowExecutionId] =
      AwsError.unwrapOptionField("workflowExecutionId", workflowExecutionId)
    def getImageBuildVersionArn: ZIO[Any, AwsError, ImageBuildVersionArn] =
      AwsError.unwrapOptionField("imageBuildVersionArn", imageBuildVersionArn)
    def getName: ZIO[Any, AwsError, WorkflowStepName] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, WorkflowStepDescription] =
      AwsError.unwrapOptionField("description", description)
    def getAction: ZIO[Any, AwsError, WorkflowStepAction] =
      AwsError.unwrapOptionField("action", action)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.imagebuilder.model.WorkflowStepExecutionStatus
    ] = AwsError.unwrapOptionField("status", status)
    def getRollbackStatus: ZIO[
      Any,
      AwsError,
      zio.aws.imagebuilder.model.WorkflowStepExecutionRollbackStatus
    ] = AwsError.unwrapOptionField("rollbackStatus", rollbackStatus)
    def getMessage: ZIO[Any, AwsError, WorkflowStepMessage] =
      AwsError.unwrapOptionField("message", message)
    def getInputs: ZIO[Any, AwsError, WorkflowStepInputs] =
      AwsError.unwrapOptionField("inputs", inputs)
    def getOutputs: ZIO[Any, AwsError, WorkflowStepOutputs] =
      AwsError.unwrapOptionField("outputs", outputs)
    def getStartTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getEndTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getOnFailure: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("onFailure", onFailure)
    def getTimeoutSeconds
        : ZIO[Any, AwsError, WorkflowStepTimeoutSecondsInteger] =
      AwsError.unwrapOptionField("timeoutSeconds", timeoutSeconds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.GetWorkflowStepExecutionResponse
  ) extends zio.aws.imagebuilder.model.GetWorkflowStepExecutionResponse.ReadOnly {
    override val requestId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.requestId())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val stepExecutionId: Optional[WorkflowStepExecutionId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stepExecutionId())
        .map(value =>
          zio.aws.imagebuilder.model.primitives.WorkflowStepExecutionId(value)
        )
    override val workflowBuildVersionArn: Optional[WorkflowBuildVersionArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.workflowBuildVersionArn())
        .map(value =>
          zio.aws.imagebuilder.model.primitives.WorkflowBuildVersionArn(value)
        )
    override val workflowExecutionId: Optional[WorkflowExecutionId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.workflowExecutionId())
        .map(value =>
          zio.aws.imagebuilder.model.primitives.WorkflowExecutionId(value)
        )
    override val imageBuildVersionArn: Optional[ImageBuildVersionArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.imageBuildVersionArn())
        .map(value =>
          zio.aws.imagebuilder.model.primitives.ImageBuildVersionArn(value)
        )
    override val name: Optional[WorkflowStepName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value =>
        zio.aws.imagebuilder.model.primitives.WorkflowStepName(value)
      )
    override val description: Optional[WorkflowStepDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.imagebuilder.model.primitives.WorkflowStepDescription(value)
        )
    override val action: Optional[WorkflowStepAction] = zio.aws.core.internal
      .optionalFromNullable(impl.action())
      .map(value =>
        zio.aws.imagebuilder.model.primitives.WorkflowStepAction(value)
      )
    override val status
        : Optional[zio.aws.imagebuilder.model.WorkflowStepExecutionStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.imagebuilder.model.WorkflowStepExecutionStatus.wrap(value)
        )
    override val rollbackStatus: Optional[
      zio.aws.imagebuilder.model.WorkflowStepExecutionRollbackStatus
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.rollbackStatus())
      .map(value =>
        zio.aws.imagebuilder.model.WorkflowStepExecutionRollbackStatus
          .wrap(value)
      )
    override val message: Optional[WorkflowStepMessage] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value =>
        zio.aws.imagebuilder.model.primitives.WorkflowStepMessage(value)
      )
    override val inputs: Optional[WorkflowStepInputs] = zio.aws.core.internal
      .optionalFromNullable(impl.inputs())
      .map(value =>
        zio.aws.imagebuilder.model.primitives.WorkflowStepInputs(value)
      )
    override val outputs: Optional[WorkflowStepOutputs] = zio.aws.core.internal
      .optionalFromNullable(impl.outputs())
      .map(value =>
        zio.aws.imagebuilder.model.primitives.WorkflowStepOutputs(value)
      )
    override val startTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.startTime())
      .map(value => zio.aws.imagebuilder.model.primitives.DateTime(value))
    override val endTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.endTime())
      .map(value => zio.aws.imagebuilder.model.primitives.DateTime(value))
    override val onFailure: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.onFailure())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val timeoutSeconds: Optional[WorkflowStepTimeoutSecondsInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.timeoutSeconds())
        .map(value =>
          zio.aws.imagebuilder.model.primitives
            .WorkflowStepTimeoutSecondsInteger(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.GetWorkflowStepExecutionResponse
  ): zio.aws.imagebuilder.model.GetWorkflowStepExecutionResponse.ReadOnly =
    new Wrapper(impl)
}
