package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.{NonEmptyString, ImageBuilderArn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetMarketplaceResourceResponse(
    resourceArn: Optional[ImageBuilderArn] = Optional.Absent,
    url: Optional[NonEmptyString] = Optional.Absent,
    data: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.GetMarketplaceResourceResponse = {
    import GetMarketplaceResourceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.GetMarketplaceResourceResponse
      .builder()
      .optionallyWith(
        resourceArn.map(value =>
          ImageBuilderArn.unwrap(value): java.lang.String
        )
      )(_.resourceArn)
      .optionallyWith(
        url.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.url)
      .optionallyWith(
        data.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.data)
      .build()
  }
  def asReadOnly
      : zio.aws.imagebuilder.model.GetMarketplaceResourceResponse.ReadOnly =
    zio.aws.imagebuilder.model.GetMarketplaceResourceResponse
      .wrap(buildAwsValue())
}
object GetMarketplaceResourceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.GetMarketplaceResourceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.GetMarketplaceResourceResponse =
      zio.aws.imagebuilder.model.GetMarketplaceResourceResponse(
        resourceArn.map(value => value),
        url.map(value => value),
        data.map(value => value)
      )
    def resourceArn: Optional[ImageBuilderArn]
    def url: Optional[NonEmptyString]
    def data: Optional[NonEmptyString]
    def getResourceArn: ZIO[Any, AwsError, ImageBuilderArn] =
      AwsError.unwrapOptionField("resourceArn", resourceArn)
    def getUrl: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("url", url)
    def getData: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("data", data)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.GetMarketplaceResourceResponse
  ) extends zio.aws.imagebuilder.model.GetMarketplaceResourceResponse.ReadOnly {
    override val resourceArn: Optional[ImageBuilderArn] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceArn())
      .map(value =>
        zio.aws.imagebuilder.model.primitives.ImageBuilderArn(value)
      )
    override val url: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.url())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val data: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.data())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.GetMarketplaceResourceResponse
  ): zio.aws.imagebuilder.model.GetMarketplaceResourceResponse.ReadOnly =
    new Wrapper(impl)
}
