package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.{
  MarketplaceResourceLocation,
  ImageBuilderArn
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetMarketplaceResourceRequest(
    resourceType: zio.aws.imagebuilder.model.MarketplaceResourceType,
    resourceArn: ImageBuilderArn,
    resourceLocation: Optional[MarketplaceResourceLocation] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.GetMarketplaceResourceRequest = {
    import GetMarketplaceResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.GetMarketplaceResourceRequest
      .builder()
      .resourceType(resourceType.unwrap)
      .resourceArn(ImageBuilderArn.unwrap(resourceArn): java.lang.String)
      .optionallyWith(
        resourceLocation.map(value =>
          MarketplaceResourceLocation.unwrap(value): java.lang.String
        )
      )(_.resourceLocation)
      .build()
  }
  def asReadOnly
      : zio.aws.imagebuilder.model.GetMarketplaceResourceRequest.ReadOnly =
    zio.aws.imagebuilder.model.GetMarketplaceResourceRequest
      .wrap(buildAwsValue())
}
object GetMarketplaceResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.GetMarketplaceResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.GetMarketplaceResourceRequest =
      zio.aws.imagebuilder.model.GetMarketplaceResourceRequest(
        resourceType,
        resourceArn,
        resourceLocation.map(value => value)
      )
    def resourceType: zio.aws.imagebuilder.model.MarketplaceResourceType
    def resourceArn: ImageBuilderArn
    def resourceLocation: Optional[MarketplaceResourceLocation]
    def getResourceType: ZIO[
      Any,
      Nothing,
      zio.aws.imagebuilder.model.MarketplaceResourceType
    ] = ZIO.succeed(resourceType)
    def getResourceArn: ZIO[Any, Nothing, ImageBuilderArn] =
      ZIO.succeed(resourceArn)
    def getResourceLocation: ZIO[Any, AwsError, MarketplaceResourceLocation] =
      AwsError.unwrapOptionField("resourceLocation", resourceLocation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.GetMarketplaceResourceRequest
  ) extends zio.aws.imagebuilder.model.GetMarketplaceResourceRequest.ReadOnly {
    override val resourceType
        : zio.aws.imagebuilder.model.MarketplaceResourceType =
      zio.aws.imagebuilder.model.MarketplaceResourceType
        .wrap(impl.resourceType())
    override val resourceArn: ImageBuilderArn =
      zio.aws.imagebuilder.model.primitives.ImageBuilderArn(impl.resourceArn())
    override val resourceLocation: Optional[MarketplaceResourceLocation] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceLocation())
        .map(value =>
          zio.aws.imagebuilder.model.primitives
            .MarketplaceResourceLocation(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.GetMarketplaceResourceRequest
  ): zio.aws.imagebuilder.model.GetMarketplaceResourceRequest.ReadOnly =
    new Wrapper(impl)
}
