package zio.aws.imagebuilder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetLifecyclePolicyResponse(
    lifecyclePolicy: Optional[zio.aws.imagebuilder.model.LifecyclePolicy] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.GetLifecyclePolicyResponse = {
    import GetLifecyclePolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.GetLifecyclePolicyResponse
      .builder()
      .optionallyWith(lifecyclePolicy.map(value => value.buildAwsValue()))(
        _.lifecyclePolicy
      )
      .build()
  }
  def asReadOnly
      : zio.aws.imagebuilder.model.GetLifecyclePolicyResponse.ReadOnly =
    zio.aws.imagebuilder.model.GetLifecyclePolicyResponse.wrap(buildAwsValue())
}
object GetLifecyclePolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.GetLifecyclePolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.GetLifecyclePolicyResponse =
      zio.aws.imagebuilder.model.GetLifecyclePolicyResponse(
        lifecyclePolicy.map(value => value.asEditable)
      )
    def lifecyclePolicy
        : Optional[zio.aws.imagebuilder.model.LifecyclePolicy.ReadOnly]
    def getLifecyclePolicy: ZIO[
      Any,
      AwsError,
      zio.aws.imagebuilder.model.LifecyclePolicy.ReadOnly
    ] = AwsError.unwrapOptionField("lifecyclePolicy", lifecyclePolicy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.GetLifecyclePolicyResponse
  ) extends zio.aws.imagebuilder.model.GetLifecyclePolicyResponse.ReadOnly {
    override val lifecyclePolicy
        : Optional[zio.aws.imagebuilder.model.LifecyclePolicy.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lifecyclePolicy())
        .map(value => zio.aws.imagebuilder.model.LifecyclePolicy.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.GetLifecyclePolicyResponse
  ): zio.aws.imagebuilder.model.GetLifecyclePolicyResponse.ReadOnly =
    new Wrapper(impl)
}
