package zio.aws.imagebuilder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetLifecycleExecutionResponse(
    lifecycleExecution: Optional[
      zio.aws.imagebuilder.model.LifecycleExecution
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.GetLifecycleExecutionResponse = {
    import GetLifecycleExecutionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.GetLifecycleExecutionResponse
      .builder()
      .optionallyWith(lifecycleExecution.map(value => value.buildAwsValue()))(
        _.lifecycleExecution
      )
      .build()
  }
  def asReadOnly
      : zio.aws.imagebuilder.model.GetLifecycleExecutionResponse.ReadOnly =
    zio.aws.imagebuilder.model.GetLifecycleExecutionResponse
      .wrap(buildAwsValue())
}
object GetLifecycleExecutionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.GetLifecycleExecutionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.GetLifecycleExecutionResponse =
      zio.aws.imagebuilder.model.GetLifecycleExecutionResponse(
        lifecycleExecution.map(value => value.asEditable)
      )
    def lifecycleExecution
        : Optional[zio.aws.imagebuilder.model.LifecycleExecution.ReadOnly]
    def getLifecycleExecution: ZIO[
      Any,
      AwsError,
      zio.aws.imagebuilder.model.LifecycleExecution.ReadOnly
    ] = AwsError.unwrapOptionField("lifecycleExecution", lifecycleExecution)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.GetLifecycleExecutionResponse
  ) extends zio.aws.imagebuilder.model.GetLifecycleExecutionResponse.ReadOnly {
    override val lifecycleExecution
        : Optional[zio.aws.imagebuilder.model.LifecycleExecution.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lifecycleExecution())
        .map(value => zio.aws.imagebuilder.model.LifecycleExecution.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.GetLifecycleExecutionResponse
  ): zio.aws.imagebuilder.model.GetLifecycleExecutionResponse.ReadOnly =
    new Wrapper(impl)
}
