package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.{
  ResourcePolicyDocument,
  NonEmptyString
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetImagePolicyResponse(
    requestId: Optional[NonEmptyString] = Optional.Absent,
    policy: Optional[ResourcePolicyDocument] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.GetImagePolicyResponse = {
    import GetImagePolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.GetImagePolicyResponse
      .builder()
      .optionallyWith(
        requestId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.requestId)
      .optionallyWith(
        policy.map(value =>
          ResourcePolicyDocument.unwrap(value): java.lang.String
        )
      )(_.policy)
      .build()
  }
  def asReadOnly: zio.aws.imagebuilder.model.GetImagePolicyResponse.ReadOnly =
    zio.aws.imagebuilder.model.GetImagePolicyResponse.wrap(buildAwsValue())
}
object GetImagePolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.GetImagePolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.GetImagePolicyResponse =
      zio.aws.imagebuilder.model.GetImagePolicyResponse(
        requestId.map(value => value),
        policy.map(value => value)
      )
    def requestId: Optional[NonEmptyString]
    def policy: Optional[ResourcePolicyDocument]
    def getRequestId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("requestId", requestId)
    def getPolicy: ZIO[Any, AwsError, ResourcePolicyDocument] =
      AwsError.unwrapOptionField("policy", policy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.GetImagePolicyResponse
  ) extends zio.aws.imagebuilder.model.GetImagePolicyResponse.ReadOnly {
    override val requestId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.requestId())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val policy: Optional[ResourcePolicyDocument] =
      zio.aws.core.internal
        .optionalFromNullable(impl.policy())
        .map(value =>
          zio.aws.imagebuilder.model.primitives.ResourcePolicyDocument(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.GetImagePolicyResponse
  ): zio.aws.imagebuilder.model.GetImagePolicyResponse.ReadOnly = new Wrapper(
    impl
  )
}
