package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.{
  ImageBuilderArn,
  TagValue,
  DateTime,
  NonEmptyString,
  ResourceName,
  TagKey
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DistributionConfigurationSummary(
    arn: Optional[ImageBuilderArn] = Optional.Absent,
    name: Optional[ResourceName] = Optional.Absent,
    description: Optional[NonEmptyString] = Optional.Absent,
    dateCreated: Optional[DateTime] = Optional.Absent,
    dateUpdated: Optional[DateTime] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    regions: Optional[Iterable[NonEmptyString]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.DistributionConfigurationSummary = {
    import DistributionConfigurationSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.DistributionConfigurationSummary
      .builder()
      .optionallyWith(
        arn.map(value => ImageBuilderArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        name.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        dateCreated.map(value => DateTime.unwrap(value): java.lang.String)
      )(_.dateCreated)
      .optionallyWith(
        dateUpdated.map(value => DateTime.unwrap(value): java.lang.String)
      )(_.dateUpdated)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        regions.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.regions)
      .build()
  }
  def asReadOnly
      : zio.aws.imagebuilder.model.DistributionConfigurationSummary.ReadOnly =
    zio.aws.imagebuilder.model.DistributionConfigurationSummary
      .wrap(buildAwsValue())
}
object DistributionConfigurationSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.DistributionConfigurationSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.imagebuilder.model.DistributionConfigurationSummary =
      zio.aws.imagebuilder.model.DistributionConfigurationSummary(
        arn.map(value => value),
        name.map(value => value),
        description.map(value => value),
        dateCreated.map(value => value),
        dateUpdated.map(value => value),
        tags.map(value => value),
        regions.map(value => value)
      )
    def arn: Optional[ImageBuilderArn]
    def name: Optional[ResourceName]
    def description: Optional[NonEmptyString]
    def dateCreated: Optional[DateTime]
    def dateUpdated: Optional[DateTime]
    def tags: Optional[Map[TagKey, TagValue]]
    def regions: Optional[List[NonEmptyString]]
    def getArn: ZIO[Any, AwsError, ImageBuilderArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("description", description)
    def getDateCreated: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("dateCreated", dateCreated)
    def getDateUpdated: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("dateUpdated", dateUpdated)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getRegions: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("regions", regions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.DistributionConfigurationSummary
  ) extends zio.aws.imagebuilder.model.DistributionConfigurationSummary.ReadOnly {
    override val arn: Optional[ImageBuilderArn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value =>
        zio.aws.imagebuilder.model.primitives.ImageBuilderArn(value)
      )
    override val name: Optional[ResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.imagebuilder.model.primitives.ResourceName(value))
    override val description: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val dateCreated: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.dateCreated())
      .map(value => zio.aws.imagebuilder.model.primitives.DateTime(value))
    override val dateUpdated: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.dateUpdated())
      .map(value => zio.aws.imagebuilder.model.primitives.DateTime(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.imagebuilder.model.primitives.TagKey(
              key
            ) -> zio.aws.imagebuilder.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val regions: Optional[List[NonEmptyString]] = zio.aws.core.internal
      .optionalFromNullable(impl.regions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.imagebuilder.model.primitives.NonEmptyString(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.DistributionConfigurationSummary
  ): zio.aws.imagebuilder.model.DistributionConfigurationSummary.ReadOnly =
    new Wrapper(impl)
}
