package zio.aws.imagebuilder.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.imagebuilder.model.primitives.{
  DistributionTimeoutMinutes,
  ImageBuilderArn,
  TagValue,
  DateTime,
  NonEmptyString,
  ResourceName,
  TagKey
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DistributionConfiguration(
    arn: Optional[ImageBuilderArn] = Optional.Absent,
    name: Optional[ResourceName] = Optional.Absent,
    description: Optional[NonEmptyString] = Optional.Absent,
    distributions: Optional[Iterable[zio.aws.imagebuilder.model.Distribution]] =
      Optional.Absent,
    timeoutMinutes: DistributionTimeoutMinutes,
    dateCreated: Optional[DateTime] = Optional.Absent,
    dateUpdated: Optional[DateTime] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.DistributionConfiguration = {
    import DistributionConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.DistributionConfiguration
      .builder()
      .optionallyWith(
        arn.map(value => ImageBuilderArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        name.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        distributions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.distributions)
      .timeoutMinutes(
        DistributionTimeoutMinutes.unwrap(timeoutMinutes): Integer
      )
      .optionallyWith(
        dateCreated.map(value => DateTime.unwrap(value): java.lang.String)
      )(_.dateCreated)
      .optionallyWith(
        dateUpdated.map(value => DateTime.unwrap(value): java.lang.String)
      )(_.dateUpdated)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.imagebuilder.model.DistributionConfiguration.ReadOnly =
    zio.aws.imagebuilder.model.DistributionConfiguration.wrap(buildAwsValue())
}
object DistributionConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.DistributionConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.DistributionConfiguration =
      zio.aws.imagebuilder.model.DistributionConfiguration(
        arn.map(value => value),
        name.map(value => value),
        description.map(value => value),
        distributions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        timeoutMinutes,
        dateCreated.map(value => value),
        dateUpdated.map(value => value),
        tags.map(value => value)
      )
    def arn: Optional[ImageBuilderArn]
    def name: Optional[ResourceName]
    def description: Optional[NonEmptyString]
    def distributions
        : Optional[List[zio.aws.imagebuilder.model.Distribution.ReadOnly]]
    def timeoutMinutes: DistributionTimeoutMinutes
    def dateCreated: Optional[DateTime]
    def dateUpdated: Optional[DateTime]
    def tags: Optional[Map[TagKey, TagValue]]
    def getArn: ZIO[Any, AwsError, ImageBuilderArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("description", description)
    def getDistributions: ZIO[Any, AwsError, List[
      zio.aws.imagebuilder.model.Distribution.ReadOnly
    ]] = AwsError.unwrapOptionField("distributions", distributions)
    def getTimeoutMinutes: ZIO[Any, Nothing, DistributionTimeoutMinutes] =
      ZIO.succeed(timeoutMinutes)
    def getDateCreated: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("dateCreated", dateCreated)
    def getDateUpdated: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("dateUpdated", dateUpdated)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.DistributionConfiguration
  ) extends zio.aws.imagebuilder.model.DistributionConfiguration.ReadOnly {
    override val arn: Optional[ImageBuilderArn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value =>
        zio.aws.imagebuilder.model.primitives.ImageBuilderArn(value)
      )
    override val name: Optional[ResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.imagebuilder.model.primitives.ResourceName(value))
    override val description: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val distributions
        : Optional[List[zio.aws.imagebuilder.model.Distribution.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.distributions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.imagebuilder.model.Distribution.wrap(item)
          }.toList
        )
    override val timeoutMinutes: DistributionTimeoutMinutes =
      zio.aws.imagebuilder.model.primitives
        .DistributionTimeoutMinutes(impl.timeoutMinutes())
    override val dateCreated: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.dateCreated())
      .map(value => zio.aws.imagebuilder.model.primitives.DateTime(value))
    override val dateUpdated: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.dateUpdated())
      .map(value => zio.aws.imagebuilder.model.primitives.DateTime(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.imagebuilder.model.primitives.TagKey(
              key
            ) -> zio.aws.imagebuilder.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.DistributionConfiguration
  ): zio.aws.imagebuilder.model.DistributionConfiguration.ReadOnly =
    new Wrapper(impl)
}
