package zio.aws.imagebuilder.model
import scala.jdk.CollectionConverters.*
sealed trait DiskImageFormat {
  def unwrap: software.amazon.awssdk.services.imagebuilder.model.DiskImageFormat
}
object DiskImageFormat {
  def wrap(
      value: software.amazon.awssdk.services.imagebuilder.model.DiskImageFormat
  ): zio.aws.imagebuilder.model.DiskImageFormat = value match {
    case software.amazon.awssdk.services.imagebuilder.model.DiskImageFormat.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.imagebuilder.model.DiskImageFormat.VMDK =>
      val r = VMDK
      r
    case software.amazon.awssdk.services.imagebuilder.model.DiskImageFormat.RAW =>
      val r = RAW
      r
    case software.amazon.awssdk.services.imagebuilder.model.DiskImageFormat.VHD =>
      val r = VHD
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.imagebuilder.model.DiskImageFormat {
    override def unwrap
        : software.amazon.awssdk.services.imagebuilder.model.DiskImageFormat =
      software.amazon.awssdk.services.imagebuilder.model.DiskImageFormat.UNKNOWN_TO_SDK_VERSION
  }
  case object VMDK extends zio.aws.imagebuilder.model.DiskImageFormat {
    override def unwrap
        : software.amazon.awssdk.services.imagebuilder.model.DiskImageFormat =
      software.amazon.awssdk.services.imagebuilder.model.DiskImageFormat.VMDK
  }
  case object RAW extends zio.aws.imagebuilder.model.DiskImageFormat {
    override def unwrap
        : software.amazon.awssdk.services.imagebuilder.model.DiskImageFormat =
      software.amazon.awssdk.services.imagebuilder.model.DiskImageFormat.RAW
  }
  case object VHD extends zio.aws.imagebuilder.model.DiskImageFormat {
    override def unwrap
        : software.amazon.awssdk.services.imagebuilder.model.DiskImageFormat =
      software.amazon.awssdk.services.imagebuilder.model.DiskImageFormat.VHD
  }
}
