package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.WorkflowBuildVersionArn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DeleteWorkflowResponse(
    workflowBuildVersionArn: Optional[WorkflowBuildVersionArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.DeleteWorkflowResponse = {
    import DeleteWorkflowResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.DeleteWorkflowResponse
      .builder()
      .optionallyWith(
        workflowBuildVersionArn.map(value =>
          WorkflowBuildVersionArn.unwrap(value): java.lang.String
        )
      )(_.workflowBuildVersionArn)
      .build()
  }
  def asReadOnly: zio.aws.imagebuilder.model.DeleteWorkflowResponse.ReadOnly =
    zio.aws.imagebuilder.model.DeleteWorkflowResponse.wrap(buildAwsValue())
}
object DeleteWorkflowResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.DeleteWorkflowResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.DeleteWorkflowResponse =
      zio.aws.imagebuilder.model
        .DeleteWorkflowResponse(workflowBuildVersionArn.map(value => value))
    def workflowBuildVersionArn: Optional[WorkflowBuildVersionArn]
    def getWorkflowBuildVersionArn
        : ZIO[Any, AwsError, WorkflowBuildVersionArn] = AwsError
      .unwrapOptionField("workflowBuildVersionArn", workflowBuildVersionArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.DeleteWorkflowResponse
  ) extends zio.aws.imagebuilder.model.DeleteWorkflowResponse.ReadOnly {
    override val workflowBuildVersionArn: Optional[WorkflowBuildVersionArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.workflowBuildVersionArn())
        .map(value =>
          zio.aws.imagebuilder.model.primitives.WorkflowBuildVersionArn(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.DeleteWorkflowResponse
  ): zio.aws.imagebuilder.model.DeleteWorkflowResponse.ReadOnly = new Wrapper(
    impl
  )
}
