package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.{
  InlineWorkflowData,
  TagValue,
  Uri,
  VersionNumber,
  ClientToken,
  NonEmptyString,
  ResourceName,
  TagKey
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateWorkflowRequest(
    name: ResourceName,
    semanticVersion: VersionNumber,
    description: Optional[NonEmptyString] = Optional.Absent,
    changeDescription: Optional[NonEmptyString] = Optional.Absent,
    data: Optional[InlineWorkflowData] = Optional.Absent,
    uri: Optional[Uri] = Optional.Absent,
    kmsKeyId: Optional[NonEmptyString] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    clientToken: ClientToken,
    `type`: zio.aws.imagebuilder.model.WorkflowType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.CreateWorkflowRequest = {
    import CreateWorkflowRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.CreateWorkflowRequest
      .builder()
      .name(ResourceName.unwrap(name): java.lang.String)
      .semanticVersion(VersionNumber.unwrap(semanticVersion): java.lang.String)
      .optionallyWith(
        description.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        changeDescription.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.changeDescription)
      .optionallyWith(
        data.map(value => InlineWorkflowData.unwrap(value): java.lang.String)
      )(_.data)
      .optionallyWith(uri.map(value => Uri.unwrap(value): java.lang.String))(
        _.uri
      )
      .optionallyWith(
        kmsKeyId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .clientToken(ClientToken.unwrap(clientToken): java.lang.String)
      .`type`(`type`.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.imagebuilder.model.CreateWorkflowRequest.ReadOnly =
    zio.aws.imagebuilder.model.CreateWorkflowRequest.wrap(buildAwsValue())
}
object CreateWorkflowRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.CreateWorkflowRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.CreateWorkflowRequest =
      zio.aws.imagebuilder.model.CreateWorkflowRequest(
        name,
        semanticVersion,
        description.map(value => value),
        changeDescription.map(value => value),
        data.map(value => value),
        uri.map(value => value),
        kmsKeyId.map(value => value),
        tags.map(value => value),
        clientToken,
        `type`
      )
    def name: ResourceName
    def semanticVersion: VersionNumber
    def description: Optional[NonEmptyString]
    def changeDescription: Optional[NonEmptyString]
    def data: Optional[InlineWorkflowData]
    def uri: Optional[Uri]
    def kmsKeyId: Optional[NonEmptyString]
    def tags: Optional[Map[TagKey, TagValue]]
    def clientToken: ClientToken
    def `type`: zio.aws.imagebuilder.model.WorkflowType
    def getName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(name)
    def getSemanticVersion: ZIO[Any, Nothing, VersionNumber] =
      ZIO.succeed(semanticVersion)
    def getDescription: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("description", description)
    def getChangeDescription: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("changeDescription", changeDescription)
    def getData: ZIO[Any, AwsError, InlineWorkflowData] =
      AwsError.unwrapOptionField("data", data)
    def getUri: ZIO[Any, AwsError, Uri] = AwsError.unwrapOptionField("uri", uri)
    def getKmsKeyId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getClientToken: ZIO[Any, Nothing, ClientToken] =
      ZIO.succeed(clientToken)
    def getType: ZIO[Any, Nothing, zio.aws.imagebuilder.model.WorkflowType] =
      ZIO.succeed(`type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.CreateWorkflowRequest
  ) extends zio.aws.imagebuilder.model.CreateWorkflowRequest.ReadOnly {
    override val name: ResourceName =
      zio.aws.imagebuilder.model.primitives.ResourceName(impl.name())
    override val semanticVersion: VersionNumber =
      zio.aws.imagebuilder.model.primitives
        .VersionNumber(impl.semanticVersion())
    override val description: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val changeDescription: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.changeDescription())
        .map(value =>
          zio.aws.imagebuilder.model.primitives.NonEmptyString(value)
        )
    override val data: Optional[InlineWorkflowData] = zio.aws.core.internal
      .optionalFromNullable(impl.data())
      .map(value =>
        zio.aws.imagebuilder.model.primitives.InlineWorkflowData(value)
      )
    override val uri: Optional[Uri] = zio.aws.core.internal
      .optionalFromNullable(impl.uri())
      .map(value => zio.aws.imagebuilder.model.primitives.Uri(value))
    override val kmsKeyId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.imagebuilder.model.primitives.TagKey(
              key
            ) -> zio.aws.imagebuilder.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val clientToken: ClientToken =
      zio.aws.imagebuilder.model.primitives.ClientToken(impl.clientToken())
    override val `type`: zio.aws.imagebuilder.model.WorkflowType =
      zio.aws.imagebuilder.model.WorkflowType.wrap(impl.`type`())
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.CreateWorkflowRequest
  ): zio.aws.imagebuilder.model.CreateWorkflowRequest.ReadOnly = new Wrapper(
    impl
  )
}
