package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.{LifecyclePolicyArn, ClientToken}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateLifecyclePolicyResponse(
    clientToken: Optional[ClientToken] = Optional.Absent,
    lifecyclePolicyArn: Optional[LifecyclePolicyArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.CreateLifecyclePolicyResponse = {
    import CreateLifecyclePolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.CreateLifecyclePolicyResponse
      .builder()
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .optionallyWith(
        lifecyclePolicyArn.map(value =>
          LifecyclePolicyArn.unwrap(value): java.lang.String
        )
      )(_.lifecyclePolicyArn)
      .build()
  }
  def asReadOnly
      : zio.aws.imagebuilder.model.CreateLifecyclePolicyResponse.ReadOnly =
    zio.aws.imagebuilder.model.CreateLifecyclePolicyResponse
      .wrap(buildAwsValue())
}
object CreateLifecyclePolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.CreateLifecyclePolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.CreateLifecyclePolicyResponse =
      zio.aws.imagebuilder.model.CreateLifecyclePolicyResponse(
        clientToken.map(value => value),
        lifecyclePolicyArn.map(value => value)
      )
    def clientToken: Optional[ClientToken]
    def lifecyclePolicyArn: Optional[LifecyclePolicyArn]
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getLifecyclePolicyArn: ZIO[Any, AwsError, LifecyclePolicyArn] =
      AwsError.unwrapOptionField("lifecyclePolicyArn", lifecyclePolicyArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.CreateLifecyclePolicyResponse
  ) extends zio.aws.imagebuilder.model.CreateLifecyclePolicyResponse.ReadOnly {
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.imagebuilder.model.primitives.ClientToken(value))
    override val lifecyclePolicyArn: Optional[LifecyclePolicyArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lifecyclePolicyArn())
        .map(value =>
          zio.aws.imagebuilder.model.primitives.LifecyclePolicyArn(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.CreateLifecyclePolicyResponse
  ): zio.aws.imagebuilder.model.CreateLifecyclePolicyResponse.ReadOnly =
    new Wrapper(impl)
}
