package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.{
  DistributionConfigurationArn,
  RoleNameOrArn,
  ImageRecipeArn,
  InfrastructureConfigurationArn,
  TagValue,
  ClientToken,
  ContainerRecipeArn,
  NullableBoolean,
  NonEmptyString,
  ResourceName,
  TagKey
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateImagePipelineRequest(
    name: ResourceName,
    description: Optional[NonEmptyString] = Optional.Absent,
    imageRecipeArn: Optional[ImageRecipeArn] = Optional.Absent,
    containerRecipeArn: Optional[ContainerRecipeArn] = Optional.Absent,
    infrastructureConfigurationArn: InfrastructureConfigurationArn,
    distributionConfigurationArn: Optional[DistributionConfigurationArn] =
      Optional.Absent,
    imageTestsConfiguration: Optional[
      zio.aws.imagebuilder.model.ImageTestsConfiguration
    ] = Optional.Absent,
    enhancedImageMetadataEnabled: Optional[NullableBoolean] = Optional.Absent,
    schedule: Optional[zio.aws.imagebuilder.model.Schedule] = Optional.Absent,
    status: Optional[zio.aws.imagebuilder.model.PipelineStatus] =
      Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    clientToken: ClientToken,
    imageScanningConfiguration: Optional[
      zio.aws.imagebuilder.model.ImageScanningConfiguration
    ] = Optional.Absent,
    workflows: Optional[
      Iterable[zio.aws.imagebuilder.model.WorkflowConfiguration]
    ] = Optional.Absent,
    executionRole: Optional[RoleNameOrArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.CreateImagePipelineRequest = {
    import CreateImagePipelineRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.CreateImagePipelineRequest
      .builder()
      .name(ResourceName.unwrap(name): java.lang.String)
      .optionallyWith(
        description.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        imageRecipeArn.map(value =>
          ImageRecipeArn.unwrap(value): java.lang.String
        )
      )(_.imageRecipeArn)
      .optionallyWith(
        containerRecipeArn.map(value =>
          ContainerRecipeArn.unwrap(value): java.lang.String
        )
      )(_.containerRecipeArn)
      .infrastructureConfigurationArn(
        InfrastructureConfigurationArn.unwrap(
          infrastructureConfigurationArn
        ): java.lang.String
      )
      .optionallyWith(
        distributionConfigurationArn.map(value =>
          DistributionConfigurationArn.unwrap(value): java.lang.String
        )
      )(_.distributionConfigurationArn)
      .optionallyWith(
        imageTestsConfiguration.map(value => value.buildAwsValue())
      )(_.imageTestsConfiguration)
      .optionallyWith(
        enhancedImageMetadataEnabled.map(value => value: java.lang.Boolean)
      )(_.enhancedImageMetadataEnabled)
      .optionallyWith(schedule.map(value => value.buildAwsValue()))(_.schedule)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .clientToken(ClientToken.unwrap(clientToken): java.lang.String)
      .optionallyWith(
        imageScanningConfiguration.map(value => value.buildAwsValue())
      )(_.imageScanningConfiguration)
      .optionallyWith(
        workflows.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.workflows)
      .optionallyWith(
        executionRole.map(value =>
          RoleNameOrArn.unwrap(value): java.lang.String
        )
      )(_.executionRole)
      .build()
  }
  def asReadOnly
      : zio.aws.imagebuilder.model.CreateImagePipelineRequest.ReadOnly =
    zio.aws.imagebuilder.model.CreateImagePipelineRequest.wrap(buildAwsValue())
}
object CreateImagePipelineRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.CreateImagePipelineRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.CreateImagePipelineRequest =
      zio.aws.imagebuilder.model.CreateImagePipelineRequest(
        name,
        description.map(value => value),
        imageRecipeArn.map(value => value),
        containerRecipeArn.map(value => value),
        infrastructureConfigurationArn,
        distributionConfigurationArn.map(value => value),
        imageTestsConfiguration.map(value => value.asEditable),
        enhancedImageMetadataEnabled.map(value => value),
        schedule.map(value => value.asEditable),
        status.map(value => value),
        tags.map(value => value),
        clientToken,
        imageScanningConfiguration.map(value => value.asEditable),
        workflows.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        executionRole.map(value => value)
      )
    def name: ResourceName
    def description: Optional[NonEmptyString]
    def imageRecipeArn: Optional[ImageRecipeArn]
    def containerRecipeArn: Optional[ContainerRecipeArn]
    def infrastructureConfigurationArn: InfrastructureConfigurationArn
    def distributionConfigurationArn: Optional[DistributionConfigurationArn]
    def imageTestsConfiguration
        : Optional[zio.aws.imagebuilder.model.ImageTestsConfiguration.ReadOnly]
    def enhancedImageMetadataEnabled: Optional[NullableBoolean]
    def schedule: Optional[zio.aws.imagebuilder.model.Schedule.ReadOnly]
    def status: Optional[zio.aws.imagebuilder.model.PipelineStatus]
    def tags: Optional[Map[TagKey, TagValue]]
    def clientToken: ClientToken
    def imageScanningConfiguration: Optional[
      zio.aws.imagebuilder.model.ImageScanningConfiguration.ReadOnly
    ]
    def workflows: Optional[
      List[zio.aws.imagebuilder.model.WorkflowConfiguration.ReadOnly]
    ]
    def executionRole: Optional[RoleNameOrArn]
    def getName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(name)
    def getDescription: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("description", description)
    def getImageRecipeArn: ZIO[Any, AwsError, ImageRecipeArn] =
      AwsError.unwrapOptionField("imageRecipeArn", imageRecipeArn)
    def getContainerRecipeArn: ZIO[Any, AwsError, ContainerRecipeArn] =
      AwsError.unwrapOptionField("containerRecipeArn", containerRecipeArn)
    def getInfrastructureConfigurationArn
        : ZIO[Any, Nothing, InfrastructureConfigurationArn] =
      ZIO.succeed(infrastructureConfigurationArn)
    def getDistributionConfigurationArn
        : ZIO[Any, AwsError, DistributionConfigurationArn] =
      AwsError.unwrapOptionField(
        "distributionConfigurationArn",
        distributionConfigurationArn
      )
    def getImageTestsConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.imagebuilder.model.ImageTestsConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "imageTestsConfiguration",
      imageTestsConfiguration
    )
    def getEnhancedImageMetadataEnabled: ZIO[Any, AwsError, NullableBoolean] =
      AwsError.unwrapOptionField(
        "enhancedImageMetadataEnabled",
        enhancedImageMetadataEnabled
      )
    def getSchedule
        : ZIO[Any, AwsError, zio.aws.imagebuilder.model.Schedule.ReadOnly] =
      AwsError.unwrapOptionField("schedule", schedule)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.imagebuilder.model.PipelineStatus] =
      AwsError.unwrapOptionField("status", status)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getClientToken: ZIO[Any, Nothing, ClientToken] =
      ZIO.succeed(clientToken)
    def getImageScanningConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.imagebuilder.model.ImageScanningConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "imageScanningConfiguration",
      imageScanningConfiguration
    )
    def getWorkflows: ZIO[Any, AwsError, List[
      zio.aws.imagebuilder.model.WorkflowConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField("workflows", workflows)
    def getExecutionRole: ZIO[Any, AwsError, RoleNameOrArn] =
      AwsError.unwrapOptionField("executionRole", executionRole)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.CreateImagePipelineRequest
  ) extends zio.aws.imagebuilder.model.CreateImagePipelineRequest.ReadOnly {
    override val name: ResourceName =
      zio.aws.imagebuilder.model.primitives.ResourceName(impl.name())
    override val description: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val imageRecipeArn: Optional[ImageRecipeArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.imageRecipeArn())
        .map(value =>
          zio.aws.imagebuilder.model.primitives.ImageRecipeArn(value)
        )
    override val containerRecipeArn: Optional[ContainerRecipeArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.containerRecipeArn())
        .map(value =>
          zio.aws.imagebuilder.model.primitives.ContainerRecipeArn(value)
        )
    override val infrastructureConfigurationArn
        : InfrastructureConfigurationArn = zio.aws.imagebuilder.model.primitives
      .InfrastructureConfigurationArn(impl.infrastructureConfigurationArn())
    override val distributionConfigurationArn
        : Optional[DistributionConfigurationArn] = zio.aws.core.internal
      .optionalFromNullable(impl.distributionConfigurationArn())
      .map(value =>
        zio.aws.imagebuilder.model.primitives
          .DistributionConfigurationArn(value)
      )
    override val imageTestsConfiguration: Optional[
      zio.aws.imagebuilder.model.ImageTestsConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.imageTestsConfiguration())
      .map(value =>
        zio.aws.imagebuilder.model.ImageTestsConfiguration.wrap(value)
      )
    override val enhancedImageMetadataEnabled: Optional[NullableBoolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enhancedImageMetadataEnabled())
        .map(value => value: NullableBoolean)
    override val schedule
        : Optional[zio.aws.imagebuilder.model.Schedule.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.schedule())
        .map(value => zio.aws.imagebuilder.model.Schedule.wrap(value))
    override val status: Optional[zio.aws.imagebuilder.model.PipelineStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.imagebuilder.model.PipelineStatus.wrap(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.imagebuilder.model.primitives.TagKey(
              key
            ) -> zio.aws.imagebuilder.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val clientToken: ClientToken =
      zio.aws.imagebuilder.model.primitives.ClientToken(impl.clientToken())
    override val imageScanningConfiguration: Optional[
      zio.aws.imagebuilder.model.ImageScanningConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.imageScanningConfiguration())
      .map(value =>
        zio.aws.imagebuilder.model.ImageScanningConfiguration.wrap(value)
      )
    override val workflows: Optional[
      List[zio.aws.imagebuilder.model.WorkflowConfiguration.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.workflows())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.imagebuilder.model.WorkflowConfiguration.wrap(item)
        }.toList
      )
    override val executionRole: Optional[RoleNameOrArn] = zio.aws.core.internal
      .optionalFromNullable(impl.executionRole())
      .map(value => zio.aws.imagebuilder.model.primitives.RoleNameOrArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.CreateImagePipelineRequest
  ): zio.aws.imagebuilder.model.CreateImagePipelineRequest.ReadOnly =
    new Wrapper(impl)
}
