package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.{
  DistributionConfigurationArn,
  ClientToken,
  NonEmptyString
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateDistributionConfigurationResponse(
    requestId: Optional[NonEmptyString] = Optional.Absent,
    clientToken: Optional[ClientToken] = Optional.Absent,
    distributionConfigurationArn: Optional[DistributionConfigurationArn] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.CreateDistributionConfigurationResponse = {
    import CreateDistributionConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.CreateDistributionConfigurationResponse
      .builder()
      .optionallyWith(
        requestId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.requestId)
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .optionallyWith(
        distributionConfigurationArn.map(value =>
          DistributionConfigurationArn.unwrap(value): java.lang.String
        )
      )(_.distributionConfigurationArn)
      .build()
  }
  def asReadOnly
      : zio.aws.imagebuilder.model.CreateDistributionConfigurationResponse.ReadOnly =
    zio.aws.imagebuilder.model.CreateDistributionConfigurationResponse
      .wrap(buildAwsValue())
}
object CreateDistributionConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.CreateDistributionConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.imagebuilder.model.CreateDistributionConfigurationResponse =
      zio.aws.imagebuilder.model.CreateDistributionConfigurationResponse(
        requestId.map(value => value),
        clientToken.map(value => value),
        distributionConfigurationArn.map(value => value)
      )
    def requestId: Optional[NonEmptyString]
    def clientToken: Optional[ClientToken]
    def distributionConfigurationArn: Optional[DistributionConfigurationArn]
    def getRequestId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("requestId", requestId)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getDistributionConfigurationArn
        : ZIO[Any, AwsError, DistributionConfigurationArn] =
      AwsError.unwrapOptionField(
        "distributionConfigurationArn",
        distributionConfigurationArn
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.CreateDistributionConfigurationResponse
  ) extends zio.aws.imagebuilder.model.CreateDistributionConfigurationResponse.ReadOnly {
    override val requestId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.requestId())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.imagebuilder.model.primitives.ClientToken(value))
    override val distributionConfigurationArn
        : Optional[DistributionConfigurationArn] = zio.aws.core.internal
      .optionalFromNullable(impl.distributionConfigurationArn())
      .map(value =>
        zio.aws.imagebuilder.model.primitives
          .DistributionConfigurationArn(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.CreateDistributionConfigurationResponse
  ): zio.aws.imagebuilder.model.CreateDistributionConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
