package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.{
  TagValue,
  ClientToken,
  NonEmptyString,
  ResourceName,
  TagKey
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateDistributionConfigurationRequest(
    name: ResourceName,
    description: Optional[NonEmptyString] = Optional.Absent,
    distributions: Iterable[zio.aws.imagebuilder.model.Distribution],
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    clientToken: ClientToken
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.CreateDistributionConfigurationRequest = {
    import CreateDistributionConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.CreateDistributionConfigurationRequest
      .builder()
      .name(ResourceName.unwrap(name): java.lang.String)
      .optionallyWith(
        description.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.description)
      .distributions(distributions.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .clientToken(ClientToken.unwrap(clientToken): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.imagebuilder.model.CreateDistributionConfigurationRequest.ReadOnly =
    zio.aws.imagebuilder.model.CreateDistributionConfigurationRequest
      .wrap(buildAwsValue())
}
object CreateDistributionConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.CreateDistributionConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.imagebuilder.model.CreateDistributionConfigurationRequest =
      zio.aws.imagebuilder.model.CreateDistributionConfigurationRequest(
        name,
        description.map(value => value),
        distributions.map { item =>
          item.asEditable
        },
        tags.map(value => value),
        clientToken
      )
    def name: ResourceName
    def description: Optional[NonEmptyString]
    def distributions: List[zio.aws.imagebuilder.model.Distribution.ReadOnly]
    def tags: Optional[Map[TagKey, TagValue]]
    def clientToken: ClientToken
    def getName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(name)
    def getDescription: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("description", description)
    def getDistributions: ZIO[Any, Nothing, List[
      zio.aws.imagebuilder.model.Distribution.ReadOnly
    ]] = ZIO.succeed(distributions)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getClientToken: ZIO[Any, Nothing, ClientToken] =
      ZIO.succeed(clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.CreateDistributionConfigurationRequest
  ) extends zio.aws.imagebuilder.model.CreateDistributionConfigurationRequest.ReadOnly {
    override val name: ResourceName =
      zio.aws.imagebuilder.model.primitives.ResourceName(impl.name())
    override val description: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val distributions
        : List[zio.aws.imagebuilder.model.Distribution.ReadOnly] = impl
      .distributions()
      .asScala
      .map { item =>
        zio.aws.imagebuilder.model.Distribution.wrap(item)
      }
      .toList
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.imagebuilder.model.primitives.TagKey(
              key
            ) -> zio.aws.imagebuilder.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val clientToken: ClientToken =
      zio.aws.imagebuilder.model.primitives.ClientToken(impl.clientToken())
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.CreateDistributionConfigurationRequest
  ): zio.aws.imagebuilder.model.CreateDistributionConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
