package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.{
  ImageBuilderArn,
  TagValue,
  DateTime,
  NonEmptyString,
  ResourceName,
  TagKey
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ContainerRecipeSummary(
    arn: Optional[ImageBuilderArn] = Optional.Absent,
    containerType: Optional[zio.aws.imagebuilder.model.ContainerType] =
      Optional.Absent,
    name: Optional[ResourceName] = Optional.Absent,
    platform: Optional[zio.aws.imagebuilder.model.Platform] = Optional.Absent,
    owner: Optional[NonEmptyString] = Optional.Absent,
    parentImage: Optional[NonEmptyString] = Optional.Absent,
    dateCreated: Optional[DateTime] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.ContainerRecipeSummary = {
    import ContainerRecipeSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.ContainerRecipeSummary
      .builder()
      .optionallyWith(
        arn.map(value => ImageBuilderArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(containerType.map(value => value.unwrap))(_.containerType)
      .optionallyWith(
        name.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(platform.map(value => value.unwrap))(_.platform)
      .optionallyWith(
        owner.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.owner)
      .optionallyWith(
        parentImage.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.parentImage)
      .optionallyWith(
        dateCreated.map(value => DateTime.unwrap(value): java.lang.String)
      )(_.dateCreated)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.imagebuilder.model.ContainerRecipeSummary.ReadOnly =
    zio.aws.imagebuilder.model.ContainerRecipeSummary.wrap(buildAwsValue())
}
object ContainerRecipeSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.ContainerRecipeSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.ContainerRecipeSummary =
      zio.aws.imagebuilder.model.ContainerRecipeSummary(
        arn.map(value => value),
        containerType.map(value => value),
        name.map(value => value),
        platform.map(value => value),
        owner.map(value => value),
        parentImage.map(value => value),
        dateCreated.map(value => value),
        tags.map(value => value)
      )
    def arn: Optional[ImageBuilderArn]
    def containerType: Optional[zio.aws.imagebuilder.model.ContainerType]
    def name: Optional[ResourceName]
    def platform: Optional[zio.aws.imagebuilder.model.Platform]
    def owner: Optional[NonEmptyString]
    def parentImage: Optional[NonEmptyString]
    def dateCreated: Optional[DateTime]
    def tags: Optional[Map[TagKey, TagValue]]
    def getArn: ZIO[Any, AwsError, ImageBuilderArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getContainerType
        : ZIO[Any, AwsError, zio.aws.imagebuilder.model.ContainerType] =
      AwsError.unwrapOptionField("containerType", containerType)
    def getName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("name", name)
    def getPlatform: ZIO[Any, AwsError, zio.aws.imagebuilder.model.Platform] =
      AwsError.unwrapOptionField("platform", platform)
    def getOwner: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("owner", owner)
    def getParentImage: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("parentImage", parentImage)
    def getDateCreated: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("dateCreated", dateCreated)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.ContainerRecipeSummary
  ) extends zio.aws.imagebuilder.model.ContainerRecipeSummary.ReadOnly {
    override val arn: Optional[ImageBuilderArn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value =>
        zio.aws.imagebuilder.model.primitives.ImageBuilderArn(value)
      )
    override val containerType
        : Optional[zio.aws.imagebuilder.model.ContainerType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.containerType())
        .map(value => zio.aws.imagebuilder.model.ContainerType.wrap(value))
    override val name: Optional[ResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.imagebuilder.model.primitives.ResourceName(value))
    override val platform: Optional[zio.aws.imagebuilder.model.Platform] =
      zio.aws.core.internal
        .optionalFromNullable(impl.platform())
        .map(value => zio.aws.imagebuilder.model.Platform.wrap(value))
    override val owner: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.owner())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val parentImage: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.parentImage())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val dateCreated: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.dateCreated())
      .map(value => zio.aws.imagebuilder.model.primitives.DateTime(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.imagebuilder.model.primitives.TagKey(
              key
            ) -> zio.aws.imagebuilder.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.ContainerRecipeSummary
  ): zio.aws.imagebuilder.model.ContainerRecipeSummary.ReadOnly = new Wrapper(
    impl
  )
}
