package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.NonEmptyString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class Container(
    region: Optional[NonEmptyString] = Optional.Absent,
    imageUris: Optional[Iterable[NonEmptyString]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.Container = {
    import Container.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.Container
      .builder()
      .optionallyWith(
        region.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.region)
      .optionallyWith(
        imageUris.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.imageUris)
      .build()
  }
  def asReadOnly: zio.aws.imagebuilder.model.Container.ReadOnly =
    zio.aws.imagebuilder.model.Container.wrap(buildAwsValue())
}
object Container {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.Container
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.Container =
      zio.aws.imagebuilder.model
        .Container(region.map(value => value), imageUris.map(value => value))
    def region: Optional[NonEmptyString]
    def imageUris: Optional[List[NonEmptyString]]
    def getRegion: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("region", region)
    def getImageUris: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("imageUris", imageUris)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.Container
  ) extends zio.aws.imagebuilder.model.Container.ReadOnly {
    override val region: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.region())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val imageUris: Optional[List[NonEmptyString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.imageUris())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.imagebuilder.model.primitives.NonEmptyString(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.Container
  ): zio.aws.imagebuilder.model.Container.ReadOnly = new Wrapper(impl)
}
