package zio.aws.imagebuilder.model
import scala.jdk.CollectionConverters.*
sealed trait ComponentStatus {
  def unwrap: software.amazon.awssdk.services.imagebuilder.model.ComponentStatus
}
object ComponentStatus {
  def wrap(
      value: software.amazon.awssdk.services.imagebuilder.model.ComponentStatus
  ): zio.aws.imagebuilder.model.ComponentStatus = value match {
    case software.amazon.awssdk.services.imagebuilder.model.ComponentStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.imagebuilder.model.ComponentStatus.DEPRECATED =>
      val r = DEPRECATED
      r
    case software.amazon.awssdk.services.imagebuilder.model.ComponentStatus.DISABLED =>
      val r = DISABLED
      r
    case software.amazon.awssdk.services.imagebuilder.model.ComponentStatus.ACTIVE =>
      val r = ACTIVE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.imagebuilder.model.ComponentStatus {
    override def unwrap
        : software.amazon.awssdk.services.imagebuilder.model.ComponentStatus =
      software.amazon.awssdk.services.imagebuilder.model.ComponentStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object DEPRECATED extends zio.aws.imagebuilder.model.ComponentStatus {
    override def unwrap
        : software.amazon.awssdk.services.imagebuilder.model.ComponentStatus =
      software.amazon.awssdk.services.imagebuilder.model.ComponentStatus.DEPRECATED
  }
  case object DISABLED extends zio.aws.imagebuilder.model.ComponentStatus {
    override def unwrap
        : software.amazon.awssdk.services.imagebuilder.model.ComponentStatus =
      software.amazon.awssdk.services.imagebuilder.model.ComponentStatus.DISABLED
  }
  case object ACTIVE extends zio.aws.imagebuilder.model.ComponentStatus {
    override def unwrap
        : software.amazon.awssdk.services.imagebuilder.model.ComponentStatus =
      software.amazon.awssdk.services.imagebuilder.model.ComponentStatus.ACTIVE
  }
}
