package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.{
  ComponentParameterValue,
  ComponentParameterName
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ComponentParameter(
    name: ComponentParameterName,
    value: Iterable[ComponentParameterValue]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.ComponentParameter = {
    import ComponentParameter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.ComponentParameter
      .builder()
      .name(ComponentParameterName.unwrap(name): java.lang.String)
      .value(value.map { item =>
        ComponentParameterValue.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.imagebuilder.model.ComponentParameter.ReadOnly =
    zio.aws.imagebuilder.model.ComponentParameter.wrap(buildAwsValue())
}
object ComponentParameter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.ComponentParameter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.ComponentParameter =
      zio.aws.imagebuilder.model.ComponentParameter(name, value)
    def name: ComponentParameterName
    def value: List[ComponentParameterValue]
    def getName: ZIO[Any, Nothing, ComponentParameterName] = ZIO.succeed(name)
    def getValue: ZIO[Any, Nothing, List[ComponentParameterValue]] =
      ZIO.succeed(value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.ComponentParameter
  ) extends zio.aws.imagebuilder.model.ComponentParameter.ReadOnly {
    override val name: ComponentParameterName =
      zio.aws.imagebuilder.model.primitives.ComponentParameterName(impl.name())
    override val value: List[ComponentParameterValue] = impl
      .value()
      .asScala
      .map { item =>
        zio.aws.imagebuilder.model.primitives.ComponentParameterValue(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.ComponentParameter
  ): zio.aws.imagebuilder.model.ComponentParameter.ReadOnly = new Wrapper(impl)
}
