package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.LifecycleExecutionId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CancelLifecycleExecutionResponse(
    lifecycleExecutionId: Optional[LifecycleExecutionId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.CancelLifecycleExecutionResponse = {
    import CancelLifecycleExecutionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.CancelLifecycleExecutionResponse
      .builder()
      .optionallyWith(
        lifecycleExecutionId.map(value =>
          LifecycleExecutionId.unwrap(value): java.lang.String
        )
      )(_.lifecycleExecutionId)
      .build()
  }
  def asReadOnly
      : zio.aws.imagebuilder.model.CancelLifecycleExecutionResponse.ReadOnly =
    zio.aws.imagebuilder.model.CancelLifecycleExecutionResponse
      .wrap(buildAwsValue())
}
object CancelLifecycleExecutionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.CancelLifecycleExecutionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.imagebuilder.model.CancelLifecycleExecutionResponse =
      zio.aws.imagebuilder.model.CancelLifecycleExecutionResponse(
        lifecycleExecutionId.map(value => value)
      )
    def lifecycleExecutionId: Optional[LifecycleExecutionId]
    def getLifecycleExecutionId: ZIO[Any, AwsError, LifecycleExecutionId] =
      AwsError.unwrapOptionField("lifecycleExecutionId", lifecycleExecutionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.CancelLifecycleExecutionResponse
  ) extends zio.aws.imagebuilder.model.CancelLifecycleExecutionResponse.ReadOnly {
    override val lifecycleExecutionId: Optional[LifecycleExecutionId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lifecycleExecutionId())
        .map(value =>
          zio.aws.imagebuilder.model.primitives.LifecycleExecutionId(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.CancelLifecycleExecutionResponse
  ): zio.aws.imagebuilder.model.CancelLifecycleExecutionResponse.ReadOnly =
    new Wrapper(impl)
}
