package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.NonEmptyString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class AccountAggregation(
    accountId: Optional[NonEmptyString] = Optional.Absent,
    severityCounts: Optional[zio.aws.imagebuilder.model.SeverityCounts] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.AccountAggregation = {
    import AccountAggregation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.AccountAggregation
      .builder()
      .optionallyWith(
        accountId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.accountId)
      .optionallyWith(severityCounts.map(value => value.buildAwsValue()))(
        _.severityCounts
      )
      .build()
  }
  def asReadOnly: zio.aws.imagebuilder.model.AccountAggregation.ReadOnly =
    zio.aws.imagebuilder.model.AccountAggregation.wrap(buildAwsValue())
}
object AccountAggregation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.AccountAggregation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.AccountAggregation =
      zio.aws.imagebuilder.model.AccountAggregation(
        accountId.map(value => value),
        severityCounts.map(value => value.asEditable)
      )
    def accountId: Optional[NonEmptyString]
    def severityCounts
        : Optional[zio.aws.imagebuilder.model.SeverityCounts.ReadOnly]
    def getAccountId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getSeverityCounts: ZIO[
      Any,
      AwsError,
      zio.aws.imagebuilder.model.SeverityCounts.ReadOnly
    ] = AwsError.unwrapOptionField("severityCounts", severityCounts)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.AccountAggregation
  ) extends zio.aws.imagebuilder.model.AccountAggregation.ReadOnly {
    override val accountId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.accountId())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val severityCounts
        : Optional[zio.aws.imagebuilder.model.SeverityCounts.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.severityCounts())
        .map(value => zio.aws.imagebuilder.model.SeverityCounts.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.AccountAggregation
  ): zio.aws.imagebuilder.model.AccountAggregation.ReadOnly = new Wrapper(impl)
}
