package zio.aws.imagebuilder
import zio.aws.imagebuilder.model.UpdateImagePipelineResponse.ReadOnly
import zio.aws.imagebuilder.model.{
  StartResourceStateUpdateRequest,
  ListComponentBuildVersionsRequest,
  PutComponentPolicyRequest,
  CreateInfrastructureConfigurationRequest,
  CreateWorkflowRequest,
  GetInfrastructureConfigurationRequest,
  CreateDistributionConfigurationRequest,
  ImportVmImageRequest,
  GetDistributionConfigurationRequest,
  ListWorkflowBuildVersionsRequest,
  CreateContainerRecipeRequest,
  ListImageScanFindingsRequest,
  ListWorkflowsRequest,
  GetWorkflowStepExecutionRequest,
  DeleteComponentRequest,
  ListLifecycleExecutionResourcesRequest,
  PutImagePolicyRequest,
  DeleteImagePipelineRequest,
  GetLifecycleExecutionRequest,
  ListTagsForResourceRequest,
  GetImageRecipePolicyRequest,
  DeleteImageRequest,
  CreateComponentRequest,
  PutContainerRecipePolicyRequest,
  CreateLifecyclePolicyRequest,
  ListDistributionConfigurationsRequest,
  DeleteDistributionConfigurationRequest,
  ImportComponentRequest,
  SendWorkflowStepActionRequest,
  DeleteContainerRecipeRequest,
  DeleteLifecyclePolicyRequest,
  DeleteImageRecipeRequest,
  CancelLifecycleExecutionRequest,
  GetImageRecipeRequest,
  ListWaitingWorkflowStepsRequest,
  ListImageBuildVersionsRequest,
  GetMarketplaceResourceRequest,
  GetContainerRecipePolicyRequest,
  ListContainerRecipesRequest,
  GetContainerRecipeRequest,
  CancelImageCreationRequest,
  ListWorkflowStepExecutionsRequest,
  ListImageScanFindingAggregationsRequest,
  UpdateImagePipelineRequest,
  UntagResourceRequest,
  PutImageRecipePolicyRequest,
  CreateImageRecipeRequest,
  GetImagePolicyRequest,
  StartImagePipelineExecutionRequest,
  ListComponentsRequest,
  CreateImageRequest,
  ListImagePipelinesRequest,
  GetComponentPolicyRequest,
  ListImagePackagesRequest,
  ListWorkflowExecutionsRequest,
  GetComponentRequest,
  GetImageRequest,
  UpdateInfrastructureConfigurationRequest,
  ListImageRecipesRequest,
  ListInfrastructureConfigurationsRequest,
  GetLifecyclePolicyRequest,
  DeleteInfrastructureConfigurationRequest,
  UpdateDistributionConfigurationRequest,
  DeleteWorkflowRequest,
  GetImagePipelineRequest,
  TagResourceRequest,
  ListImagesRequest,
  ListLifecyclePoliciesRequest,
  UpdateLifecyclePolicyRequest,
  CreateImagePipelineRequest,
  GetWorkflowExecutionRequest,
  ListLifecycleExecutionsRequest,
  ImportDiskImageRequest,
  ListImagePipelineImagesRequest,
  GetWorkflowRequest
}
import zio.aws.core.config.AwsConfig
import zio.aws.core.{AwsServiceBase, AwsError}
import software.amazon.awssdk.services.imagebuilder.model.{
  UpdateImagePipelineResponse,
  CreateComponentResponse,
  ContainerRecipeSummary,
  ListImagePackagesResponse,
  GetWorkflowStepExecutionResponse,
  GetImageRecipeResponse,
  ListLifecyclePoliciesResponse,
  ImageSummary,
  GetDistributionConfigurationResponse,
  ImagePackage,
  ImageScanFinding,
  StartResourceStateUpdateResponse,
  ListWorkflowExecutionsResponse,
  PutComponentPolicyResponse,
  ListImageScanFindingsResponse,
  DeleteWorkflowResponse,
  ComponentVersion,
  GetContainerRecipeResponse,
  GetLifecycleExecutionResponse,
  ListContainerRecipesResponse,
  WorkflowExecutionMetadata,
  WorkflowVersion,
  DeleteDistributionConfigurationResponse,
  DeleteInfrastructureConfigurationResponse,
  DeleteContainerRecipeResponse,
  DeleteImagePipelineResponse,
  CancelLifecycleExecutionResponse,
  ImportComponentResponse,
  ListImageScanFindingAggregationsResponse,
  ImageRecipeSummary,
  ImageVersion,
  CreateContainerRecipeResponse,
  CreateLifecyclePolicyResponse,
  ImageScanFindingAggregation,
  DeleteComponentResponse,
  LifecycleExecutionResource,
  CreateWorkflowResponse,
  GetComponentResponse,
  ComponentSummary,
  DeleteImageRecipeResponse,
  SendWorkflowStepActionResponse,
  GetContainerRecipePolicyResponse,
  CreateImagePipelineResponse,
  DeleteLifecyclePolicyResponse,
  GetImagePipelineResponse,
  UpdateLifecyclePolicyResponse,
  ListLifecycleExecutionsResponse,
  DistributionConfigurationSummary,
  ListTagsForResourceResponse,
  CreateImageRecipeResponse,
  ListImagePipelinesResponse,
  UntagResourceResponse,
  ListWorkflowsResponse,
  UpdateDistributionConfigurationResponse,
  ImportVmImageResponse,
  ListImageBuildVersionsResponse,
  WorkflowStepExecution,
  PutContainerRecipePolicyResponse,
  GetInfrastructureConfigurationResponse,
  StartImagePipelineExecutionResponse,
  GetLifecyclePolicyResponse,
  ListWorkflowBuildVersionsResponse,
  GetImageResponse,
  ListImagePipelineImagesResponse,
  ImagePipeline,
  GetMarketplaceResourceResponse,
  ListImagesResponse,
  CreateDistributionConfigurationResponse,
  ListImageRecipesResponse,
  ListLifecycleExecutionResourcesResponse,
  ImportDiskImageResponse,
  PutImageRecipePolicyResponse,
  PutImagePolicyResponse,
  GetComponentPolicyResponse,
  DeleteImageResponse,
  WorkflowSummary,
  ListInfrastructureConfigurationsResponse,
  UpdateInfrastructureConfigurationResponse,
  ListComponentsResponse,
  GetImageRecipePolicyResponse,
  WorkflowStepMetadata,
  LifecycleExecution,
  GetWorkflowExecutionResponse,
  CreateImageResponse,
  GetWorkflowResponse,
  TagResourceResponse,
  ListWaitingWorkflowStepsResponse,
  ListWorkflowStepExecutionsResponse,
  ListComponentBuildVersionsResponse,
  InfrastructureConfigurationSummary,
  CreateInfrastructureConfigurationResponse,
  CancelImageCreationResponse,
  ListDistributionConfigurationsResponse,
  GetImagePolicyResponse,
  LifecyclePolicySummary
}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import software.amazon.awssdk.services.imagebuilder.paginators.{
  ListWorkflowBuildVersionsPublisher,
  ListImagePackagesPublisher,
  ListImagePipelineImagesPublisher,
  ListImagePipelinesPublisher,
  ListLifecycleExecutionsPublisher,
  ListWaitingWorkflowStepsPublisher,
  ListImageScanFindingsPublisher,
  ListImageRecipesPublisher,
  ListComponentBuildVersionsPublisher,
  ListLifecyclePoliciesPublisher,
  ListComponentsPublisher,
  ListLifecycleExecutionResourcesPublisher,
  ListInfrastructureConfigurationsPublisher,
  ListImageScanFindingAggregationsPublisher,
  ListContainerRecipesPublisher,
  ListWorkflowStepExecutionsPublisher,
  ListDistributionConfigurationsPublisher,
  ListImagesPublisher,
  ListImageBuildVersionsPublisher,
  ListWorkflowsPublisher,
  ListWorkflowExecutionsPublisher
}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import software.amazon.awssdk.services.imagebuilder.{
  ImagebuilderAsyncClientBuilder,
  ImagebuilderAsyncClient
}
import zio.stream.ZStream
import scala.jdk.CollectionConverters.*
trait Imagebuilder extends AspectSupport[Imagebuilder] {
  val api: ImagebuilderAsyncClient
  def listImages(
      request: ListImagesRequest
  ): ZStream[Any, AwsError, zio.aws.imagebuilder.model.ImageVersion.ReadOnly]
  def listImagesPaginated(
      request: ListImagesRequest
  ): IO[AwsError, zio.aws.imagebuilder.model.ListImagesResponse.ReadOnly]
  def listImageRecipes(request: ListImageRecipesRequest): ZStream[
    Any,
    AwsError,
    zio.aws.imagebuilder.model.ImageRecipeSummary.ReadOnly
  ]
  def listImageRecipesPaginated(
      request: ListImageRecipesRequest
  ): IO[AwsError, zio.aws.imagebuilder.model.ListImageRecipesResponse.ReadOnly]
  def putComponentPolicy(request: PutComponentPolicyRequest): IO[
    AwsError,
    zio.aws.imagebuilder.model.PutComponentPolicyResponse.ReadOnly
  ]
  def startResourceStateUpdate(request: StartResourceStateUpdateRequest): IO[
    AwsError,
    zio.aws.imagebuilder.model.StartResourceStateUpdateResponse.ReadOnly
  ]
  def listImageScanFindings(request: ListImageScanFindingsRequest): ZStream[
    Any,
    AwsError,
    zio.aws.imagebuilder.model.ImageScanFinding.ReadOnly
  ]
  def listImageScanFindingsPaginated(request: ListImageScanFindingsRequest): IO[
    AwsError,
    zio.aws.imagebuilder.model.ListImageScanFindingsResponse.ReadOnly
  ]
  def listImageScanFindingAggregations(
      request: ListImageScanFindingAggregationsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.imagebuilder.model.ImageScanFindingAggregation.ReadOnly
  ]
  def listImageScanFindingAggregationsPaginated(
      request: ListImageScanFindingAggregationsRequest
  ): IO[
    AwsError,
    zio.aws.imagebuilder.model.ListImageScanFindingAggregationsResponse.ReadOnly
  ]
  def getImageRecipe(
      request: GetImageRecipeRequest
  ): IO[AwsError, zio.aws.imagebuilder.model.GetImageRecipeResponse.ReadOnly]
  def listImagePackages(
      request: ListImagePackagesRequest
  ): ZStream[Any, AwsError, zio.aws.imagebuilder.model.ImagePackage.ReadOnly]
  def listImagePackagesPaginated(
      request: ListImagePackagesRequest
  ): IO[AwsError, zio.aws.imagebuilder.model.ListImagePackagesResponse.ReadOnly]
  def getComponentPolicy(request: GetComponentPolicyRequest): IO[
    AwsError,
    zio.aws.imagebuilder.model.GetComponentPolicyResponse.ReadOnly
  ]
  def getContainerRecipe(request: GetContainerRecipeRequest): IO[
    AwsError,
    zio.aws.imagebuilder.model.GetContainerRecipeResponse.ReadOnly
  ]
  def startImagePipelineExecution(
      request: StartImagePipelineExecutionRequest
  ): IO[
    AwsError,
    zio.aws.imagebuilder.model.StartImagePipelineExecutionResponse.ReadOnly
  ]
  def updateDistributionConfiguration(
      request: UpdateDistributionConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.imagebuilder.model.UpdateDistributionConfigurationResponse.ReadOnly
  ]
  def getWorkflowExecution(request: GetWorkflowExecutionRequest): IO[
    AwsError,
    zio.aws.imagebuilder.model.GetWorkflowExecutionResponse.ReadOnly
  ]
  def deleteImage(
      request: DeleteImageRequest
  ): IO[AwsError, zio.aws.imagebuilder.model.DeleteImageResponse.ReadOnly]
  def listWorkflowStepExecutions(
      request: ListWorkflowStepExecutionsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.imagebuilder.model.WorkflowStepMetadata.ReadOnly
  ]
  def listWorkflowStepExecutionsPaginated(
      request: ListWorkflowStepExecutionsRequest
  ): IO[
    AwsError,
    zio.aws.imagebuilder.model.ListWorkflowStepExecutionsResponse.ReadOnly
  ]
  def createImageRecipe(
      request: CreateImageRecipeRequest
  ): IO[AwsError, zio.aws.imagebuilder.model.CreateImageRecipeResponse.ReadOnly]
  def listComponentBuildVersions(
      request: ListComponentBuildVersionsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.imagebuilder.model.ComponentSummary.ReadOnly
  ]
  def listComponentBuildVersionsPaginated(
      request: ListComponentBuildVersionsRequest
  ): IO[
    AwsError,
    zio.aws.imagebuilder.model.ListComponentBuildVersionsResponse.ReadOnly
  ]
  def putImagePolicy(
      request: PutImagePolicyRequest
  ): IO[AwsError, zio.aws.imagebuilder.model.PutImagePolicyResponse.ReadOnly]
  def getDistributionConfiguration(
      request: GetDistributionConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.imagebuilder.model.GetDistributionConfigurationResponse.ReadOnly
  ]
  def deleteImageRecipe(
      request: DeleteImageRecipeRequest
  ): IO[AwsError, zio.aws.imagebuilder.model.DeleteImageRecipeResponse.ReadOnly]
  def createContainerRecipe(request: CreateContainerRecipeRequest): IO[
    AwsError,
    zio.aws.imagebuilder.model.CreateContainerRecipeResponse.ReadOnly
  ]
  def deleteDistributionConfiguration(
      request: DeleteDistributionConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.imagebuilder.model.DeleteDistributionConfigurationResponse.ReadOnly
  ]
  def importDiskImage(
      request: ImportDiskImageRequest
  ): IO[AwsError, zio.aws.imagebuilder.model.ImportDiskImageResponse.ReadOnly]
  def putContainerRecipePolicy(request: PutContainerRecipePolicyRequest): IO[
    AwsError,
    zio.aws.imagebuilder.model.PutContainerRecipePolicyResponse.ReadOnly
  ]
  def createInfrastructureConfiguration(
      request: CreateInfrastructureConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.imagebuilder.model.CreateInfrastructureConfigurationResponse.ReadOnly
  ]
  def listComponents(request: ListComponentsRequest): ZStream[
    Any,
    AwsError,
    zio.aws.imagebuilder.model.ComponentVersion.ReadOnly
  ]
  def listComponentsPaginated(
      request: ListComponentsRequest
  ): IO[AwsError, zio.aws.imagebuilder.model.ListComponentsResponse.ReadOnly]
  def sendWorkflowStepAction(request: SendWorkflowStepActionRequest): IO[
    AwsError,
    zio.aws.imagebuilder.model.SendWorkflowStepActionResponse.ReadOnly
  ]
  def createImage(
      request: CreateImageRequest
  ): IO[AwsError, zio.aws.imagebuilder.model.CreateImageResponse.ReadOnly]
  def deleteLifecyclePolicy(request: DeleteLifecyclePolicyRequest): IO[
    AwsError,
    zio.aws.imagebuilder.model.DeleteLifecyclePolicyResponse.ReadOnly
  ]
  def deleteInfrastructureConfiguration(
      request: DeleteInfrastructureConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.imagebuilder.model.DeleteInfrastructureConfigurationResponse.ReadOnly
  ]
  def untagResource(
      request: UntagResourceRequest
  ): IO[AwsError, zio.aws.imagebuilder.model.UntagResourceResponse.ReadOnly]
  def listLifecycleExecutions(request: ListLifecycleExecutionsRequest): ZStream[
    Any,
    AwsError,
    zio.aws.imagebuilder.model.LifecycleExecution.ReadOnly
  ]
  def listLifecycleExecutionsPaginated(
      request: ListLifecycleExecutionsRequest
  ): IO[
    AwsError,
    zio.aws.imagebuilder.model.ListLifecycleExecutionsResponse.ReadOnly
  ]
  def getLifecycleExecution(request: GetLifecycleExecutionRequest): IO[
    AwsError,
    zio.aws.imagebuilder.model.GetLifecycleExecutionResponse.ReadOnly
  ]
  def deleteComponent(
      request: DeleteComponentRequest
  ): IO[AwsError, zio.aws.imagebuilder.model.DeleteComponentResponse.ReadOnly]
  def listImagePipelines(
      request: ListImagePipelinesRequest
  ): ZStream[Any, AwsError, zio.aws.imagebuilder.model.ImagePipeline.ReadOnly]
  def listImagePipelinesPaginated(request: ListImagePipelinesRequest): IO[
    AwsError,
    zio.aws.imagebuilder.model.ListImagePipelinesResponse.ReadOnly
  ]
  def listDistributionConfigurations(
      request: ListDistributionConfigurationsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.imagebuilder.model.DistributionConfigurationSummary.ReadOnly
  ]
  def listDistributionConfigurationsPaginated(
      request: ListDistributionConfigurationsRequest
  ): IO[
    AwsError,
    zio.aws.imagebuilder.model.ListDistributionConfigurationsResponse.ReadOnly
  ]
  def getContainerRecipePolicy(request: GetContainerRecipePolicyRequest): IO[
    AwsError,
    zio.aws.imagebuilder.model.GetContainerRecipePolicyResponse.ReadOnly
  ]
  def listWaitingWorkflowSteps(
      request: ListWaitingWorkflowStepsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.imagebuilder.model.WorkflowStepExecution.ReadOnly
  ]
  def listWaitingWorkflowStepsPaginated(
      request: ListWaitingWorkflowStepsRequest
  ): IO[
    AwsError,
    zio.aws.imagebuilder.model.ListWaitingWorkflowStepsResponse.ReadOnly
  ]
  def getWorkflow(
      request: GetWorkflowRequest
  ): IO[AwsError, zio.aws.imagebuilder.model.GetWorkflowResponse.ReadOnly]
  def listImagePipelineImages(
      request: ListImagePipelineImagesRequest
  ): ZStream[Any, AwsError, zio.aws.imagebuilder.model.ImageSummary.ReadOnly]
  def listImagePipelineImagesPaginated(
      request: ListImagePipelineImagesRequest
  ): IO[
    AwsError,
    zio.aws.imagebuilder.model.ListImagePipelineImagesResponse.ReadOnly
  ]
  def createDistributionConfiguration(
      request: CreateDistributionConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.imagebuilder.model.CreateDistributionConfigurationResponse.ReadOnly
  ]
  def importComponent(
      request: ImportComponentRequest
  ): IO[AwsError, zio.aws.imagebuilder.model.ImportComponentResponse.ReadOnly]
  def createComponent(
      request: CreateComponentRequest
  ): IO[AwsError, zio.aws.imagebuilder.model.CreateComponentResponse.ReadOnly]
  def getImagePipeline(
      request: GetImagePipelineRequest
  ): IO[AwsError, zio.aws.imagebuilder.model.GetImagePipelineResponse.ReadOnly]
  def listTagsForResource(request: ListTagsForResourceRequest): IO[
    AwsError,
    zio.aws.imagebuilder.model.ListTagsForResourceResponse.ReadOnly
  ]
  def tagResource(
      request: TagResourceRequest
  ): IO[AwsError, zio.aws.imagebuilder.model.TagResourceResponse.ReadOnly]
  def listWorkflowExecutions(request: ListWorkflowExecutionsRequest): ZStream[
    Any,
    AwsError,
    zio.aws.imagebuilder.model.WorkflowExecutionMetadata.ReadOnly
  ]
  def listWorkflowExecutionsPaginated(
      request: ListWorkflowExecutionsRequest
  ): IO[
    AwsError,
    zio.aws.imagebuilder.model.ListWorkflowExecutionsResponse.ReadOnly
  ]
  def createImagePipeline(request: CreateImagePipelineRequest): IO[
    AwsError,
    zio.aws.imagebuilder.model.CreateImagePipelineResponse.ReadOnly
  ]
  def listInfrastructureConfigurations(
      request: ListInfrastructureConfigurationsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.imagebuilder.model.InfrastructureConfigurationSummary.ReadOnly
  ]
  def listInfrastructureConfigurationsPaginated(
      request: ListInfrastructureConfigurationsRequest
  ): IO[
    AwsError,
    zio.aws.imagebuilder.model.ListInfrastructureConfigurationsResponse.ReadOnly
  ]
  def listWorkflowBuildVersions(
      request: ListWorkflowBuildVersionsRequest
  ): ZStream[Any, AwsError, zio.aws.imagebuilder.model.WorkflowSummary.ReadOnly]
  def listWorkflowBuildVersionsPaginated(
      request: ListWorkflowBuildVersionsRequest
  ): IO[
    AwsError,
    zio.aws.imagebuilder.model.ListWorkflowBuildVersionsResponse.ReadOnly
  ]
  def listWorkflows(
      request: ListWorkflowsRequest
  ): ZStream[Any, AwsError, zio.aws.imagebuilder.model.WorkflowVersion.ReadOnly]
  def listWorkflowsPaginated(
      request: ListWorkflowsRequest
  ): IO[AwsError, zio.aws.imagebuilder.model.ListWorkflowsResponse.ReadOnly]
  def getInfrastructureConfiguration(
      request: GetInfrastructureConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.imagebuilder.model.GetInfrastructureConfigurationResponse.ReadOnly
  ]
  def deleteContainerRecipe(request: DeleteContainerRecipeRequest): IO[
    AwsError,
    zio.aws.imagebuilder.model.DeleteContainerRecipeResponse.ReadOnly
  ]
  def getImage(
      request: GetImageRequest
  ): IO[AwsError, zio.aws.imagebuilder.model.GetImageResponse.ReadOnly]
  def listLifecyclePolicies(request: ListLifecyclePoliciesRequest): ZStream[
    Any,
    AwsError,
    zio.aws.imagebuilder.model.LifecyclePolicySummary.ReadOnly
  ]
  def listLifecyclePoliciesPaginated(request: ListLifecyclePoliciesRequest): IO[
    AwsError,
    zio.aws.imagebuilder.model.ListLifecyclePoliciesResponse.ReadOnly
  ]
  def createLifecyclePolicy(request: CreateLifecyclePolicyRequest): IO[
    AwsError,
    zio.aws.imagebuilder.model.CreateLifecyclePolicyResponse.ReadOnly
  ]
  def listContainerRecipes(request: ListContainerRecipesRequest): ZStream[
    Any,
    AwsError,
    zio.aws.imagebuilder.model.ContainerRecipeSummary.ReadOnly
  ]
  def listContainerRecipesPaginated(request: ListContainerRecipesRequest): IO[
    AwsError,
    zio.aws.imagebuilder.model.ListContainerRecipesResponse.ReadOnly
  ]
  def cancelLifecycleExecution(request: CancelLifecycleExecutionRequest): IO[
    AwsError,
    zio.aws.imagebuilder.model.CancelLifecycleExecutionResponse.ReadOnly
  ]
  def deleteImagePipeline(request: DeleteImagePipelineRequest): IO[
    AwsError,
    zio.aws.imagebuilder.model.DeleteImagePipelineResponse.ReadOnly
  ]
  def putImageRecipePolicy(request: PutImageRecipePolicyRequest): IO[
    AwsError,
    zio.aws.imagebuilder.model.PutImageRecipePolicyResponse.ReadOnly
  ]
  def updateImagePipeline(
      request: UpdateImagePipelineRequest
  ): IO[AwsError, ReadOnly]
  def deleteWorkflow(
      request: DeleteWorkflowRequest
  ): IO[AwsError, zio.aws.imagebuilder.model.DeleteWorkflowResponse.ReadOnly]
  def getMarketplaceResource(request: GetMarketplaceResourceRequest): IO[
    AwsError,
    zio.aws.imagebuilder.model.GetMarketplaceResourceResponse.ReadOnly
  ]
  def getImageRecipePolicy(request: GetImageRecipePolicyRequest): IO[
    AwsError,
    zio.aws.imagebuilder.model.GetImageRecipePolicyResponse.ReadOnly
  ]
  def listImageBuildVersions(
      request: ListImageBuildVersionsRequest
  ): ZStream[Any, AwsError, zio.aws.imagebuilder.model.ImageSummary.ReadOnly]
  def listImageBuildVersionsPaginated(
      request: ListImageBuildVersionsRequest
  ): IO[
    AwsError,
    zio.aws.imagebuilder.model.ListImageBuildVersionsResponse.ReadOnly
  ]
  def updateInfrastructureConfiguration(
      request: UpdateInfrastructureConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.imagebuilder.model.UpdateInfrastructureConfigurationResponse.ReadOnly
  ]
  def getComponent(
      request: GetComponentRequest
  ): IO[AwsError, zio.aws.imagebuilder.model.GetComponentResponse.ReadOnly]
  def listLifecycleExecutionResources(
      request: ListLifecycleExecutionResourcesRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.imagebuilder.model.LifecycleExecutionResource.ReadOnly
  ]
  def listLifecycleExecutionResourcesPaginated(
      request: ListLifecycleExecutionResourcesRequest
  ): IO[
    AwsError,
    zio.aws.imagebuilder.model.ListLifecycleExecutionResourcesResponse.ReadOnly
  ]
  def getWorkflowStepExecution(request: GetWorkflowStepExecutionRequest): IO[
    AwsError,
    zio.aws.imagebuilder.model.GetWorkflowStepExecutionResponse.ReadOnly
  ]
  def getLifecyclePolicy(request: GetLifecyclePolicyRequest): IO[
    AwsError,
    zio.aws.imagebuilder.model.GetLifecyclePolicyResponse.ReadOnly
  ]
  def createWorkflow(
      request: CreateWorkflowRequest
  ): IO[AwsError, zio.aws.imagebuilder.model.CreateWorkflowResponse.ReadOnly]
  def updateLifecyclePolicy(request: UpdateLifecyclePolicyRequest): IO[
    AwsError,
    zio.aws.imagebuilder.model.UpdateLifecyclePolicyResponse.ReadOnly
  ]
  def importVmImage(
      request: ImportVmImageRequest
  ): IO[AwsError, zio.aws.imagebuilder.model.ImportVmImageResponse.ReadOnly]
  def cancelImageCreation(request: CancelImageCreationRequest): IO[
    AwsError,
    zio.aws.imagebuilder.model.CancelImageCreationResponse.ReadOnly
  ]
  def getImagePolicy(
      request: GetImagePolicyRequest
  ): IO[AwsError, zio.aws.imagebuilder.model.GetImagePolicyResponse.ReadOnly]
}
object Imagebuilder {
  val live: ZLayer[AwsConfig, java.lang.Throwable, Imagebuilder] = customized(
    identity
  )
  def customized(
      customization: ImagebuilderAsyncClientBuilder => ImagebuilderAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, Imagebuilder] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: ImagebuilderAsyncClientBuilder => ImagebuilderAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, Imagebuilder] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = ImagebuilderAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[ImagebuilderAsyncClient, ImagebuilderAsyncClientBuilder](
        builder
      );
    b1 <- awsConfig.configureHttpClient[
      ImagebuilderAsyncClient,
      ImagebuilderAsyncClientBuilder
    ](
      b0,
      zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
    ); client <- ZIO.attempt(customization(b1).build())
  )
    yield new ImagebuilderImpl(
      client,
      AwsCallAspect.identity,
      ZEnvironment.empty
    )
  private class ImagebuilderImpl[R](
      override val api: ImagebuilderAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends Imagebuilder
      with AwsServiceBase[R] {
    override val serviceName: String = "Imagebuilder"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): ImagebuilderImpl[R1] = new ImagebuilderImpl(api, newAspect, r)
    def listImages(request: ListImagesRequest): ZStream[
      Any,
      AwsError,
      zio.aws.imagebuilder.model.ImageVersion.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.imagebuilder.model.ListImagesRequest,
      ImageVersion,
      ListImagesPublisher
    ]("listImages", api.listImagesPaginator, _.imageVersionList())(
      request.buildAwsValue()
    ).map(item => zio.aws.imagebuilder.model.ImageVersion.wrap(item))
      .provideEnvironment(r)
    def listImagesPaginated(
        request: ListImagesRequest
    ): IO[AwsError, zio.aws.imagebuilder.model.ListImagesResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.imagebuilder.model.ListImagesRequest,
        ListImagesResponse
      ]("listImages", api.listImages)(request.buildAwsValue())
        .map(zio.aws.imagebuilder.model.ListImagesResponse.wrap)
        .provideEnvironment(r)
    def listImageRecipes(request: ListImageRecipesRequest): ZStream[
      Any,
      AwsError,
      zio.aws.imagebuilder.model.ImageRecipeSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.imagebuilder.model.ListImageRecipesRequest,
      ImageRecipeSummary,
      ListImageRecipesPublisher
    ](
      "listImageRecipes",
      api.listImageRecipesPaginator,
      _.imageRecipeSummaryList()
    )(request.buildAwsValue())
      .map(item => zio.aws.imagebuilder.model.ImageRecipeSummary.wrap(item))
      .provideEnvironment(r)
    def listImageRecipesPaginated(request: ListImageRecipesRequest): IO[
      AwsError,
      zio.aws.imagebuilder.model.ListImageRecipesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.imagebuilder.model.ListImageRecipesRequest,
      ListImageRecipesResponse
    ]("listImageRecipes", api.listImageRecipes)(request.buildAwsValue())
      .map(zio.aws.imagebuilder.model.ListImageRecipesResponse.wrap)
      .provideEnvironment(r)
    def putComponentPolicy(request: PutComponentPolicyRequest): IO[
      AwsError,
      zio.aws.imagebuilder.model.PutComponentPolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.imagebuilder.model.PutComponentPolicyRequest,
      PutComponentPolicyResponse
    ]("putComponentPolicy", api.putComponentPolicy)(request.buildAwsValue())
      .map(zio.aws.imagebuilder.model.PutComponentPolicyResponse.wrap)
      .provideEnvironment(r)
    def startResourceStateUpdate(request: StartResourceStateUpdateRequest): IO[
      AwsError,
      zio.aws.imagebuilder.model.StartResourceStateUpdateResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.imagebuilder.model.StartResourceStateUpdateRequest,
      StartResourceStateUpdateResponse
    ]("startResourceStateUpdate", api.startResourceStateUpdate)(
      request.buildAwsValue()
    ).map(zio.aws.imagebuilder.model.StartResourceStateUpdateResponse.wrap)
      .provideEnvironment(r)
    def listImageScanFindings(request: ListImageScanFindingsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.imagebuilder.model.ImageScanFinding.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.imagebuilder.model.ListImageScanFindingsRequest,
      ImageScanFinding,
      ListImageScanFindingsPublisher
    ](
      "listImageScanFindings",
      api.listImageScanFindingsPaginator,
      _.findings()
    )(request.buildAwsValue())
      .map(item => zio.aws.imagebuilder.model.ImageScanFinding.wrap(item))
      .provideEnvironment(r)
    def listImageScanFindingsPaginated(
        request: ListImageScanFindingsRequest
    ): IO[
      AwsError,
      zio.aws.imagebuilder.model.ListImageScanFindingsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.imagebuilder.model.ListImageScanFindingsRequest,
      ListImageScanFindingsResponse
    ]("listImageScanFindings", api.listImageScanFindings)(
      request.buildAwsValue()
    ).map(zio.aws.imagebuilder.model.ListImageScanFindingsResponse.wrap)
      .provideEnvironment(r)
    def listImageScanFindingAggregations(
        request: ListImageScanFindingAggregationsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.imagebuilder.model.ImageScanFindingAggregation.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.imagebuilder.model.ListImageScanFindingAggregationsRequest,
      ImageScanFindingAggregation,
      ListImageScanFindingAggregationsPublisher
    ](
      "listImageScanFindingAggregations",
      api.listImageScanFindingAggregationsPaginator,
      _.responses()
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.imagebuilder.model.ImageScanFindingAggregation.wrap(item)
      )
      .provideEnvironment(r)
    def listImageScanFindingAggregationsPaginated(
        request: ListImageScanFindingAggregationsRequest
    ): IO[
      AwsError,
      zio.aws.imagebuilder.model.ListImageScanFindingAggregationsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.imagebuilder.model.ListImageScanFindingAggregationsRequest,
      ListImageScanFindingAggregationsResponse
    ]("listImageScanFindingAggregations", api.listImageScanFindingAggregations)(
      request.buildAwsValue()
    ).map(
      zio.aws.imagebuilder.model.ListImageScanFindingAggregationsResponse.wrap
    ).provideEnvironment(r)
    def getImageRecipe(request: GetImageRecipeRequest): IO[
      AwsError,
      zio.aws.imagebuilder.model.GetImageRecipeResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.imagebuilder.model.GetImageRecipeRequest,
      GetImageRecipeResponse
    ]("getImageRecipe", api.getImageRecipe)(request.buildAwsValue())
      .map(zio.aws.imagebuilder.model.GetImageRecipeResponse.wrap)
      .provideEnvironment(r)
    def listImagePackages(request: ListImagePackagesRequest): ZStream[
      Any,
      AwsError,
      zio.aws.imagebuilder.model.ImagePackage.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.imagebuilder.model.ListImagePackagesRequest,
      ImagePackage,
      ListImagePackagesPublisher
    ](
      "listImagePackages",
      api.listImagePackagesPaginator,
      _.imagePackageList()
    )(request.buildAwsValue())
      .map(item => zio.aws.imagebuilder.model.ImagePackage.wrap(item))
      .provideEnvironment(r)
    def listImagePackagesPaginated(request: ListImagePackagesRequest): IO[
      AwsError,
      zio.aws.imagebuilder.model.ListImagePackagesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.imagebuilder.model.ListImagePackagesRequest,
      ListImagePackagesResponse
    ]("listImagePackages", api.listImagePackages)(request.buildAwsValue())
      .map(zio.aws.imagebuilder.model.ListImagePackagesResponse.wrap)
      .provideEnvironment(r)
    def getComponentPolicy(request: GetComponentPolicyRequest): IO[
      AwsError,
      zio.aws.imagebuilder.model.GetComponentPolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.imagebuilder.model.GetComponentPolicyRequest,
      GetComponentPolicyResponse
    ]("getComponentPolicy", api.getComponentPolicy)(request.buildAwsValue())
      .map(zio.aws.imagebuilder.model.GetComponentPolicyResponse.wrap)
      .provideEnvironment(r)
    def getContainerRecipe(request: GetContainerRecipeRequest): IO[
      AwsError,
      zio.aws.imagebuilder.model.GetContainerRecipeResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.imagebuilder.model.GetContainerRecipeRequest,
      GetContainerRecipeResponse
    ]("getContainerRecipe", api.getContainerRecipe)(request.buildAwsValue())
      .map(zio.aws.imagebuilder.model.GetContainerRecipeResponse.wrap)
      .provideEnvironment(r)
    def startImagePipelineExecution(
        request: StartImagePipelineExecutionRequest
    ): IO[
      AwsError,
      zio.aws.imagebuilder.model.StartImagePipelineExecutionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.imagebuilder.model.StartImagePipelineExecutionRequest,
      StartImagePipelineExecutionResponse
    ]("startImagePipelineExecution", api.startImagePipelineExecution)(
      request.buildAwsValue()
    ).map(zio.aws.imagebuilder.model.StartImagePipelineExecutionResponse.wrap)
      .provideEnvironment(r)
    def updateDistributionConfiguration(
        request: UpdateDistributionConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.imagebuilder.model.UpdateDistributionConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.imagebuilder.model.UpdateDistributionConfigurationRequest,
      UpdateDistributionConfigurationResponse
    ]("updateDistributionConfiguration", api.updateDistributionConfiguration)(
      request.buildAwsValue()
    ).map(
      zio.aws.imagebuilder.model.UpdateDistributionConfigurationResponse.wrap
    ).provideEnvironment(r)
    def getWorkflowExecution(request: GetWorkflowExecutionRequest): IO[
      AwsError,
      zio.aws.imagebuilder.model.GetWorkflowExecutionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.imagebuilder.model.GetWorkflowExecutionRequest,
      GetWorkflowExecutionResponse
    ]("getWorkflowExecution", api.getWorkflowExecution)(request.buildAwsValue())
      .map(zio.aws.imagebuilder.model.GetWorkflowExecutionResponse.wrap)
      .provideEnvironment(r)
    def deleteImage(
        request: DeleteImageRequest
    ): IO[AwsError, zio.aws.imagebuilder.model.DeleteImageResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.imagebuilder.model.DeleteImageRequest,
        DeleteImageResponse
      ]("deleteImage", api.deleteImage)(request.buildAwsValue())
        .map(zio.aws.imagebuilder.model.DeleteImageResponse.wrap)
        .provideEnvironment(r)
    def listWorkflowStepExecutions(
        request: ListWorkflowStepExecutionsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.imagebuilder.model.WorkflowStepMetadata.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.imagebuilder.model.ListWorkflowStepExecutionsRequest,
      WorkflowStepMetadata,
      ListWorkflowStepExecutionsPublisher
    ](
      "listWorkflowStepExecutions",
      api.listWorkflowStepExecutionsPaginator,
      _.steps()
    )(request.buildAwsValue())
      .map(item => zio.aws.imagebuilder.model.WorkflowStepMetadata.wrap(item))
      .provideEnvironment(r)
    def listWorkflowStepExecutionsPaginated(
        request: ListWorkflowStepExecutionsRequest
    ): IO[
      AwsError,
      zio.aws.imagebuilder.model.ListWorkflowStepExecutionsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.imagebuilder.model.ListWorkflowStepExecutionsRequest,
      ListWorkflowStepExecutionsResponse
    ]("listWorkflowStepExecutions", api.listWorkflowStepExecutions)(
      request.buildAwsValue()
    ).map(zio.aws.imagebuilder.model.ListWorkflowStepExecutionsResponse.wrap)
      .provideEnvironment(r)
    def createImageRecipe(request: CreateImageRecipeRequest): IO[
      AwsError,
      zio.aws.imagebuilder.model.CreateImageRecipeResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.imagebuilder.model.CreateImageRecipeRequest,
      CreateImageRecipeResponse
    ]("createImageRecipe", api.createImageRecipe)(request.buildAwsValue())
      .map(zio.aws.imagebuilder.model.CreateImageRecipeResponse.wrap)
      .provideEnvironment(r)
    def listComponentBuildVersions(
        request: ListComponentBuildVersionsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.imagebuilder.model.ComponentSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.imagebuilder.model.ListComponentBuildVersionsRequest,
      ComponentSummary,
      ListComponentBuildVersionsPublisher
    ](
      "listComponentBuildVersions",
      api.listComponentBuildVersionsPaginator,
      _.componentSummaryList()
    )(request.buildAwsValue())
      .map(item => zio.aws.imagebuilder.model.ComponentSummary.wrap(item))
      .provideEnvironment(r)
    def listComponentBuildVersionsPaginated(
        request: ListComponentBuildVersionsRequest
    ): IO[
      AwsError,
      zio.aws.imagebuilder.model.ListComponentBuildVersionsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.imagebuilder.model.ListComponentBuildVersionsRequest,
      ListComponentBuildVersionsResponse
    ]("listComponentBuildVersions", api.listComponentBuildVersions)(
      request.buildAwsValue()
    ).map(zio.aws.imagebuilder.model.ListComponentBuildVersionsResponse.wrap)
      .provideEnvironment(r)
    def putImagePolicy(request: PutImagePolicyRequest): IO[
      AwsError,
      zio.aws.imagebuilder.model.PutImagePolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.imagebuilder.model.PutImagePolicyRequest,
      PutImagePolicyResponse
    ]("putImagePolicy", api.putImagePolicy)(request.buildAwsValue())
      .map(zio.aws.imagebuilder.model.PutImagePolicyResponse.wrap)
      .provideEnvironment(r)
    def getDistributionConfiguration(
        request: GetDistributionConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.imagebuilder.model.GetDistributionConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.imagebuilder.model.GetDistributionConfigurationRequest,
      GetDistributionConfigurationResponse
    ]("getDistributionConfiguration", api.getDistributionConfiguration)(
      request.buildAwsValue()
    ).map(zio.aws.imagebuilder.model.GetDistributionConfigurationResponse.wrap)
      .provideEnvironment(r)
    def deleteImageRecipe(request: DeleteImageRecipeRequest): IO[
      AwsError,
      zio.aws.imagebuilder.model.DeleteImageRecipeResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.imagebuilder.model.DeleteImageRecipeRequest,
      DeleteImageRecipeResponse
    ]("deleteImageRecipe", api.deleteImageRecipe)(request.buildAwsValue())
      .map(zio.aws.imagebuilder.model.DeleteImageRecipeResponse.wrap)
      .provideEnvironment(r)
    def createContainerRecipe(request: CreateContainerRecipeRequest): IO[
      AwsError,
      zio.aws.imagebuilder.model.CreateContainerRecipeResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.imagebuilder.model.CreateContainerRecipeRequest,
      CreateContainerRecipeResponse
    ]("createContainerRecipe", api.createContainerRecipe)(
      request.buildAwsValue()
    ).map(zio.aws.imagebuilder.model.CreateContainerRecipeResponse.wrap)
      .provideEnvironment(r)
    def deleteDistributionConfiguration(
        request: DeleteDistributionConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.imagebuilder.model.DeleteDistributionConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.imagebuilder.model.DeleteDistributionConfigurationRequest,
      DeleteDistributionConfigurationResponse
    ]("deleteDistributionConfiguration", api.deleteDistributionConfiguration)(
      request.buildAwsValue()
    ).map(
      zio.aws.imagebuilder.model.DeleteDistributionConfigurationResponse.wrap
    ).provideEnvironment(r)
    def importDiskImage(request: ImportDiskImageRequest): IO[
      AwsError,
      zio.aws.imagebuilder.model.ImportDiskImageResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.imagebuilder.model.ImportDiskImageRequest,
      ImportDiskImageResponse
    ]("importDiskImage", api.importDiskImage)(request.buildAwsValue())
      .map(zio.aws.imagebuilder.model.ImportDiskImageResponse.wrap)
      .provideEnvironment(r)
    def putContainerRecipePolicy(request: PutContainerRecipePolicyRequest): IO[
      AwsError,
      zio.aws.imagebuilder.model.PutContainerRecipePolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.imagebuilder.model.PutContainerRecipePolicyRequest,
      PutContainerRecipePolicyResponse
    ]("putContainerRecipePolicy", api.putContainerRecipePolicy)(
      request.buildAwsValue()
    ).map(zio.aws.imagebuilder.model.PutContainerRecipePolicyResponse.wrap)
      .provideEnvironment(r)
    def createInfrastructureConfiguration(
        request: CreateInfrastructureConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.imagebuilder.model.CreateInfrastructureConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.imagebuilder.model.CreateInfrastructureConfigurationRequest,
      CreateInfrastructureConfigurationResponse
    ](
      "createInfrastructureConfiguration",
      api.createInfrastructureConfiguration
    )(request.buildAwsValue())
      .map(
        zio.aws.imagebuilder.model.CreateInfrastructureConfigurationResponse.wrap
      )
      .provideEnvironment(r)
    def listComponents(request: ListComponentsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.imagebuilder.model.ComponentVersion.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.imagebuilder.model.ListComponentsRequest,
      ComponentVersion,
      ListComponentsPublisher
    ]("listComponents", api.listComponentsPaginator, _.componentVersionList())(
      request.buildAwsValue()
    ).map(item => zio.aws.imagebuilder.model.ComponentVersion.wrap(item))
      .provideEnvironment(r)
    def listComponentsPaginated(request: ListComponentsRequest): IO[
      AwsError,
      zio.aws.imagebuilder.model.ListComponentsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.imagebuilder.model.ListComponentsRequest,
      ListComponentsResponse
    ]("listComponents", api.listComponents)(request.buildAwsValue())
      .map(zio.aws.imagebuilder.model.ListComponentsResponse.wrap)
      .provideEnvironment(r)
    def sendWorkflowStepAction(request: SendWorkflowStepActionRequest): IO[
      AwsError,
      zio.aws.imagebuilder.model.SendWorkflowStepActionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.imagebuilder.model.SendWorkflowStepActionRequest,
      SendWorkflowStepActionResponse
    ]("sendWorkflowStepAction", api.sendWorkflowStepAction)(
      request.buildAwsValue()
    ).map(zio.aws.imagebuilder.model.SendWorkflowStepActionResponse.wrap)
      .provideEnvironment(r)
    def createImage(
        request: CreateImageRequest
    ): IO[AwsError, zio.aws.imagebuilder.model.CreateImageResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.imagebuilder.model.CreateImageRequest,
        CreateImageResponse
      ]("createImage", api.createImage)(request.buildAwsValue())
        .map(zio.aws.imagebuilder.model.CreateImageResponse.wrap)
        .provideEnvironment(r)
    def deleteLifecyclePolicy(request: DeleteLifecyclePolicyRequest): IO[
      AwsError,
      zio.aws.imagebuilder.model.DeleteLifecyclePolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.imagebuilder.model.DeleteLifecyclePolicyRequest,
      DeleteLifecyclePolicyResponse
    ]("deleteLifecyclePolicy", api.deleteLifecyclePolicy)(
      request.buildAwsValue()
    ).map(zio.aws.imagebuilder.model.DeleteLifecyclePolicyResponse.wrap)
      .provideEnvironment(r)
    def deleteInfrastructureConfiguration(
        request: DeleteInfrastructureConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.imagebuilder.model.DeleteInfrastructureConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.imagebuilder.model.DeleteInfrastructureConfigurationRequest,
      DeleteInfrastructureConfigurationResponse
    ](
      "deleteInfrastructureConfiguration",
      api.deleteInfrastructureConfiguration
    )(request.buildAwsValue())
      .map(
        zio.aws.imagebuilder.model.DeleteInfrastructureConfigurationResponse.wrap
      )
      .provideEnvironment(r)
    def untagResource(
        request: UntagResourceRequest
    ): IO[AwsError, zio.aws.imagebuilder.model.UntagResourceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.imagebuilder.model.UntagResourceRequest,
        UntagResourceResponse
      ]("untagResource", api.untagResource)(request.buildAwsValue())
        .map(zio.aws.imagebuilder.model.UntagResourceResponse.wrap)
        .provideEnvironment(r)
    def listLifecycleExecutions(
        request: ListLifecycleExecutionsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.imagebuilder.model.LifecycleExecution.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.imagebuilder.model.ListLifecycleExecutionsRequest,
      LifecycleExecution,
      ListLifecycleExecutionsPublisher
    ](
      "listLifecycleExecutions",
      api.listLifecycleExecutionsPaginator,
      _.lifecycleExecutions()
    )(request.buildAwsValue())
      .map(item => zio.aws.imagebuilder.model.LifecycleExecution.wrap(item))
      .provideEnvironment(r)
    def listLifecycleExecutionsPaginated(
        request: ListLifecycleExecutionsRequest
    ): IO[
      AwsError,
      zio.aws.imagebuilder.model.ListLifecycleExecutionsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.imagebuilder.model.ListLifecycleExecutionsRequest,
      ListLifecycleExecutionsResponse
    ]("listLifecycleExecutions", api.listLifecycleExecutions)(
      request.buildAwsValue()
    ).map(zio.aws.imagebuilder.model.ListLifecycleExecutionsResponse.wrap)
      .provideEnvironment(r)
    def getLifecycleExecution(request: GetLifecycleExecutionRequest): IO[
      AwsError,
      zio.aws.imagebuilder.model.GetLifecycleExecutionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.imagebuilder.model.GetLifecycleExecutionRequest,
      GetLifecycleExecutionResponse
    ]("getLifecycleExecution", api.getLifecycleExecution)(
      request.buildAwsValue()
    ).map(zio.aws.imagebuilder.model.GetLifecycleExecutionResponse.wrap)
      .provideEnvironment(r)
    def deleteComponent(request: DeleteComponentRequest): IO[
      AwsError,
      zio.aws.imagebuilder.model.DeleteComponentResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.imagebuilder.model.DeleteComponentRequest,
      DeleteComponentResponse
    ]("deleteComponent", api.deleteComponent)(request.buildAwsValue())
      .map(zio.aws.imagebuilder.model.DeleteComponentResponse.wrap)
      .provideEnvironment(r)
    def listImagePipelines(request: ListImagePipelinesRequest): ZStream[
      Any,
      AwsError,
      zio.aws.imagebuilder.model.ImagePipeline.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.imagebuilder.model.ListImagePipelinesRequest,
      ImagePipeline,
      ListImagePipelinesPublisher
    ](
      "listImagePipelines",
      api.listImagePipelinesPaginator,
      _.imagePipelineList()
    )(request.buildAwsValue())
      .map(item => zio.aws.imagebuilder.model.ImagePipeline.wrap(item))
      .provideEnvironment(r)
    def listImagePipelinesPaginated(request: ListImagePipelinesRequest): IO[
      AwsError,
      zio.aws.imagebuilder.model.ListImagePipelinesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.imagebuilder.model.ListImagePipelinesRequest,
      ListImagePipelinesResponse
    ]("listImagePipelines", api.listImagePipelines)(request.buildAwsValue())
      .map(zio.aws.imagebuilder.model.ListImagePipelinesResponse.wrap)
      .provideEnvironment(r)
    def listDistributionConfigurations(
        request: ListDistributionConfigurationsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.imagebuilder.model.DistributionConfigurationSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.imagebuilder.model.ListDistributionConfigurationsRequest,
      DistributionConfigurationSummary,
      ListDistributionConfigurationsPublisher
    ](
      "listDistributionConfigurations",
      api.listDistributionConfigurationsPaginator,
      _.distributionConfigurationSummaryList()
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.imagebuilder.model.DistributionConfigurationSummary.wrap(item)
      )
      .provideEnvironment(r)
    def listDistributionConfigurationsPaginated(
        request: ListDistributionConfigurationsRequest
    ): IO[
      AwsError,
      zio.aws.imagebuilder.model.ListDistributionConfigurationsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.imagebuilder.model.ListDistributionConfigurationsRequest,
      ListDistributionConfigurationsResponse
    ]("listDistributionConfigurations", api.listDistributionConfigurations)(
      request.buildAwsValue()
    ).map(
      zio.aws.imagebuilder.model.ListDistributionConfigurationsResponse.wrap
    ).provideEnvironment(r)
    def getContainerRecipePolicy(request: GetContainerRecipePolicyRequest): IO[
      AwsError,
      zio.aws.imagebuilder.model.GetContainerRecipePolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.imagebuilder.model.GetContainerRecipePolicyRequest,
      GetContainerRecipePolicyResponse
    ]("getContainerRecipePolicy", api.getContainerRecipePolicy)(
      request.buildAwsValue()
    ).map(zio.aws.imagebuilder.model.GetContainerRecipePolicyResponse.wrap)
      .provideEnvironment(r)
    def listWaitingWorkflowSteps(
        request: ListWaitingWorkflowStepsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.imagebuilder.model.WorkflowStepExecution.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.imagebuilder.model.ListWaitingWorkflowStepsRequest,
      WorkflowStepExecution,
      ListWaitingWorkflowStepsPublisher
    ](
      "listWaitingWorkflowSteps",
      api.listWaitingWorkflowStepsPaginator,
      _.steps()
    )(request.buildAwsValue())
      .map(item => zio.aws.imagebuilder.model.WorkflowStepExecution.wrap(item))
      .provideEnvironment(r)
    def listWaitingWorkflowStepsPaginated(
        request: ListWaitingWorkflowStepsRequest
    ): IO[
      AwsError,
      zio.aws.imagebuilder.model.ListWaitingWorkflowStepsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.imagebuilder.model.ListWaitingWorkflowStepsRequest,
      ListWaitingWorkflowStepsResponse
    ]("listWaitingWorkflowSteps", api.listWaitingWorkflowSteps)(
      request.buildAwsValue()
    ).map(zio.aws.imagebuilder.model.ListWaitingWorkflowStepsResponse.wrap)
      .provideEnvironment(r)
    def getWorkflow(
        request: GetWorkflowRequest
    ): IO[AwsError, zio.aws.imagebuilder.model.GetWorkflowResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.imagebuilder.model.GetWorkflowRequest,
        GetWorkflowResponse
      ]("getWorkflow", api.getWorkflow)(request.buildAwsValue())
        .map(zio.aws.imagebuilder.model.GetWorkflowResponse.wrap)
        .provideEnvironment(r)
    def listImagePipelineImages(
        request: ListImagePipelineImagesRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.imagebuilder.model.ImageSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.imagebuilder.model.ListImagePipelineImagesRequest,
      ImageSummary,
      ListImagePipelineImagesPublisher
    ](
      "listImagePipelineImages",
      api.listImagePipelineImagesPaginator,
      _.imageSummaryList()
    )(request.buildAwsValue())
      .map(item => zio.aws.imagebuilder.model.ImageSummary.wrap(item))
      .provideEnvironment(r)
    def listImagePipelineImagesPaginated(
        request: ListImagePipelineImagesRequest
    ): IO[
      AwsError,
      zio.aws.imagebuilder.model.ListImagePipelineImagesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.imagebuilder.model.ListImagePipelineImagesRequest,
      ListImagePipelineImagesResponse
    ]("listImagePipelineImages", api.listImagePipelineImages)(
      request.buildAwsValue()
    ).map(zio.aws.imagebuilder.model.ListImagePipelineImagesResponse.wrap)
      .provideEnvironment(r)
    def createDistributionConfiguration(
        request: CreateDistributionConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.imagebuilder.model.CreateDistributionConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.imagebuilder.model.CreateDistributionConfigurationRequest,
      CreateDistributionConfigurationResponse
    ]("createDistributionConfiguration", api.createDistributionConfiguration)(
      request.buildAwsValue()
    ).map(
      zio.aws.imagebuilder.model.CreateDistributionConfigurationResponse.wrap
    ).provideEnvironment(r)
    def importComponent(request: ImportComponentRequest): IO[
      AwsError,
      zio.aws.imagebuilder.model.ImportComponentResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.imagebuilder.model.ImportComponentRequest,
      ImportComponentResponse
    ]("importComponent", api.importComponent)(request.buildAwsValue())
      .map(zio.aws.imagebuilder.model.ImportComponentResponse.wrap)
      .provideEnvironment(r)
    def createComponent(request: CreateComponentRequest): IO[
      AwsError,
      zio.aws.imagebuilder.model.CreateComponentResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.imagebuilder.model.CreateComponentRequest,
      CreateComponentResponse
    ]("createComponent", api.createComponent)(request.buildAwsValue())
      .map(zio.aws.imagebuilder.model.CreateComponentResponse.wrap)
      .provideEnvironment(r)
    def getImagePipeline(request: GetImagePipelineRequest): IO[
      AwsError,
      zio.aws.imagebuilder.model.GetImagePipelineResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.imagebuilder.model.GetImagePipelineRequest,
      GetImagePipelineResponse
    ]("getImagePipeline", api.getImagePipeline)(request.buildAwsValue())
      .map(zio.aws.imagebuilder.model.GetImagePipelineResponse.wrap)
      .provideEnvironment(r)
    def listTagsForResource(request: ListTagsForResourceRequest): IO[
      AwsError,
      zio.aws.imagebuilder.model.ListTagsForResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.imagebuilder.model.ListTagsForResourceRequest,
      ListTagsForResourceResponse
    ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
      .map(zio.aws.imagebuilder.model.ListTagsForResourceResponse.wrap)
      .provideEnvironment(r)
    def tagResource(
        request: TagResourceRequest
    ): IO[AwsError, zio.aws.imagebuilder.model.TagResourceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.imagebuilder.model.TagResourceRequest,
        TagResourceResponse
      ]("tagResource", api.tagResource)(request.buildAwsValue())
        .map(zio.aws.imagebuilder.model.TagResourceResponse.wrap)
        .provideEnvironment(r)
    def listWorkflowExecutions(request: ListWorkflowExecutionsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.imagebuilder.model.WorkflowExecutionMetadata.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.imagebuilder.model.ListWorkflowExecutionsRequest,
      WorkflowExecutionMetadata,
      ListWorkflowExecutionsPublisher
    ](
      "listWorkflowExecutions",
      api.listWorkflowExecutionsPaginator,
      _.workflowExecutions()
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.imagebuilder.model.WorkflowExecutionMetadata.wrap(item)
      )
      .provideEnvironment(r)
    def listWorkflowExecutionsPaginated(
        request: ListWorkflowExecutionsRequest
    ): IO[
      AwsError,
      zio.aws.imagebuilder.model.ListWorkflowExecutionsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.imagebuilder.model.ListWorkflowExecutionsRequest,
      ListWorkflowExecutionsResponse
    ]("listWorkflowExecutions", api.listWorkflowExecutions)(
      request.buildAwsValue()
    ).map(zio.aws.imagebuilder.model.ListWorkflowExecutionsResponse.wrap)
      .provideEnvironment(r)
    def createImagePipeline(request: CreateImagePipelineRequest): IO[
      AwsError,
      zio.aws.imagebuilder.model.CreateImagePipelineResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.imagebuilder.model.CreateImagePipelineRequest,
      CreateImagePipelineResponse
    ]("createImagePipeline", api.createImagePipeline)(request.buildAwsValue())
      .map(zio.aws.imagebuilder.model.CreateImagePipelineResponse.wrap)
      .provideEnvironment(r)
    def listInfrastructureConfigurations(
        request: ListInfrastructureConfigurationsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.imagebuilder.model.InfrastructureConfigurationSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.imagebuilder.model.ListInfrastructureConfigurationsRequest,
      InfrastructureConfigurationSummary,
      ListInfrastructureConfigurationsPublisher
    ](
      "listInfrastructureConfigurations",
      api.listInfrastructureConfigurationsPaginator,
      _.infrastructureConfigurationSummaryList()
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.imagebuilder.model.InfrastructureConfigurationSummary.wrap(item)
      )
      .provideEnvironment(r)
    def listInfrastructureConfigurationsPaginated(
        request: ListInfrastructureConfigurationsRequest
    ): IO[
      AwsError,
      zio.aws.imagebuilder.model.ListInfrastructureConfigurationsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.imagebuilder.model.ListInfrastructureConfigurationsRequest,
      ListInfrastructureConfigurationsResponse
    ]("listInfrastructureConfigurations", api.listInfrastructureConfigurations)(
      request.buildAwsValue()
    ).map(
      zio.aws.imagebuilder.model.ListInfrastructureConfigurationsResponse.wrap
    ).provideEnvironment(r)
    def listWorkflowBuildVersions(
        request: ListWorkflowBuildVersionsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.imagebuilder.model.WorkflowSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.imagebuilder.model.ListWorkflowBuildVersionsRequest,
      WorkflowSummary,
      ListWorkflowBuildVersionsPublisher
    ](
      "listWorkflowBuildVersions",
      api.listWorkflowBuildVersionsPaginator,
      _.workflowSummaryList()
    )(request.buildAwsValue())
      .map(item => zio.aws.imagebuilder.model.WorkflowSummary.wrap(item))
      .provideEnvironment(r)
    def listWorkflowBuildVersionsPaginated(
        request: ListWorkflowBuildVersionsRequest
    ): IO[
      AwsError,
      zio.aws.imagebuilder.model.ListWorkflowBuildVersionsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.imagebuilder.model.ListWorkflowBuildVersionsRequest,
      ListWorkflowBuildVersionsResponse
    ]("listWorkflowBuildVersions", api.listWorkflowBuildVersions)(
      request.buildAwsValue()
    ).map(zio.aws.imagebuilder.model.ListWorkflowBuildVersionsResponse.wrap)
      .provideEnvironment(r)
    def listWorkflows(request: ListWorkflowsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.imagebuilder.model.WorkflowVersion.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.imagebuilder.model.ListWorkflowsRequest,
      WorkflowVersion,
      ListWorkflowsPublisher
    ]("listWorkflows", api.listWorkflowsPaginator, _.workflowVersionList())(
      request.buildAwsValue()
    ).map(item => zio.aws.imagebuilder.model.WorkflowVersion.wrap(item))
      .provideEnvironment(r)
    def listWorkflowsPaginated(
        request: ListWorkflowsRequest
    ): IO[AwsError, zio.aws.imagebuilder.model.ListWorkflowsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.imagebuilder.model.ListWorkflowsRequest,
        ListWorkflowsResponse
      ]("listWorkflows", api.listWorkflows)(request.buildAwsValue())
        .map(zio.aws.imagebuilder.model.ListWorkflowsResponse.wrap)
        .provideEnvironment(r)
    def getInfrastructureConfiguration(
        request: GetInfrastructureConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.imagebuilder.model.GetInfrastructureConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.imagebuilder.model.GetInfrastructureConfigurationRequest,
      GetInfrastructureConfigurationResponse
    ]("getInfrastructureConfiguration", api.getInfrastructureConfiguration)(
      request.buildAwsValue()
    ).map(
      zio.aws.imagebuilder.model.GetInfrastructureConfigurationResponse.wrap
    ).provideEnvironment(r)
    def deleteContainerRecipe(request: DeleteContainerRecipeRequest): IO[
      AwsError,
      zio.aws.imagebuilder.model.DeleteContainerRecipeResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.imagebuilder.model.DeleteContainerRecipeRequest,
      DeleteContainerRecipeResponse
    ]("deleteContainerRecipe", api.deleteContainerRecipe)(
      request.buildAwsValue()
    ).map(zio.aws.imagebuilder.model.DeleteContainerRecipeResponse.wrap)
      .provideEnvironment(r)
    def getImage(
        request: GetImageRequest
    ): IO[AwsError, zio.aws.imagebuilder.model.GetImageResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.imagebuilder.model.GetImageRequest,
        GetImageResponse
      ]("getImage", api.getImage)(request.buildAwsValue())
        .map(zio.aws.imagebuilder.model.GetImageResponse.wrap)
        .provideEnvironment(r)
    def listLifecyclePolicies(request: ListLifecyclePoliciesRequest): ZStream[
      Any,
      AwsError,
      zio.aws.imagebuilder.model.LifecyclePolicySummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.imagebuilder.model.ListLifecyclePoliciesRequest,
      LifecyclePolicySummary,
      ListLifecyclePoliciesPublisher
    ](
      "listLifecyclePolicies",
      api.listLifecyclePoliciesPaginator,
      _.lifecyclePolicySummaryList()
    )(request.buildAwsValue())
      .map(item => zio.aws.imagebuilder.model.LifecyclePolicySummary.wrap(item))
      .provideEnvironment(r)
    def listLifecyclePoliciesPaginated(
        request: ListLifecyclePoliciesRequest
    ): IO[
      AwsError,
      zio.aws.imagebuilder.model.ListLifecyclePoliciesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.imagebuilder.model.ListLifecyclePoliciesRequest,
      ListLifecyclePoliciesResponse
    ]("listLifecyclePolicies", api.listLifecyclePolicies)(
      request.buildAwsValue()
    ).map(zio.aws.imagebuilder.model.ListLifecyclePoliciesResponse.wrap)
      .provideEnvironment(r)
    def createLifecyclePolicy(request: CreateLifecyclePolicyRequest): IO[
      AwsError,
      zio.aws.imagebuilder.model.CreateLifecyclePolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.imagebuilder.model.CreateLifecyclePolicyRequest,
      CreateLifecyclePolicyResponse
    ]("createLifecyclePolicy", api.createLifecyclePolicy)(
      request.buildAwsValue()
    ).map(zio.aws.imagebuilder.model.CreateLifecyclePolicyResponse.wrap)
      .provideEnvironment(r)
    def listContainerRecipes(request: ListContainerRecipesRequest): ZStream[
      Any,
      AwsError,
      zio.aws.imagebuilder.model.ContainerRecipeSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.imagebuilder.model.ListContainerRecipesRequest,
      ContainerRecipeSummary,
      ListContainerRecipesPublisher
    ](
      "listContainerRecipes",
      api.listContainerRecipesPaginator,
      _.containerRecipeSummaryList()
    )(request.buildAwsValue())
      .map(item => zio.aws.imagebuilder.model.ContainerRecipeSummary.wrap(item))
      .provideEnvironment(r)
    def listContainerRecipesPaginated(request: ListContainerRecipesRequest): IO[
      AwsError,
      zio.aws.imagebuilder.model.ListContainerRecipesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.imagebuilder.model.ListContainerRecipesRequest,
      ListContainerRecipesResponse
    ]("listContainerRecipes", api.listContainerRecipes)(request.buildAwsValue())
      .map(zio.aws.imagebuilder.model.ListContainerRecipesResponse.wrap)
      .provideEnvironment(r)
    def cancelLifecycleExecution(request: CancelLifecycleExecutionRequest): IO[
      AwsError,
      zio.aws.imagebuilder.model.CancelLifecycleExecutionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.imagebuilder.model.CancelLifecycleExecutionRequest,
      CancelLifecycleExecutionResponse
    ]("cancelLifecycleExecution", api.cancelLifecycleExecution)(
      request.buildAwsValue()
    ).map(zio.aws.imagebuilder.model.CancelLifecycleExecutionResponse.wrap)
      .provideEnvironment(r)
    def deleteImagePipeline(request: DeleteImagePipelineRequest): IO[
      AwsError,
      zio.aws.imagebuilder.model.DeleteImagePipelineResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.imagebuilder.model.DeleteImagePipelineRequest,
      DeleteImagePipelineResponse
    ]("deleteImagePipeline", api.deleteImagePipeline)(request.buildAwsValue())
      .map(zio.aws.imagebuilder.model.DeleteImagePipelineResponse.wrap)
      .provideEnvironment(r)
    def putImageRecipePolicy(request: PutImageRecipePolicyRequest): IO[
      AwsError,
      zio.aws.imagebuilder.model.PutImageRecipePolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.imagebuilder.model.PutImageRecipePolicyRequest,
      PutImageRecipePolicyResponse
    ]("putImageRecipePolicy", api.putImageRecipePolicy)(request.buildAwsValue())
      .map(zio.aws.imagebuilder.model.PutImageRecipePolicyResponse.wrap)
      .provideEnvironment(r)
    def updateImagePipeline(
        request: UpdateImagePipelineRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      software.amazon.awssdk.services.imagebuilder.model.UpdateImagePipelineRequest,
      UpdateImagePipelineResponse
    ]("updateImagePipeline", api.updateImagePipeline)(request.buildAwsValue())
      .map(zio.aws.imagebuilder.model.UpdateImagePipelineResponse.wrap)
      .provideEnvironment(r)
    def deleteWorkflow(request: DeleteWorkflowRequest): IO[
      AwsError,
      zio.aws.imagebuilder.model.DeleteWorkflowResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.imagebuilder.model.DeleteWorkflowRequest,
      DeleteWorkflowResponse
    ]("deleteWorkflow", api.deleteWorkflow)(request.buildAwsValue())
      .map(zio.aws.imagebuilder.model.DeleteWorkflowResponse.wrap)
      .provideEnvironment(r)
    def getMarketplaceResource(request: GetMarketplaceResourceRequest): IO[
      AwsError,
      zio.aws.imagebuilder.model.GetMarketplaceResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.imagebuilder.model.GetMarketplaceResourceRequest,
      GetMarketplaceResourceResponse
    ]("getMarketplaceResource", api.getMarketplaceResource)(
      request.buildAwsValue()
    ).map(zio.aws.imagebuilder.model.GetMarketplaceResourceResponse.wrap)
      .provideEnvironment(r)
    def getImageRecipePolicy(request: GetImageRecipePolicyRequest): IO[
      AwsError,
      zio.aws.imagebuilder.model.GetImageRecipePolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.imagebuilder.model.GetImageRecipePolicyRequest,
      GetImageRecipePolicyResponse
    ]("getImageRecipePolicy", api.getImageRecipePolicy)(request.buildAwsValue())
      .map(zio.aws.imagebuilder.model.GetImageRecipePolicyResponse.wrap)
      .provideEnvironment(r)
    def listImageBuildVersions(request: ListImageBuildVersionsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.imagebuilder.model.ImageSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.imagebuilder.model.ListImageBuildVersionsRequest,
      ImageSummary,
      ListImageBuildVersionsPublisher
    ](
      "listImageBuildVersions",
      api.listImageBuildVersionsPaginator,
      _.imageSummaryList()
    )(request.buildAwsValue())
      .map(item => zio.aws.imagebuilder.model.ImageSummary.wrap(item))
      .provideEnvironment(r)
    def listImageBuildVersionsPaginated(
        request: ListImageBuildVersionsRequest
    ): IO[
      AwsError,
      zio.aws.imagebuilder.model.ListImageBuildVersionsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.imagebuilder.model.ListImageBuildVersionsRequest,
      ListImageBuildVersionsResponse
    ]("listImageBuildVersions", api.listImageBuildVersions)(
      request.buildAwsValue()
    ).map(zio.aws.imagebuilder.model.ListImageBuildVersionsResponse.wrap)
      .provideEnvironment(r)
    def updateInfrastructureConfiguration(
        request: UpdateInfrastructureConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.imagebuilder.model.UpdateInfrastructureConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.imagebuilder.model.UpdateInfrastructureConfigurationRequest,
      UpdateInfrastructureConfigurationResponse
    ](
      "updateInfrastructureConfiguration",
      api.updateInfrastructureConfiguration
    )(request.buildAwsValue())
      .map(
        zio.aws.imagebuilder.model.UpdateInfrastructureConfigurationResponse.wrap
      )
      .provideEnvironment(r)
    def getComponent(
        request: GetComponentRequest
    ): IO[AwsError, zio.aws.imagebuilder.model.GetComponentResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.imagebuilder.model.GetComponentRequest,
        GetComponentResponse
      ]("getComponent", api.getComponent)(request.buildAwsValue())
        .map(zio.aws.imagebuilder.model.GetComponentResponse.wrap)
        .provideEnvironment(r)
    def listLifecycleExecutionResources(
        request: ListLifecycleExecutionResourcesRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.imagebuilder.model.LifecycleExecutionResource.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.imagebuilder.model.ListLifecycleExecutionResourcesRequest,
      LifecycleExecutionResource,
      ListLifecycleExecutionResourcesPublisher
    ](
      "listLifecycleExecutionResources",
      api.listLifecycleExecutionResourcesPaginator,
      _.resources()
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.imagebuilder.model.LifecycleExecutionResource.wrap(item)
      )
      .provideEnvironment(r)
    def listLifecycleExecutionResourcesPaginated(
        request: ListLifecycleExecutionResourcesRequest
    ): IO[
      AwsError,
      zio.aws.imagebuilder.model.ListLifecycleExecutionResourcesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.imagebuilder.model.ListLifecycleExecutionResourcesRequest,
      ListLifecycleExecutionResourcesResponse
    ]("listLifecycleExecutionResources", api.listLifecycleExecutionResources)(
      request.buildAwsValue()
    ).map(
      zio.aws.imagebuilder.model.ListLifecycleExecutionResourcesResponse.wrap
    ).provideEnvironment(r)
    def getWorkflowStepExecution(request: GetWorkflowStepExecutionRequest): IO[
      AwsError,
      zio.aws.imagebuilder.model.GetWorkflowStepExecutionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.imagebuilder.model.GetWorkflowStepExecutionRequest,
      GetWorkflowStepExecutionResponse
    ]("getWorkflowStepExecution", api.getWorkflowStepExecution)(
      request.buildAwsValue()
    ).map(zio.aws.imagebuilder.model.GetWorkflowStepExecutionResponse.wrap)
      .provideEnvironment(r)
    def getLifecyclePolicy(request: GetLifecyclePolicyRequest): IO[
      AwsError,
      zio.aws.imagebuilder.model.GetLifecyclePolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.imagebuilder.model.GetLifecyclePolicyRequest,
      GetLifecyclePolicyResponse
    ]("getLifecyclePolicy", api.getLifecyclePolicy)(request.buildAwsValue())
      .map(zio.aws.imagebuilder.model.GetLifecyclePolicyResponse.wrap)
      .provideEnvironment(r)
    def createWorkflow(request: CreateWorkflowRequest): IO[
      AwsError,
      zio.aws.imagebuilder.model.CreateWorkflowResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.imagebuilder.model.CreateWorkflowRequest,
      CreateWorkflowResponse
    ]("createWorkflow", api.createWorkflow)(request.buildAwsValue())
      .map(zio.aws.imagebuilder.model.CreateWorkflowResponse.wrap)
      .provideEnvironment(r)
    def updateLifecyclePolicy(request: UpdateLifecyclePolicyRequest): IO[
      AwsError,
      zio.aws.imagebuilder.model.UpdateLifecyclePolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.imagebuilder.model.UpdateLifecyclePolicyRequest,
      UpdateLifecyclePolicyResponse
    ]("updateLifecyclePolicy", api.updateLifecyclePolicy)(
      request.buildAwsValue()
    ).map(zio.aws.imagebuilder.model.UpdateLifecyclePolicyResponse.wrap)
      .provideEnvironment(r)
    def importVmImage(
        request: ImportVmImageRequest
    ): IO[AwsError, zio.aws.imagebuilder.model.ImportVmImageResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.imagebuilder.model.ImportVmImageRequest,
        ImportVmImageResponse
      ]("importVmImage", api.importVmImage)(request.buildAwsValue())
        .map(zio.aws.imagebuilder.model.ImportVmImageResponse.wrap)
        .provideEnvironment(r)
    def cancelImageCreation(request: CancelImageCreationRequest): IO[
      AwsError,
      zio.aws.imagebuilder.model.CancelImageCreationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.imagebuilder.model.CancelImageCreationRequest,
      CancelImageCreationResponse
    ]("cancelImageCreation", api.cancelImageCreation)(request.buildAwsValue())
      .map(zio.aws.imagebuilder.model.CancelImageCreationResponse.wrap)
      .provideEnvironment(r)
    def getImagePolicy(request: GetImagePolicyRequest): IO[
      AwsError,
      zio.aws.imagebuilder.model.GetImagePolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.imagebuilder.model.GetImagePolicyRequest,
      GetImagePolicyResponse
    ]("getImagePolicy", api.getImagePolicy)(request.buildAwsValue())
      .map(zio.aws.imagebuilder.model.GetImagePolicyResponse.wrap)
      .provideEnvironment(r)
  }
  def listImages(request: ListImagesRequest): ZStream[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.ImageVersion.ReadOnly
  ] = ZStream.serviceWithStream(_.listImages(request))
  def listImagesPaginated(request: ListImagesRequest): ZIO[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.ListImagesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listImagesPaginated(request))
  def listImageRecipes(request: ListImageRecipesRequest): ZStream[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.ImageRecipeSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listImageRecipes(request))
  def listImageRecipesPaginated(request: ListImageRecipesRequest): ZIO[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.ListImageRecipesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listImageRecipesPaginated(request))
  def putComponentPolicy(request: PutComponentPolicyRequest): ZIO[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.PutComponentPolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putComponentPolicy(request))
  def startResourceStateUpdate(request: StartResourceStateUpdateRequest): ZIO[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.StartResourceStateUpdateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startResourceStateUpdate(request))
  def listImageScanFindings(request: ListImageScanFindingsRequest): ZStream[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.ImageScanFinding.ReadOnly
  ] = ZStream.serviceWithStream(_.listImageScanFindings(request))
  def listImageScanFindingsPaginated(
      request: ListImageScanFindingsRequest
  ): ZIO[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.ListImageScanFindingsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listImageScanFindingsPaginated(request))
  def listImageScanFindingAggregations(
      request: ListImageScanFindingAggregationsRequest
  ): ZStream[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.ImageScanFindingAggregation.ReadOnly
  ] = ZStream.serviceWithStream(_.listImageScanFindingAggregations(request))
  def listImageScanFindingAggregationsPaginated(
      request: ListImageScanFindingAggregationsRequest
  ): ZIO[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.ListImageScanFindingAggregationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listImageScanFindingAggregationsPaginated(request))
  def getImageRecipe(request: GetImageRecipeRequest): ZIO[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.GetImageRecipeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getImageRecipe(request))
  def listImagePackages(request: ListImagePackagesRequest): ZStream[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.ImagePackage.ReadOnly
  ] = ZStream.serviceWithStream(_.listImagePackages(request))
  def listImagePackagesPaginated(request: ListImagePackagesRequest): ZIO[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.ListImagePackagesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listImagePackagesPaginated(request))
  def getComponentPolicy(request: GetComponentPolicyRequest): ZIO[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.GetComponentPolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getComponentPolicy(request))
  def getContainerRecipe(request: GetContainerRecipeRequest): ZIO[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.GetContainerRecipeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getContainerRecipe(request))
  def startImagePipelineExecution(
      request: StartImagePipelineExecutionRequest
  ): ZIO[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.StartImagePipelineExecutionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startImagePipelineExecution(request))
  def updateDistributionConfiguration(
      request: UpdateDistributionConfigurationRequest
  ): ZIO[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.UpdateDistributionConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateDistributionConfiguration(request))
  def getWorkflowExecution(request: GetWorkflowExecutionRequest): ZIO[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.GetWorkflowExecutionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getWorkflowExecution(request))
  def deleteImage(request: DeleteImageRequest): ZIO[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.DeleteImageResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteImage(request))
  def listWorkflowStepExecutions(
      request: ListWorkflowStepExecutionsRequest
  ): ZStream[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.WorkflowStepMetadata.ReadOnly
  ] = ZStream.serviceWithStream(_.listWorkflowStepExecutions(request))
  def listWorkflowStepExecutionsPaginated(
      request: ListWorkflowStepExecutionsRequest
  ): ZIO[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.ListWorkflowStepExecutionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listWorkflowStepExecutionsPaginated(request))
  def createImageRecipe(request: CreateImageRecipeRequest): ZIO[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.CreateImageRecipeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createImageRecipe(request))
  def listComponentBuildVersions(
      request: ListComponentBuildVersionsRequest
  ): ZStream[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.ComponentSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listComponentBuildVersions(request))
  def listComponentBuildVersionsPaginated(
      request: ListComponentBuildVersionsRequest
  ): ZIO[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.ListComponentBuildVersionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listComponentBuildVersionsPaginated(request))
  def putImagePolicy(request: PutImagePolicyRequest): ZIO[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.PutImagePolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putImagePolicy(request))
  def getDistributionConfiguration(
      request: GetDistributionConfigurationRequest
  ): ZIO[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.GetDistributionConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getDistributionConfiguration(request))
  def deleteImageRecipe(request: DeleteImageRecipeRequest): ZIO[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.DeleteImageRecipeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteImageRecipe(request))
  def createContainerRecipe(request: CreateContainerRecipeRequest): ZIO[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.CreateContainerRecipeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createContainerRecipe(request))
  def deleteDistributionConfiguration(
      request: DeleteDistributionConfigurationRequest
  ): ZIO[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.DeleteDistributionConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteDistributionConfiguration(request))
  def importDiskImage(request: ImportDiskImageRequest): ZIO[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.ImportDiskImageResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.importDiskImage(request))
  def putContainerRecipePolicy(request: PutContainerRecipePolicyRequest): ZIO[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.PutContainerRecipePolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putContainerRecipePolicy(request))
  def createInfrastructureConfiguration(
      request: CreateInfrastructureConfigurationRequest
  ): ZIO[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.CreateInfrastructureConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createInfrastructureConfiguration(request))
  def listComponents(request: ListComponentsRequest): ZStream[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.ComponentVersion.ReadOnly
  ] = ZStream.serviceWithStream(_.listComponents(request))
  def listComponentsPaginated(request: ListComponentsRequest): ZIO[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.ListComponentsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listComponentsPaginated(request))
  def sendWorkflowStepAction(request: SendWorkflowStepActionRequest): ZIO[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.SendWorkflowStepActionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.sendWorkflowStepAction(request))
  def createImage(request: CreateImageRequest): ZIO[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.CreateImageResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createImage(request))
  def deleteLifecyclePolicy(request: DeleteLifecyclePolicyRequest): ZIO[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.DeleteLifecyclePolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteLifecyclePolicy(request))
  def deleteInfrastructureConfiguration(
      request: DeleteInfrastructureConfigurationRequest
  ): ZIO[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.DeleteInfrastructureConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteInfrastructureConfiguration(request))
  def untagResource(request: UntagResourceRequest): ZIO[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.UntagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagResource(request))
  def listLifecycleExecutions(request: ListLifecycleExecutionsRequest): ZStream[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.LifecycleExecution.ReadOnly
  ] = ZStream.serviceWithStream(_.listLifecycleExecutions(request))
  def listLifecycleExecutionsPaginated(
      request: ListLifecycleExecutionsRequest
  ): ZIO[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.ListLifecycleExecutionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listLifecycleExecutionsPaginated(request))
  def getLifecycleExecution(request: GetLifecycleExecutionRequest): ZIO[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.GetLifecycleExecutionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getLifecycleExecution(request))
  def deleteComponent(request: DeleteComponentRequest): ZIO[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.DeleteComponentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteComponent(request))
  def listImagePipelines(request: ListImagePipelinesRequest): ZStream[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.ImagePipeline.ReadOnly
  ] = ZStream.serviceWithStream(_.listImagePipelines(request))
  def listImagePipelinesPaginated(request: ListImagePipelinesRequest): ZIO[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.ListImagePipelinesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listImagePipelinesPaginated(request))
  def listDistributionConfigurations(
      request: ListDistributionConfigurationsRequest
  ): ZStream[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.DistributionConfigurationSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listDistributionConfigurations(request))
  def listDistributionConfigurationsPaginated(
      request: ListDistributionConfigurationsRequest
  ): ZIO[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.ListDistributionConfigurationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listDistributionConfigurationsPaginated(request))
  def getContainerRecipePolicy(request: GetContainerRecipePolicyRequest): ZIO[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.GetContainerRecipePolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getContainerRecipePolicy(request))
  def listWaitingWorkflowSteps(
      request: ListWaitingWorkflowStepsRequest
  ): ZStream[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.WorkflowStepExecution.ReadOnly
  ] = ZStream.serviceWithStream(_.listWaitingWorkflowSteps(request))
  def listWaitingWorkflowStepsPaginated(
      request: ListWaitingWorkflowStepsRequest
  ): ZIO[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.ListWaitingWorkflowStepsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listWaitingWorkflowStepsPaginated(request))
  def getWorkflow(request: GetWorkflowRequest): ZIO[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.GetWorkflowResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getWorkflow(request))
  def listImagePipelineImages(request: ListImagePipelineImagesRequest): ZStream[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.ImageSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listImagePipelineImages(request))
  def listImagePipelineImagesPaginated(
      request: ListImagePipelineImagesRequest
  ): ZIO[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.ListImagePipelineImagesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listImagePipelineImagesPaginated(request))
  def createDistributionConfiguration(
      request: CreateDistributionConfigurationRequest
  ): ZIO[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.CreateDistributionConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createDistributionConfiguration(request))
  def importComponent(request: ImportComponentRequest): ZIO[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.ImportComponentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.importComponent(request))
  def createComponent(request: CreateComponentRequest): ZIO[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.CreateComponentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createComponent(request))
  def getImagePipeline(request: GetImagePipelineRequest): ZIO[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.GetImagePipelineResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getImagePipeline(request))
  def listTagsForResource(request: ListTagsForResourceRequest): ZIO[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def tagResource(request: TagResourceRequest): ZIO[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.TagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.tagResource(request))
  def listWorkflowExecutions(request: ListWorkflowExecutionsRequest): ZStream[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.WorkflowExecutionMetadata.ReadOnly
  ] = ZStream.serviceWithStream(_.listWorkflowExecutions(request))
  def listWorkflowExecutionsPaginated(
      request: ListWorkflowExecutionsRequest
  ): ZIO[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.ListWorkflowExecutionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listWorkflowExecutionsPaginated(request))
  def createImagePipeline(request: CreateImagePipelineRequest): ZIO[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.CreateImagePipelineResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createImagePipeline(request))
  def listInfrastructureConfigurations(
      request: ListInfrastructureConfigurationsRequest
  ): ZStream[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.InfrastructureConfigurationSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listInfrastructureConfigurations(request))
  def listInfrastructureConfigurationsPaginated(
      request: ListInfrastructureConfigurationsRequest
  ): ZIO[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.ListInfrastructureConfigurationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listInfrastructureConfigurationsPaginated(request))
  def listWorkflowBuildVersions(
      request: ListWorkflowBuildVersionsRequest
  ): ZStream[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.WorkflowSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listWorkflowBuildVersions(request))
  def listWorkflowBuildVersionsPaginated(
      request: ListWorkflowBuildVersionsRequest
  ): ZIO[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.ListWorkflowBuildVersionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listWorkflowBuildVersionsPaginated(request))
  def listWorkflows(request: ListWorkflowsRequest): ZStream[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.WorkflowVersion.ReadOnly
  ] = ZStream.serviceWithStream(_.listWorkflows(request))
  def listWorkflowsPaginated(request: ListWorkflowsRequest): ZIO[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.ListWorkflowsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listWorkflowsPaginated(request))
  def getInfrastructureConfiguration(
      request: GetInfrastructureConfigurationRequest
  ): ZIO[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.GetInfrastructureConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getInfrastructureConfiguration(request))
  def deleteContainerRecipe(request: DeleteContainerRecipeRequest): ZIO[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.DeleteContainerRecipeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteContainerRecipe(request))
  def getImage(request: GetImageRequest): ZIO[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.GetImageResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getImage(request))
  def listLifecyclePolicies(request: ListLifecyclePoliciesRequest): ZStream[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.LifecyclePolicySummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listLifecyclePolicies(request))
  def listLifecyclePoliciesPaginated(
      request: ListLifecyclePoliciesRequest
  ): ZIO[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.ListLifecyclePoliciesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listLifecyclePoliciesPaginated(request))
  def createLifecyclePolicy(request: CreateLifecyclePolicyRequest): ZIO[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.CreateLifecyclePolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createLifecyclePolicy(request))
  def listContainerRecipes(request: ListContainerRecipesRequest): ZStream[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.ContainerRecipeSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listContainerRecipes(request))
  def listContainerRecipesPaginated(request: ListContainerRecipesRequest): ZIO[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.ListContainerRecipesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listContainerRecipesPaginated(request))
  def cancelLifecycleExecution(request: CancelLifecycleExecutionRequest): ZIO[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.CancelLifecycleExecutionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.cancelLifecycleExecution(request))
  def deleteImagePipeline(request: DeleteImagePipelineRequest): ZIO[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.DeleteImagePipelineResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteImagePipeline(request))
  def putImageRecipePolicy(request: PutImageRecipePolicyRequest): ZIO[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.PutImageRecipePolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putImageRecipePolicy(request))
  def updateImagePipeline(
      request: UpdateImagePipelineRequest
  ): ZIO[zio.aws.imagebuilder.Imagebuilder, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.updateImagePipeline(request))
  def deleteWorkflow(request: DeleteWorkflowRequest): ZIO[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.DeleteWorkflowResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteWorkflow(request))
  def getMarketplaceResource(request: GetMarketplaceResourceRequest): ZIO[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.GetMarketplaceResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getMarketplaceResource(request))
  def getImageRecipePolicy(request: GetImageRecipePolicyRequest): ZIO[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.GetImageRecipePolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getImageRecipePolicy(request))
  def listImageBuildVersions(request: ListImageBuildVersionsRequest): ZStream[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.ImageSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listImageBuildVersions(request))
  def listImageBuildVersionsPaginated(
      request: ListImageBuildVersionsRequest
  ): ZIO[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.ListImageBuildVersionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listImageBuildVersionsPaginated(request))
  def updateInfrastructureConfiguration(
      request: UpdateInfrastructureConfigurationRequest
  ): ZIO[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.UpdateInfrastructureConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateInfrastructureConfiguration(request))
  def getComponent(request: GetComponentRequest): ZIO[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.GetComponentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getComponent(request))
  def listLifecycleExecutionResources(
      request: ListLifecycleExecutionResourcesRequest
  ): ZStream[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.LifecycleExecutionResource.ReadOnly
  ] = ZStream.serviceWithStream(_.listLifecycleExecutionResources(request))
  def listLifecycleExecutionResourcesPaginated(
      request: ListLifecycleExecutionResourcesRequest
  ): ZIO[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.ListLifecycleExecutionResourcesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listLifecycleExecutionResourcesPaginated(request))
  def getWorkflowStepExecution(request: GetWorkflowStepExecutionRequest): ZIO[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.GetWorkflowStepExecutionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getWorkflowStepExecution(request))
  def getLifecyclePolicy(request: GetLifecyclePolicyRequest): ZIO[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.GetLifecyclePolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getLifecyclePolicy(request))
  def createWorkflow(request: CreateWorkflowRequest): ZIO[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.CreateWorkflowResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createWorkflow(request))
  def updateLifecyclePolicy(request: UpdateLifecyclePolicyRequest): ZIO[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.UpdateLifecyclePolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateLifecyclePolicy(request))
  def importVmImage(request: ImportVmImageRequest): ZIO[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.ImportVmImageResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.importVmImage(request))
  def cancelImageCreation(request: CancelImageCreationRequest): ZIO[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.CancelImageCreationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.cancelImageCreation(request))
  def getImagePolicy(request: GetImagePolicyRequest): ZIO[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.GetImagePolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getImagePolicy(request))
}
