package zio.aws.imagebuilder
import zio.prelude.Subtype
import zio.aws.imagebuilder.model.primitives.{
  OrganizationArn,
  AccountId,
  TagValue,
  InstanceType,
  WorkflowParameterValue,
  ComponentParameterValue,
  VulnerabilityId,
  OrganizationalUnitArn,
  OsVersion,
  FilterValue,
  NonEmptyString,
  LicenseConfigurationArn,
  TagKey
}
import java.time.Instant
import zio.aws.imagebuilder.model.primitives.LifecyclePolicyDetailFilterRetainAtLeast.Type
package object model {
  import scala.jdk.CollectionConverters.*
  object primitives {
    object AccountId extends zio.prelude.Subtype[String]
    type AccountId = zio.aws.imagebuilder.model.primitives.AccountId.Type
    object AmiNameString extends zio.prelude.Subtype[String]
    type AmiNameString =
      zio.aws.imagebuilder.model.primitives.AmiNameString.Type
    object Arn extends zio.prelude.Subtype[String]
    type Arn = zio.aws.imagebuilder.model.primitives.Arn.Type
    object ClientToken extends zio.prelude.Subtype[String]
    type ClientToken = zio.aws.imagebuilder.model.primitives.ClientToken.Type
    object ComponentBuildVersionArn extends zio.prelude.Subtype[String]
    type ComponentBuildVersionArn =
      zio.aws.imagebuilder.model.primitives.ComponentBuildVersionArn.Type
    object ComponentData extends zio.prelude.Subtype[String]
    type ComponentData =
      zio.aws.imagebuilder.model.primitives.ComponentData.Type
    object ComponentParameterDescription extends zio.prelude.Subtype[String]
    type ComponentParameterDescription =
      zio.aws.imagebuilder.model.primitives.ComponentParameterDescription.Type
    object ComponentParameterName extends zio.prelude.Subtype[String]
    type ComponentParameterName =
      zio.aws.imagebuilder.model.primitives.ComponentParameterName.Type
    object ComponentParameterType extends zio.prelude.Subtype[String]
    type ComponentParameterType =
      zio.aws.imagebuilder.model.primitives.ComponentParameterType.Type
    object ComponentParameterValue extends zio.prelude.Subtype[String]
    type ComponentParameterValue =
      zio.aws.imagebuilder.model.primitives.ComponentParameterValue.Type
    object ComponentVersionArn extends zio.prelude.Subtype[String]
    type ComponentVersionArn =
      zio.aws.imagebuilder.model.primitives.ComponentVersionArn.Type
    object ComponentVersionArnOrBuildVersionArn
        extends zio.prelude.Subtype[String]
    type ComponentVersionArnOrBuildVersionArn =
      zio.aws.imagebuilder.model.primitives.ComponentVersionArnOrBuildVersionArn.Type
    object ContainerRecipeArn extends zio.prelude.Subtype[String]
    type ContainerRecipeArn =
      zio.aws.imagebuilder.model.primitives.ContainerRecipeArn.Type
    object DateTime extends zio.prelude.Subtype[String]
    type DateTime = zio.aws.imagebuilder.model.primitives.DateTime.Type
    object DateTimeTimestamp extends zio.prelude.Subtype[Instant]
    type DateTimeTimestamp =
      zio.aws.imagebuilder.model.primitives.DateTimeTimestamp.Type
    object DistributionConfigurationArn extends zio.prelude.Subtype[String]
    type DistributionConfigurationArn =
      zio.aws.imagebuilder.model.primitives.DistributionConfigurationArn.Type
    object DistributionTimeoutMinutes extends zio.prelude.Subtype[Int]
    type DistributionTimeoutMinutes =
      zio.aws.imagebuilder.model.primitives.DistributionTimeoutMinutes.Type
    object DockerFileTemplate extends zio.prelude.Subtype[String]
    type DockerFileTemplate =
      zio.aws.imagebuilder.model.primitives.DockerFileTemplate.Type
    object EbsIopsInteger extends zio.prelude.Subtype[Int]
    type EbsIopsInteger =
      zio.aws.imagebuilder.model.primitives.EbsIopsInteger.Type
    object EbsVolumeSizeInteger extends zio.prelude.Subtype[Int]
    type EbsVolumeSizeInteger =
      zio.aws.imagebuilder.model.primitives.EbsVolumeSizeInteger.Type
    object EbsVolumeThroughput extends zio.prelude.Subtype[Int]
    type EbsVolumeThroughput =
      zio.aws.imagebuilder.model.primitives.EbsVolumeThroughput.Type
    object EmptyString extends zio.prelude.Subtype[String]
    type EmptyString = zio.aws.imagebuilder.model.primitives.EmptyString.Type
    object FilterName extends zio.prelude.Subtype[String]
    type FilterName = zio.aws.imagebuilder.model.primitives.FilterName.Type
    object FilterValue extends zio.prelude.Subtype[String]
    type FilterValue = zio.aws.imagebuilder.model.primitives.FilterValue.Type
    object HttpPutResponseHopLimit extends zio.prelude.Subtype[Int]
    type HttpPutResponseHopLimit =
      zio.aws.imagebuilder.model.primitives.HttpPutResponseHopLimit.Type
    object HttpTokens extends zio.prelude.Subtype[String]
    type HttpTokens = zio.aws.imagebuilder.model.primitives.HttpTokens.Type
    object ImageBuildMessage extends zio.prelude.Subtype[String]
    type ImageBuildMessage =
      zio.aws.imagebuilder.model.primitives.ImageBuildMessage.Type
    object ImageBuildVersionArn extends zio.prelude.Subtype[String]
    type ImageBuildVersionArn =
      zio.aws.imagebuilder.model.primitives.ImageBuildVersionArn.Type
    object ImageBuilderArn extends zio.prelude.Subtype[String]
    type ImageBuilderArn =
      zio.aws.imagebuilder.model.primitives.ImageBuilderArn.Type
    object ImagePipelineArn extends zio.prelude.Subtype[String]
    type ImagePipelineArn =
      zio.aws.imagebuilder.model.primitives.ImagePipelineArn.Type
    object ImageRecipeArn extends zio.prelude.Subtype[String]
    type ImageRecipeArn =
      zio.aws.imagebuilder.model.primitives.ImageRecipeArn.Type
    object ImageTestsTimeoutMinutes extends zio.prelude.Subtype[Int]
    type ImageTestsTimeoutMinutes =
      zio.aws.imagebuilder.model.primitives.ImageTestsTimeoutMinutes.Type
    object ImageVersionArn extends zio.prelude.Subtype[String]
    type ImageVersionArn =
      zio.aws.imagebuilder.model.primitives.ImageVersionArn.Type
    object ImageVersionArnOrBuildVersionArn extends zio.prelude.Subtype[String]
    type ImageVersionArnOrBuildVersionArn =
      zio.aws.imagebuilder.model.primitives.ImageVersionArnOrBuildVersionArn.Type
    object InfrastructureConfigurationArn extends zio.prelude.Subtype[String]
    type InfrastructureConfigurationArn =
      zio.aws.imagebuilder.model.primitives.InfrastructureConfigurationArn.Type
    object InlineComponentData extends zio.prelude.Subtype[String]
    type InlineComponentData =
      zio.aws.imagebuilder.model.primitives.InlineComponentData.Type
    object InlineDockerFileTemplate extends zio.prelude.Subtype[String]
    type InlineDockerFileTemplate =
      zio.aws.imagebuilder.model.primitives.InlineDockerFileTemplate.Type
    object InlineWorkflowData extends zio.prelude.Subtype[String]
    type InlineWorkflowData =
      zio.aws.imagebuilder.model.primitives.InlineWorkflowData.Type
    object InstanceProfileNameType extends zio.prelude.Subtype[String]
    type InstanceProfileNameType =
      zio.aws.imagebuilder.model.primitives.InstanceProfileNameType.Type
    object InstanceType extends zio.prelude.Subtype[String]
    type InstanceType = zio.aws.imagebuilder.model.primitives.InstanceType.Type
    object LaunchTemplateId extends zio.prelude.Subtype[String]
    type LaunchTemplateId =
      zio.aws.imagebuilder.model.primitives.LaunchTemplateId.Type
    object LicenseConfigurationArn extends zio.prelude.Subtype[String]
    type LicenseConfigurationArn =
      zio.aws.imagebuilder.model.primitives.LicenseConfigurationArn.Type
    object LifecycleExecutionId extends zio.prelude.Subtype[String]
    type LifecycleExecutionId =
      zio.aws.imagebuilder.model.primitives.LifecycleExecutionId.Type
    object LifecyclePolicyArn extends zio.prelude.Subtype[String]
    type LifecyclePolicyArn =
      zio.aws.imagebuilder.model.primitives.LifecyclePolicyArn.Type
    object LifecyclePolicyDetailExclusionRulesAmisLastLaunchedValue
        extends zio.prelude.Subtype[Int]
    type LifecyclePolicyDetailExclusionRulesAmisLastLaunchedValue =
      zio.aws.imagebuilder.model.primitives.LifecyclePolicyDetailExclusionRulesAmisLastLaunchedValue.Type
    object LifecyclePolicyDetailFilterRetainAtLeast
        extends zio.prelude.Subtype[Int]
    type LifecyclePolicyDetailFilterRetainAtLeast =
      zio.aws.imagebuilder.model.primitives.LifecyclePolicyDetailFilterRetainAtLeast.Type
    object LifecyclePolicyDetailFilterValue extends zio.prelude.Subtype[Int]
    type LifecyclePolicyDetailFilterValue =
      zio.aws.imagebuilder.model.primitives.LifecyclePolicyDetailFilterValue.Type
    object MarketplaceResourceLocation extends zio.prelude.Subtype[String]
    type MarketplaceResourceLocation =
      zio.aws.imagebuilder.model.primitives.MarketplaceResourceLocation.Type
    object MaxParallelLaunches extends zio.prelude.Subtype[Int]
    type MaxParallelLaunches =
      zio.aws.imagebuilder.model.primitives.MaxParallelLaunches.Type
    object NonEmptyString extends zio.prelude.Subtype[String]
    type NonEmptyString =
      zio.aws.imagebuilder.model.primitives.NonEmptyString.Type
    object NonNegativeDouble extends zio.prelude.Subtype[Double]
    type NonNegativeDouble =
      zio.aws.imagebuilder.model.primitives.NonNegativeDouble.Type
    type NullableBoolean = Boolean
    object OrganizationArn extends zio.prelude.Subtype[String]
    type OrganizationArn =
      zio.aws.imagebuilder.model.primitives.OrganizationArn.Type
    object OrganizationalUnitArn extends zio.prelude.Subtype[String]
    type OrganizationalUnitArn =
      zio.aws.imagebuilder.model.primitives.OrganizationalUnitArn.Type
    object OsVersion extends zio.prelude.Subtype[String]
    type OsVersion = zio.aws.imagebuilder.model.primitives.OsVersion.Type
    object PackageArchitecture extends zio.prelude.Subtype[String]
    type PackageArchitecture =
      zio.aws.imagebuilder.model.primitives.PackageArchitecture.Type
    object PackageEpoch extends zio.prelude.Subtype[Int]
    type PackageEpoch = zio.aws.imagebuilder.model.primitives.PackageEpoch.Type
    object PaginationToken extends zio.prelude.Subtype[String]
    type PaginationToken =
      zio.aws.imagebuilder.model.primitives.PaginationToken.Type
    object ParallelGroup extends zio.prelude.Subtype[String]
    type ParallelGroup =
      zio.aws.imagebuilder.model.primitives.ParallelGroup.Type
    object ProductCodeId extends zio.prelude.Subtype[String]
    type ProductCodeId =
      zio.aws.imagebuilder.model.primitives.ProductCodeId.Type
    object ResourceName extends zio.prelude.Subtype[String]
    type ResourceName = zio.aws.imagebuilder.model.primitives.ResourceName.Type
    object ResourcePolicyDocument extends zio.prelude.Subtype[String]
    type ResourcePolicyDocument =
      zio.aws.imagebuilder.model.primitives.ResourcePolicyDocument.Type
    object RestrictedInteger extends zio.prelude.Subtype[Int]
    type RestrictedInteger =
      zio.aws.imagebuilder.model.primitives.RestrictedInteger.Type
    object RoleNameOrArn extends zio.prelude.Subtype[String]
    type RoleNameOrArn =
      zio.aws.imagebuilder.model.primitives.RoleNameOrArn.Type
    object SeverityCountNumber extends zio.prelude.Subtype[Long]
    type SeverityCountNumber =
      zio.aws.imagebuilder.model.primitives.SeverityCountNumber.Type
    object SnsTopicArn extends zio.prelude.Subtype[String]
    type SnsTopicArn = zio.aws.imagebuilder.model.primitives.SnsTopicArn.Type
    object SourceLayerHash extends zio.prelude.Subtype[String]
    type SourceLayerHash =
      zio.aws.imagebuilder.model.primitives.SourceLayerHash.Type
    object TagKey extends zio.prelude.Subtype[String]
    type TagKey = zio.aws.imagebuilder.model.primitives.TagKey.Type
    object TagValue extends zio.prelude.Subtype[String]
    type TagValue = zio.aws.imagebuilder.model.primitives.TagValue.Type
    object TargetResourceCount extends zio.prelude.Subtype[Int]
    type TargetResourceCount =
      zio.aws.imagebuilder.model.primitives.TargetResourceCount.Type
    object Timezone extends zio.prelude.Subtype[String]
    type Timezone = zio.aws.imagebuilder.model.primitives.Timezone.Type
    object Uri extends zio.prelude.Subtype[String]
    type Uri = zio.aws.imagebuilder.model.primitives.Uri.Type
    object UserDataOverride extends zio.prelude.Subtype[String]
    type UserDataOverride =
      zio.aws.imagebuilder.model.primitives.UserDataOverride.Type
    object VersionNumber extends zio.prelude.Subtype[String]
    type VersionNumber =
      zio.aws.imagebuilder.model.primitives.VersionNumber.Type
    object VulnerabilityId extends zio.prelude.Subtype[String]
    type VulnerabilityId =
      zio.aws.imagebuilder.model.primitives.VulnerabilityId.Type
    object WorkflowBuildVersionArn extends zio.prelude.Subtype[String]
    type WorkflowBuildVersionArn =
      zio.aws.imagebuilder.model.primitives.WorkflowBuildVersionArn.Type
    object WorkflowData extends zio.prelude.Subtype[String]
    type WorkflowData = zio.aws.imagebuilder.model.primitives.WorkflowData.Type
    object WorkflowExecutionId extends zio.prelude.Subtype[String]
    type WorkflowExecutionId =
      zio.aws.imagebuilder.model.primitives.WorkflowExecutionId.Type
    object WorkflowExecutionMessage extends zio.prelude.Subtype[String]
    type WorkflowExecutionMessage =
      zio.aws.imagebuilder.model.primitives.WorkflowExecutionMessage.Type
    object WorkflowNameArn extends zio.prelude.Subtype[String]
    type WorkflowNameArn =
      zio.aws.imagebuilder.model.primitives.WorkflowNameArn.Type
    object WorkflowParameterDescription extends zio.prelude.Subtype[String]
    type WorkflowParameterDescription =
      zio.aws.imagebuilder.model.primitives.WorkflowParameterDescription.Type
    object WorkflowParameterName extends zio.prelude.Subtype[String]
    type WorkflowParameterName =
      zio.aws.imagebuilder.model.primitives.WorkflowParameterName.Type
    object WorkflowParameterType extends zio.prelude.Subtype[String]
    type WorkflowParameterType =
      zio.aws.imagebuilder.model.primitives.WorkflowParameterType.Type
    object WorkflowParameterValue extends zio.prelude.Subtype[String]
    type WorkflowParameterValue =
      zio.aws.imagebuilder.model.primitives.WorkflowParameterValue.Type
    object WorkflowStepAction extends zio.prelude.Subtype[String]
    type WorkflowStepAction =
      zio.aws.imagebuilder.model.primitives.WorkflowStepAction.Type
    object WorkflowStepCount extends zio.prelude.Subtype[Int]
    type WorkflowStepCount =
      zio.aws.imagebuilder.model.primitives.WorkflowStepCount.Type
    object WorkflowStepDescription extends zio.prelude.Subtype[String]
    type WorkflowStepDescription =
      zio.aws.imagebuilder.model.primitives.WorkflowStepDescription.Type
    object WorkflowStepExecutionId extends zio.prelude.Subtype[String]
    type WorkflowStepExecutionId =
      zio.aws.imagebuilder.model.primitives.WorkflowStepExecutionId.Type
    object WorkflowStepInputs extends zio.prelude.Subtype[String]
    type WorkflowStepInputs =
      zio.aws.imagebuilder.model.primitives.WorkflowStepInputs.Type
    object WorkflowStepMessage extends zio.prelude.Subtype[String]
    type WorkflowStepMessage =
      zio.aws.imagebuilder.model.primitives.WorkflowStepMessage.Type
    object WorkflowStepName extends zio.prelude.Subtype[String]
    type WorkflowStepName =
      zio.aws.imagebuilder.model.primitives.WorkflowStepName.Type
    object WorkflowStepOutputs extends zio.prelude.Subtype[String]
    type WorkflowStepOutputs =
      zio.aws.imagebuilder.model.primitives.WorkflowStepOutputs.Type
    object WorkflowStepTimeoutSecondsInteger extends zio.prelude.Subtype[Int]
    type WorkflowStepTimeoutSecondsInteger =
      zio.aws.imagebuilder.model.primitives.WorkflowStepTimeoutSecondsInteger.Type
    object WorkflowVersionArn extends zio.prelude.Subtype[String]
    type WorkflowVersionArn =
      zio.aws.imagebuilder.model.primitives.WorkflowVersionArn.Type
    object WorkflowVersionArnOrBuildVersionArn
        extends zio.prelude.Subtype[String]
    type WorkflowVersionArnOrBuildVersionArn =
      zio.aws.imagebuilder.model.primitives.WorkflowVersionArnOrBuildVersionArn.Type
    object WorkflowWildcardVersionArn extends zio.prelude.Subtype[String]
    type WorkflowWildcardVersionArn =
      zio.aws.imagebuilder.model.primitives.WorkflowWildcardVersionArn.Type
  }
  type AccountList = List[AccountId]
  type AmiList = List[zio.aws.imagebuilder.model.Ami]
  type ComponentConfigurationList =
    List[zio.aws.imagebuilder.model.ComponentConfiguration]
  type ComponentParameterDetailList =
    List[zio.aws.imagebuilder.model.ComponentParameterDetail]
  type ComponentParameterList =
    List[zio.aws.imagebuilder.model.ComponentParameter]
  type ComponentParameterValueList = List[ComponentParameterValue]
  type ComponentSummaryList = List[zio.aws.imagebuilder.model.ComponentSummary]
  type ComponentVersionList = List[zio.aws.imagebuilder.model.ComponentVersion]
  type ContainerList = List[zio.aws.imagebuilder.model.Container]
  type ContainerRecipeSummaryList =
    List[zio.aws.imagebuilder.model.ContainerRecipeSummary]
  type CvssScoreAdjustmentList =
    List[zio.aws.imagebuilder.model.CvssScoreAdjustment]
  type CvssScoreList = List[zio.aws.imagebuilder.model.CvssScore]
  type DistributionConfigurationSummaryList =
    List[zio.aws.imagebuilder.model.DistributionConfigurationSummary]
  type DistributionList = List[zio.aws.imagebuilder.model.Distribution]
  type FastLaunchConfigurationList =
    List[zio.aws.imagebuilder.model.FastLaunchConfiguration]
  type FilterList = List[zio.aws.imagebuilder.model.Filter]
  type FilterValues = List[FilterValue]
  type ImagePackageList = List[zio.aws.imagebuilder.model.ImagePackage]
  type ImagePipelineList = List[zio.aws.imagebuilder.model.ImagePipeline]
  type ImageRecipeSummaryList =
    List[zio.aws.imagebuilder.model.ImageRecipeSummary]
  type ImageScanFindingAggregationsList =
    List[zio.aws.imagebuilder.model.ImageScanFindingAggregation]
  type ImageScanFindingsFilterList =
    List[zio.aws.imagebuilder.model.ImageScanFindingsFilter]
  type ImageScanFindingsFilterValues = List[FilterValue]
  type ImageScanFindingsList = List[zio.aws.imagebuilder.model.ImageScanFinding]
  type ImageSummaryList = List[zio.aws.imagebuilder.model.ImageSummary]
  type ImageVersionList = List[zio.aws.imagebuilder.model.ImageVersion]
  type InfrastructureConfigurationSummaryList =
    List[zio.aws.imagebuilder.model.InfrastructureConfigurationSummary]
  type InstanceBlockDeviceMappings =
    List[zio.aws.imagebuilder.model.InstanceBlockDeviceMapping]
  type InstanceTypeList = List[InstanceType]
  type LaunchTemplateConfigurationList =
    List[zio.aws.imagebuilder.model.LaunchTemplateConfiguration]
  type LicenseConfigurationArnList = List[LicenseConfigurationArn]
  type LifecycleExecutionResourceList =
    List[zio.aws.imagebuilder.model.LifecycleExecutionResource]
  type LifecycleExecutionSnapshotResourceList =
    List[zio.aws.imagebuilder.model.LifecycleExecutionSnapshotResource]
  type LifecycleExecutionsList =
    List[zio.aws.imagebuilder.model.LifecycleExecution]
  type LifecyclePolicyDetails =
    List[zio.aws.imagebuilder.model.LifecyclePolicyDetail]
  type LifecyclePolicyResourceSelectionRecipes =
    List[zio.aws.imagebuilder.model.LifecyclePolicyResourceSelectionRecipe]
  type LifecyclePolicySummaryList =
    List[zio.aws.imagebuilder.model.LifecyclePolicySummary]
  type NonEmptyStringList = List[NonEmptyString]
  type OrganizationArnList = List[OrganizationArn]
  type OrganizationalUnitArnList = List[OrganizationalUnitArn]
  type OsVersionList = List[OsVersion]
  type ProductCodeList = List[zio.aws.imagebuilder.model.ProductCodeListItem]
  type RegionList = List[NonEmptyString]
  type ResourceTagMap = Map[TagKey, TagValue]
  type SecurityGroupIds = List[NonEmptyString]
  type StringList = List[NonEmptyString]
  type TagKeyList = List[TagKey]
  type TagMap = Map[TagKey, TagValue]
  type VulnerabilityIdList = List[VulnerabilityId]
  type VulnerablePackageList =
    List[zio.aws.imagebuilder.model.VulnerablePackage]
  type WorkflowConfigurationList =
    List[zio.aws.imagebuilder.model.WorkflowConfiguration]
  type WorkflowExecutionsList =
    List[zio.aws.imagebuilder.model.WorkflowExecutionMetadata]
  type WorkflowParameterDetailList =
    List[zio.aws.imagebuilder.model.WorkflowParameterDetail]
  type WorkflowParameterList =
    List[zio.aws.imagebuilder.model.WorkflowParameter]
  type WorkflowParameterValueList = List[WorkflowParameterValue]
  type WorkflowStepExecutionList =
    List[zio.aws.imagebuilder.model.WorkflowStepExecution]
  type WorkflowStepExecutionsList =
    List[zio.aws.imagebuilder.model.WorkflowStepMetadata]
  type WorkflowSummaryList = List[zio.aws.imagebuilder.model.WorkflowSummary]
  type WorkflowVersionList = List[zio.aws.imagebuilder.model.WorkflowVersion]
}
