package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.{
  DateTime,
  VersionNumber,
  WorkflowVersionArn,
  NonEmptyString,
  ResourceName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class WorkflowVersion(
    arn: Optional[WorkflowVersionArn] = Optional.Absent,
    name: Optional[ResourceName] = Optional.Absent,
    version: Optional[VersionNumber] = Optional.Absent,
    description: Optional[NonEmptyString] = Optional.Absent,
    `type`: Optional[zio.aws.imagebuilder.model.WorkflowType] = Optional.Absent,
    owner: Optional[NonEmptyString] = Optional.Absent,
    dateCreated: Optional[DateTime] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.WorkflowVersion = {
    import WorkflowVersion.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.WorkflowVersion
      .builder()
      .optionallyWith(
        arn.map(value => WorkflowVersionArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        name.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        version.map(value => VersionNumber.unwrap(value): java.lang.String)
      )(_.version)
      .optionallyWith(
        description.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        owner.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.owner)
      .optionallyWith(
        dateCreated.map(value => DateTime.unwrap(value): java.lang.String)
      )(_.dateCreated)
      .build()
  }
  def asReadOnly: zio.aws.imagebuilder.model.WorkflowVersion.ReadOnly =
    zio.aws.imagebuilder.model.WorkflowVersion.wrap(buildAwsValue())
}
object WorkflowVersion {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.WorkflowVersion
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.WorkflowVersion =
      zio.aws.imagebuilder.model.WorkflowVersion(
        arn.map(value => value),
        name.map(value => value),
        version.map(value => value),
        description.map(value => value),
        `type`.map(value => value),
        owner.map(value => value),
        dateCreated.map(value => value)
      )
    def arn: Optional[WorkflowVersionArn]
    def name: Optional[ResourceName]
    def version: Optional[VersionNumber]
    def description: Optional[NonEmptyString]
    def `type`: Optional[zio.aws.imagebuilder.model.WorkflowType]
    def owner: Optional[NonEmptyString]
    def dateCreated: Optional[DateTime]
    def getArn: ZIO[Any, AwsError, WorkflowVersionArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("name", name)
    def getVersion: ZIO[Any, AwsError, VersionNumber] =
      AwsError.unwrapOptionField("version", version)
    def getDescription: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("description", description)
    def getType: ZIO[Any, AwsError, zio.aws.imagebuilder.model.WorkflowType] =
      AwsError.unwrapOptionField("type", `type`)
    def getOwner: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("owner", owner)
    def getDateCreated: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("dateCreated", dateCreated)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.WorkflowVersion
  ) extends zio.aws.imagebuilder.model.WorkflowVersion.ReadOnly {
    override val arn: Optional[WorkflowVersionArn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value =>
        zio.aws.imagebuilder.model.primitives.WorkflowVersionArn(value)
      )
    override val name: Optional[ResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.imagebuilder.model.primitives.ResourceName(value))
    override val version: Optional[VersionNumber] = zio.aws.core.internal
      .optionalFromNullable(impl.version())
      .map(value => zio.aws.imagebuilder.model.primitives.VersionNumber(value))
    override val description: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val `type`: Optional[zio.aws.imagebuilder.model.WorkflowType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.imagebuilder.model.WorkflowType.wrap(value))
    override val owner: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.owner())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val dateCreated: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.dateCreated())
      .map(value => zio.aws.imagebuilder.model.primitives.DateTime(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.WorkflowVersion
  ): zio.aws.imagebuilder.model.WorkflowVersion.ReadOnly = new Wrapper(impl)
}
