package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.{
  WorkflowExecutionId,
  DateTime,
  ImageBuildVersionArn,
  WorkflowStepExecutionId,
  WorkflowStepAction,
  WorkflowBuildVersionArn,
  WorkflowStepName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class WorkflowStepExecution(
    stepExecutionId: Optional[WorkflowStepExecutionId] = Optional.Absent,
    imageBuildVersionArn: Optional[ImageBuildVersionArn] = Optional.Absent,
    workflowExecutionId: Optional[WorkflowExecutionId] = Optional.Absent,
    workflowBuildVersionArn: Optional[WorkflowBuildVersionArn] =
      Optional.Absent,
    name: Optional[WorkflowStepName] = Optional.Absent,
    action: Optional[WorkflowStepAction] = Optional.Absent,
    startTime: Optional[DateTime] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.WorkflowStepExecution = {
    import WorkflowStepExecution.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.WorkflowStepExecution
      .builder()
      .optionallyWith(
        stepExecutionId.map(value =>
          WorkflowStepExecutionId.unwrap(value): java.lang.String
        )
      )(_.stepExecutionId)
      .optionallyWith(
        imageBuildVersionArn.map(value =>
          ImageBuildVersionArn.unwrap(value): java.lang.String
        )
      )(_.imageBuildVersionArn)
      .optionallyWith(
        workflowExecutionId.map(value =>
          WorkflowExecutionId.unwrap(value): java.lang.String
        )
      )(_.workflowExecutionId)
      .optionallyWith(
        workflowBuildVersionArn.map(value =>
          WorkflowBuildVersionArn.unwrap(value): java.lang.String
        )
      )(_.workflowBuildVersionArn)
      .optionallyWith(
        name.map(value => WorkflowStepName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        action.map(value => WorkflowStepAction.unwrap(value): java.lang.String)
      )(_.action)
      .optionallyWith(
        startTime.map(value => DateTime.unwrap(value): java.lang.String)
      )(_.startTime)
      .build()
  }
  def asReadOnly: zio.aws.imagebuilder.model.WorkflowStepExecution.ReadOnly =
    zio.aws.imagebuilder.model.WorkflowStepExecution.wrap(buildAwsValue())
}
object WorkflowStepExecution {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.WorkflowStepExecution
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.WorkflowStepExecution =
      zio.aws.imagebuilder.model.WorkflowStepExecution(
        stepExecutionId.map(value => value),
        imageBuildVersionArn.map(value => value),
        workflowExecutionId.map(value => value),
        workflowBuildVersionArn.map(value => value),
        name.map(value => value),
        action.map(value => value),
        startTime.map(value => value)
      )
    def stepExecutionId: Optional[WorkflowStepExecutionId]
    def imageBuildVersionArn: Optional[ImageBuildVersionArn]
    def workflowExecutionId: Optional[WorkflowExecutionId]
    def workflowBuildVersionArn: Optional[WorkflowBuildVersionArn]
    def name: Optional[WorkflowStepName]
    def action: Optional[WorkflowStepAction]
    def startTime: Optional[DateTime]
    def getStepExecutionId: ZIO[Any, AwsError, WorkflowStepExecutionId] =
      AwsError.unwrapOptionField("stepExecutionId", stepExecutionId)
    def getImageBuildVersionArn: ZIO[Any, AwsError, ImageBuildVersionArn] =
      AwsError.unwrapOptionField("imageBuildVersionArn", imageBuildVersionArn)
    def getWorkflowExecutionId: ZIO[Any, AwsError, WorkflowExecutionId] =
      AwsError.unwrapOptionField("workflowExecutionId", workflowExecutionId)
    def getWorkflowBuildVersionArn
        : ZIO[Any, AwsError, WorkflowBuildVersionArn] = AwsError
      .unwrapOptionField("workflowBuildVersionArn", workflowBuildVersionArn)
    def getName: ZIO[Any, AwsError, WorkflowStepName] =
      AwsError.unwrapOptionField("name", name)
    def getAction: ZIO[Any, AwsError, WorkflowStepAction] =
      AwsError.unwrapOptionField("action", action)
    def getStartTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("startTime", startTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.WorkflowStepExecution
  ) extends zio.aws.imagebuilder.model.WorkflowStepExecution.ReadOnly {
    override val stepExecutionId: Optional[WorkflowStepExecutionId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stepExecutionId())
        .map(value =>
          zio.aws.imagebuilder.model.primitives.WorkflowStepExecutionId(value)
        )
    override val imageBuildVersionArn: Optional[ImageBuildVersionArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.imageBuildVersionArn())
        .map(value =>
          zio.aws.imagebuilder.model.primitives.ImageBuildVersionArn(value)
        )
    override val workflowExecutionId: Optional[WorkflowExecutionId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.workflowExecutionId())
        .map(value =>
          zio.aws.imagebuilder.model.primitives.WorkflowExecutionId(value)
        )
    override val workflowBuildVersionArn: Optional[WorkflowBuildVersionArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.workflowBuildVersionArn())
        .map(value =>
          zio.aws.imagebuilder.model.primitives.WorkflowBuildVersionArn(value)
        )
    override val name: Optional[WorkflowStepName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value =>
        zio.aws.imagebuilder.model.primitives.WorkflowStepName(value)
      )
    override val action: Optional[WorkflowStepAction] = zio.aws.core.internal
      .optionalFromNullable(impl.action())
      .map(value =>
        zio.aws.imagebuilder.model.primitives.WorkflowStepAction(value)
      )
    override val startTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.startTime())
      .map(value => zio.aws.imagebuilder.model.primitives.DateTime(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.WorkflowStepExecution
  ): zio.aws.imagebuilder.model.WorkflowStepExecution.ReadOnly = new Wrapper(
    impl
  )
}
