package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.NonEmptyString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class WorkflowState(
    status: Optional[zio.aws.imagebuilder.model.WorkflowStatus] =
      Optional.Absent,
    reason: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.WorkflowState = {
    import WorkflowState.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.WorkflowState
      .builder()
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        reason.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.reason)
      .build()
  }
  def asReadOnly: zio.aws.imagebuilder.model.WorkflowState.ReadOnly =
    zio.aws.imagebuilder.model.WorkflowState.wrap(buildAwsValue())
}
object WorkflowState {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.WorkflowState
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.WorkflowState =
      zio.aws.imagebuilder.model
        .WorkflowState(status.map(value => value), reason.map(value => value))
    def status: Optional[zio.aws.imagebuilder.model.WorkflowStatus]
    def reason: Optional[NonEmptyString]
    def getStatus
        : ZIO[Any, AwsError, zio.aws.imagebuilder.model.WorkflowStatus] =
      AwsError.unwrapOptionField("status", status)
    def getReason: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("reason", reason)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.WorkflowState
  ) extends zio.aws.imagebuilder.model.WorkflowState.ReadOnly {
    override val status: Optional[zio.aws.imagebuilder.model.WorkflowStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.imagebuilder.model.WorkflowStatus.wrap(value))
    override val reason: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.reason())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.WorkflowState
  ): zio.aws.imagebuilder.model.WorkflowState.ReadOnly = new Wrapper(impl)
}
