package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.{
  WorkflowParameterValue,
  WorkflowParameterName
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class WorkflowParameter(
    name: WorkflowParameterName,
    value: Iterable[WorkflowParameterValue]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.WorkflowParameter = {
    import WorkflowParameter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.WorkflowParameter
      .builder()
      .name(WorkflowParameterName.unwrap(name): java.lang.String)
      .value(value.map { item =>
        WorkflowParameterValue.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.imagebuilder.model.WorkflowParameter.ReadOnly =
    zio.aws.imagebuilder.model.WorkflowParameter.wrap(buildAwsValue())
}
object WorkflowParameter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.WorkflowParameter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.WorkflowParameter =
      zio.aws.imagebuilder.model.WorkflowParameter(name, value)
    def name: WorkflowParameterName
    def value: List[WorkflowParameterValue]
    def getName: ZIO[Any, Nothing, WorkflowParameterName] = ZIO.succeed(name)
    def getValue: ZIO[Any, Nothing, List[WorkflowParameterValue]] =
      ZIO.succeed(value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.WorkflowParameter
  ) extends zio.aws.imagebuilder.model.WorkflowParameter.ReadOnly {
    override val name: WorkflowParameterName =
      zio.aws.imagebuilder.model.primitives.WorkflowParameterName(impl.name())
    override val value: List[WorkflowParameterValue] = impl
      .value()
      .asScala
      .map { item =>
        zio.aws.imagebuilder.model.primitives.WorkflowParameterValue(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.WorkflowParameter
  ): zio.aws.imagebuilder.model.WorkflowParameter.ReadOnly = new Wrapper(impl)
}
