package zio.aws.imagebuilder.model
import scala.jdk.CollectionConverters.*
sealed trait WorkflowExecutionStatus {
  def unwrap: software.amazon.awssdk.services.imagebuilder.model.WorkflowExecutionStatus
}
object WorkflowExecutionStatus {
  def wrap(
      value: software.amazon.awssdk.services.imagebuilder.model.WorkflowExecutionStatus
  ): zio.aws.imagebuilder.model.WorkflowExecutionStatus = value match {
    case software.amazon.awssdk.services.imagebuilder.model.WorkflowExecutionStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.imagebuilder.model.WorkflowExecutionStatus.PENDING =>
      val r = PENDING
      r
    case software.amazon.awssdk.services.imagebuilder.model.WorkflowExecutionStatus.SKIPPED =>
      val r = SKIPPED
      r
    case software.amazon.awssdk.services.imagebuilder.model.WorkflowExecutionStatus.RUNNING =>
      val r = RUNNING
      r
    case software.amazon.awssdk.services.imagebuilder.model.WorkflowExecutionStatus.COMPLETED =>
      val r = COMPLETED
      r
    case software.amazon.awssdk.services.imagebuilder.model.WorkflowExecutionStatus.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.imagebuilder.model.WorkflowExecutionStatus.ROLLBACK_IN_PROGRESS =>
      val r = ROLLBACK_IN_PROGRESS
      r
    case software.amazon.awssdk.services.imagebuilder.model.WorkflowExecutionStatus.ROLLBACK_COMPLETED =>
      val r = ROLLBACK_COMPLETED
      r
    case software.amazon.awssdk.services.imagebuilder.model.WorkflowExecutionStatus.CANCELLED =>
      val r = CANCELLED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.imagebuilder.model.WorkflowExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.imagebuilder.model.WorkflowExecutionStatus =
      software.amazon.awssdk.services.imagebuilder.model.WorkflowExecutionStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object PENDING
      extends zio.aws.imagebuilder.model.WorkflowExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.imagebuilder.model.WorkflowExecutionStatus =
      software.amazon.awssdk.services.imagebuilder.model.WorkflowExecutionStatus.PENDING
  }
  case object SKIPPED
      extends zio.aws.imagebuilder.model.WorkflowExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.imagebuilder.model.WorkflowExecutionStatus =
      software.amazon.awssdk.services.imagebuilder.model.WorkflowExecutionStatus.SKIPPED
  }
  case object RUNNING
      extends zio.aws.imagebuilder.model.WorkflowExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.imagebuilder.model.WorkflowExecutionStatus =
      software.amazon.awssdk.services.imagebuilder.model.WorkflowExecutionStatus.RUNNING
  }
  case object COMPLETED
      extends zio.aws.imagebuilder.model.WorkflowExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.imagebuilder.model.WorkflowExecutionStatus =
      software.amazon.awssdk.services.imagebuilder.model.WorkflowExecutionStatus.COMPLETED
  }
  case object FAILED
      extends zio.aws.imagebuilder.model.WorkflowExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.imagebuilder.model.WorkflowExecutionStatus =
      software.amazon.awssdk.services.imagebuilder.model.WorkflowExecutionStatus.FAILED
  }
  case object ROLLBACK_IN_PROGRESS
      extends zio.aws.imagebuilder.model.WorkflowExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.imagebuilder.model.WorkflowExecutionStatus =
      software.amazon.awssdk.services.imagebuilder.model.WorkflowExecutionStatus.ROLLBACK_IN_PROGRESS
  }
  case object ROLLBACK_COMPLETED
      extends zio.aws.imagebuilder.model.WorkflowExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.imagebuilder.model.WorkflowExecutionStatus =
      software.amazon.awssdk.services.imagebuilder.model.WorkflowExecutionStatus.ROLLBACK_COMPLETED
  }
  case object CANCELLED
      extends zio.aws.imagebuilder.model.WorkflowExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.imagebuilder.model.WorkflowExecutionStatus =
      software.amazon.awssdk.services.imagebuilder.model.WorkflowExecutionStatus.CANCELLED
  }
}
