package zio.aws.imagebuilder.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.imagebuilder.model.primitives.{
  WorkflowStepCount,
  WorkflowExecutionMessage,
  ParallelGroup,
  WorkflowExecutionId,
  DateTime,
  WorkflowBuildVersionArn
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class WorkflowExecutionMetadata(
    workflowBuildVersionArn: Optional[WorkflowBuildVersionArn] =
      Optional.Absent,
    workflowExecutionId: Optional[WorkflowExecutionId] = Optional.Absent,
    `type`: Optional[zio.aws.imagebuilder.model.WorkflowType] = Optional.Absent,
    status: Optional[zio.aws.imagebuilder.model.WorkflowExecutionStatus] =
      Optional.Absent,
    message: Optional[WorkflowExecutionMessage] = Optional.Absent,
    totalStepCount: Optional[WorkflowStepCount] = Optional.Absent,
    totalStepsSucceeded: Optional[WorkflowStepCount] = Optional.Absent,
    totalStepsFailed: Optional[WorkflowStepCount] = Optional.Absent,
    totalStepsSkipped: Optional[WorkflowStepCount] = Optional.Absent,
    startTime: Optional[DateTime] = Optional.Absent,
    endTime: Optional[DateTime] = Optional.Absent,
    parallelGroup: Optional[ParallelGroup] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.WorkflowExecutionMetadata = {
    import WorkflowExecutionMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.WorkflowExecutionMetadata
      .builder()
      .optionallyWith(
        workflowBuildVersionArn.map(value =>
          WorkflowBuildVersionArn.unwrap(value): java.lang.String
        )
      )(_.workflowBuildVersionArn)
      .optionallyWith(
        workflowExecutionId.map(value =>
          WorkflowExecutionId.unwrap(value): java.lang.String
        )
      )(_.workflowExecutionId)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        message.map(value =>
          WorkflowExecutionMessage.unwrap(value): java.lang.String
        )
      )(_.message)
      .optionallyWith(
        totalStepCount.map(value => WorkflowStepCount.unwrap(value): Integer)
      )(_.totalStepCount)
      .optionallyWith(
        totalStepsSucceeded.map(value =>
          WorkflowStepCount.unwrap(value): Integer
        )
      )(_.totalStepsSucceeded)
      .optionallyWith(
        totalStepsFailed.map(value => WorkflowStepCount.unwrap(value): Integer)
      )(_.totalStepsFailed)
      .optionallyWith(
        totalStepsSkipped.map(value => WorkflowStepCount.unwrap(value): Integer)
      )(_.totalStepsSkipped)
      .optionallyWith(
        startTime.map(value => DateTime.unwrap(value): java.lang.String)
      )(_.startTime)
      .optionallyWith(
        endTime.map(value => DateTime.unwrap(value): java.lang.String)
      )(_.endTime)
      .optionallyWith(
        parallelGroup.map(value =>
          ParallelGroup.unwrap(value): java.lang.String
        )
      )(_.parallelGroup)
      .build()
  }
  def asReadOnly
      : zio.aws.imagebuilder.model.WorkflowExecutionMetadata.ReadOnly =
    zio.aws.imagebuilder.model.WorkflowExecutionMetadata.wrap(buildAwsValue())
}
object WorkflowExecutionMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.WorkflowExecutionMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.WorkflowExecutionMetadata =
      zio.aws.imagebuilder.model.WorkflowExecutionMetadata(
        workflowBuildVersionArn.map(value => value),
        workflowExecutionId.map(value => value),
        `type`.map(value => value),
        status.map(value => value),
        message.map(value => value),
        totalStepCount.map(value => value),
        totalStepsSucceeded.map(value => value),
        totalStepsFailed.map(value => value),
        totalStepsSkipped.map(value => value),
        startTime.map(value => value),
        endTime.map(value => value),
        parallelGroup.map(value => value)
      )
    def workflowBuildVersionArn: Optional[WorkflowBuildVersionArn]
    def workflowExecutionId: Optional[WorkflowExecutionId]
    def `type`: Optional[zio.aws.imagebuilder.model.WorkflowType]
    def status: Optional[zio.aws.imagebuilder.model.WorkflowExecutionStatus]
    def message: Optional[WorkflowExecutionMessage]
    def totalStepCount: Optional[WorkflowStepCount]
    def totalStepsSucceeded: Optional[WorkflowStepCount]
    def totalStepsFailed: Optional[WorkflowStepCount]
    def totalStepsSkipped: Optional[WorkflowStepCount]
    def startTime: Optional[DateTime]
    def endTime: Optional[DateTime]
    def parallelGroup: Optional[ParallelGroup]
    def getWorkflowBuildVersionArn
        : ZIO[Any, AwsError, WorkflowBuildVersionArn] = AwsError
      .unwrapOptionField("workflowBuildVersionArn", workflowBuildVersionArn)
    def getWorkflowExecutionId: ZIO[Any, AwsError, WorkflowExecutionId] =
      AwsError.unwrapOptionField("workflowExecutionId", workflowExecutionId)
    def getType: ZIO[Any, AwsError, zio.aws.imagebuilder.model.WorkflowType] =
      AwsError.unwrapOptionField("type", `type`)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.imagebuilder.model.WorkflowExecutionStatus
    ] = AwsError.unwrapOptionField("status", status)
    def getMessage: ZIO[Any, AwsError, WorkflowExecutionMessage] =
      AwsError.unwrapOptionField("message", message)
    def getTotalStepCount: ZIO[Any, AwsError, WorkflowStepCount] =
      AwsError.unwrapOptionField("totalStepCount", totalStepCount)
    def getTotalStepsSucceeded: ZIO[Any, AwsError, WorkflowStepCount] =
      AwsError.unwrapOptionField("totalStepsSucceeded", totalStepsSucceeded)
    def getTotalStepsFailed: ZIO[Any, AwsError, WorkflowStepCount] =
      AwsError.unwrapOptionField("totalStepsFailed", totalStepsFailed)
    def getTotalStepsSkipped: ZIO[Any, AwsError, WorkflowStepCount] =
      AwsError.unwrapOptionField("totalStepsSkipped", totalStepsSkipped)
    def getStartTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getEndTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getParallelGroup: ZIO[Any, AwsError, ParallelGroup] =
      AwsError.unwrapOptionField("parallelGroup", parallelGroup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.WorkflowExecutionMetadata
  ) extends zio.aws.imagebuilder.model.WorkflowExecutionMetadata.ReadOnly {
    override val workflowBuildVersionArn: Optional[WorkflowBuildVersionArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.workflowBuildVersionArn())
        .map(value =>
          zio.aws.imagebuilder.model.primitives.WorkflowBuildVersionArn(value)
        )
    override val workflowExecutionId: Optional[WorkflowExecutionId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.workflowExecutionId())
        .map(value =>
          zio.aws.imagebuilder.model.primitives.WorkflowExecutionId(value)
        )
    override val `type`: Optional[zio.aws.imagebuilder.model.WorkflowType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.imagebuilder.model.WorkflowType.wrap(value))
    override val status
        : Optional[zio.aws.imagebuilder.model.WorkflowExecutionStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.imagebuilder.model.WorkflowExecutionStatus.wrap(value)
        )
    override val message: Optional[WorkflowExecutionMessage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.message())
        .map(value =>
          zio.aws.imagebuilder.model.primitives.WorkflowExecutionMessage(value)
        )
    override val totalStepCount: Optional[WorkflowStepCount] =
      zio.aws.core.internal
        .optionalFromNullable(impl.totalStepCount())
        .map(value =>
          zio.aws.imagebuilder.model.primitives.WorkflowStepCount(value)
        )
    override val totalStepsSucceeded: Optional[WorkflowStepCount] =
      zio.aws.core.internal
        .optionalFromNullable(impl.totalStepsSucceeded())
        .map(value =>
          zio.aws.imagebuilder.model.primitives.WorkflowStepCount(value)
        )
    override val totalStepsFailed: Optional[WorkflowStepCount] =
      zio.aws.core.internal
        .optionalFromNullable(impl.totalStepsFailed())
        .map(value =>
          zio.aws.imagebuilder.model.primitives.WorkflowStepCount(value)
        )
    override val totalStepsSkipped: Optional[WorkflowStepCount] =
      zio.aws.core.internal
        .optionalFromNullable(impl.totalStepsSkipped())
        .map(value =>
          zio.aws.imagebuilder.model.primitives.WorkflowStepCount(value)
        )
    override val startTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.startTime())
      .map(value => zio.aws.imagebuilder.model.primitives.DateTime(value))
    override val endTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.endTime())
      .map(value => zio.aws.imagebuilder.model.primitives.DateTime(value))
    override val parallelGroup: Optional[ParallelGroup] = zio.aws.core.internal
      .optionalFromNullable(impl.parallelGroup())
      .map(value => zio.aws.imagebuilder.model.primitives.ParallelGroup(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.WorkflowExecutionMetadata
  ): zio.aws.imagebuilder.model.WorkflowExecutionMetadata.ReadOnly =
    new Wrapper(impl)
}
