package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.{
  TagValue,
  DateTime,
  VersionNumber,
  WorkflowBuildVersionArn,
  WorkflowData,
  NonEmptyString,
  ResourceName,
  TagKey
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class Workflow(
    arn: Optional[WorkflowBuildVersionArn] = Optional.Absent,
    name: Optional[ResourceName] = Optional.Absent,
    version: Optional[VersionNumber] = Optional.Absent,
    description: Optional[NonEmptyString] = Optional.Absent,
    changeDescription: Optional[NonEmptyString] = Optional.Absent,
    `type`: Optional[zio.aws.imagebuilder.model.WorkflowType] = Optional.Absent,
    state: Optional[zio.aws.imagebuilder.model.WorkflowState] = Optional.Absent,
    owner: Optional[NonEmptyString] = Optional.Absent,
    data: Optional[WorkflowData] = Optional.Absent,
    kmsKeyId: Optional[NonEmptyString] = Optional.Absent,
    dateCreated: Optional[DateTime] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    parameters: Optional[
      Iterable[zio.aws.imagebuilder.model.WorkflowParameterDetail]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.Workflow = {
    import Workflow.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.Workflow
      .builder()
      .optionallyWith(
        arn.map(value =>
          WorkflowBuildVersionArn.unwrap(value): java.lang.String
        )
      )(_.arn)
      .optionallyWith(
        name.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        version.map(value => VersionNumber.unwrap(value): java.lang.String)
      )(_.version)
      .optionallyWith(
        description.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        changeDescription.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.changeDescription)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(state.map(value => value.buildAwsValue()))(_.state)
      .optionallyWith(
        owner.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.owner)
      .optionallyWith(
        data.map(value => WorkflowData.unwrap(value): java.lang.String)
      )(_.data)
      .optionallyWith(
        kmsKeyId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .optionallyWith(
        dateCreated.map(value => DateTime.unwrap(value): java.lang.String)
      )(_.dateCreated)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        parameters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.parameters)
      .build()
  }
  def asReadOnly: zio.aws.imagebuilder.model.Workflow.ReadOnly =
    zio.aws.imagebuilder.model.Workflow.wrap(buildAwsValue())
}
object Workflow {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.Workflow
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.Workflow =
      zio.aws.imagebuilder.model.Workflow(
        arn.map(value => value),
        name.map(value => value),
        version.map(value => value),
        description.map(value => value),
        changeDescription.map(value => value),
        `type`.map(value => value),
        state.map(value => value.asEditable),
        owner.map(value => value),
        data.map(value => value),
        kmsKeyId.map(value => value),
        dateCreated.map(value => value),
        tags.map(value => value),
        parameters.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def arn: Optional[WorkflowBuildVersionArn]
    def name: Optional[ResourceName]
    def version: Optional[VersionNumber]
    def description: Optional[NonEmptyString]
    def changeDescription: Optional[NonEmptyString]
    def `type`: Optional[zio.aws.imagebuilder.model.WorkflowType]
    def state: Optional[zio.aws.imagebuilder.model.WorkflowState.ReadOnly]
    def owner: Optional[NonEmptyString]
    def data: Optional[WorkflowData]
    def kmsKeyId: Optional[NonEmptyString]
    def dateCreated: Optional[DateTime]
    def tags: Optional[Map[TagKey, TagValue]]
    def parameters: Optional[
      List[zio.aws.imagebuilder.model.WorkflowParameterDetail.ReadOnly]
    ]
    def getArn: ZIO[Any, AwsError, WorkflowBuildVersionArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("name", name)
    def getVersion: ZIO[Any, AwsError, VersionNumber] =
      AwsError.unwrapOptionField("version", version)
    def getDescription: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("description", description)
    def getChangeDescription: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("changeDescription", changeDescription)
    def getType: ZIO[Any, AwsError, zio.aws.imagebuilder.model.WorkflowType] =
      AwsError.unwrapOptionField("type", `type`)
    def getState: ZIO[
      Any,
      AwsError,
      zio.aws.imagebuilder.model.WorkflowState.ReadOnly
    ] = AwsError.unwrapOptionField("state", state)
    def getOwner: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("owner", owner)
    def getData: ZIO[Any, AwsError, WorkflowData] =
      AwsError.unwrapOptionField("data", data)
    def getKmsKeyId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getDateCreated: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("dateCreated", dateCreated)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getParameters: ZIO[Any, AwsError, List[
      zio.aws.imagebuilder.model.WorkflowParameterDetail.ReadOnly
    ]] = AwsError.unwrapOptionField("parameters", parameters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.Workflow
  ) extends zio.aws.imagebuilder.model.Workflow.ReadOnly {
    override val arn: Optional[WorkflowBuildVersionArn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value =>
        zio.aws.imagebuilder.model.primitives.WorkflowBuildVersionArn(value)
      )
    override val name: Optional[ResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.imagebuilder.model.primitives.ResourceName(value))
    override val version: Optional[VersionNumber] = zio.aws.core.internal
      .optionalFromNullable(impl.version())
      .map(value => zio.aws.imagebuilder.model.primitives.VersionNumber(value))
    override val description: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val changeDescription: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.changeDescription())
        .map(value =>
          zio.aws.imagebuilder.model.primitives.NonEmptyString(value)
        )
    override val `type`: Optional[zio.aws.imagebuilder.model.WorkflowType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.imagebuilder.model.WorkflowType.wrap(value))
    override val state
        : Optional[zio.aws.imagebuilder.model.WorkflowState.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.imagebuilder.model.WorkflowState.wrap(value))
    override val owner: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.owner())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val data: Optional[WorkflowData] = zio.aws.core.internal
      .optionalFromNullable(impl.data())
      .map(value => zio.aws.imagebuilder.model.primitives.WorkflowData(value))
    override val kmsKeyId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val dateCreated: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.dateCreated())
      .map(value => zio.aws.imagebuilder.model.primitives.DateTime(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.imagebuilder.model.primitives.TagKey(
              key
            ) -> zio.aws.imagebuilder.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val parameters: Optional[
      List[zio.aws.imagebuilder.model.WorkflowParameterDetail.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.parameters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.imagebuilder.model.WorkflowParameterDetail.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.Workflow
  ): zio.aws.imagebuilder.model.Workflow.ReadOnly = new Wrapper(impl)
}
