package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.LifecyclePolicyArn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateLifecyclePolicyResponse(
    lifecyclePolicyArn: Optional[LifecyclePolicyArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.UpdateLifecyclePolicyResponse = {
    import UpdateLifecyclePolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.UpdateLifecyclePolicyResponse
      .builder()
      .optionallyWith(
        lifecyclePolicyArn.map(value =>
          LifecyclePolicyArn.unwrap(value): java.lang.String
        )
      )(_.lifecyclePolicyArn)
      .build()
  }
  def asReadOnly
      : zio.aws.imagebuilder.model.UpdateLifecyclePolicyResponse.ReadOnly =
    zio.aws.imagebuilder.model.UpdateLifecyclePolicyResponse
      .wrap(buildAwsValue())
}
object UpdateLifecyclePolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.UpdateLifecyclePolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.UpdateLifecyclePolicyResponse =
      zio.aws.imagebuilder.model
        .UpdateLifecyclePolicyResponse(lifecyclePolicyArn.map(value => value))
    def lifecyclePolicyArn: Optional[LifecyclePolicyArn]
    def getLifecyclePolicyArn: ZIO[Any, AwsError, LifecyclePolicyArn] =
      AwsError.unwrapOptionField("lifecyclePolicyArn", lifecyclePolicyArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.UpdateLifecyclePolicyResponse
  ) extends zio.aws.imagebuilder.model.UpdateLifecyclePolicyResponse.ReadOnly {
    override val lifecyclePolicyArn: Optional[LifecyclePolicyArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lifecyclePolicyArn())
        .map(value =>
          zio.aws.imagebuilder.model.primitives.LifecyclePolicyArn(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.UpdateLifecyclePolicyResponse
  ): zio.aws.imagebuilder.model.UpdateLifecyclePolicyResponse.ReadOnly =
    new Wrapper(impl)
}
