package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.{TagKey, ImageBuilderArn}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UntagResourceRequest(
    resourceArn: ImageBuilderArn,
    tagKeys: Iterable[TagKey]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.UntagResourceRequest = {
    import UntagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.UntagResourceRequest
      .builder()
      .resourceArn(ImageBuilderArn.unwrap(resourceArn): java.lang.String)
      .tagKeys(tagKeys.map { item =>
        TagKey.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.imagebuilder.model.UntagResourceRequest.ReadOnly =
    zio.aws.imagebuilder.model.UntagResourceRequest.wrap(buildAwsValue())
}
object UntagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.UntagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.UntagResourceRequest =
      zio.aws.imagebuilder.model.UntagResourceRequest(resourceArn, tagKeys)
    def resourceArn: ImageBuilderArn
    def tagKeys: List[TagKey]
    def getResourceArn: ZIO[Any, Nothing, ImageBuilderArn] =
      ZIO.succeed(resourceArn)
    def getTagKeys: ZIO[Any, Nothing, List[TagKey]] = ZIO.succeed(tagKeys)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.UntagResourceRequest
  ) extends zio.aws.imagebuilder.model.UntagResourceRequest.ReadOnly {
    override val resourceArn: ImageBuilderArn =
      zio.aws.imagebuilder.model.primitives.ImageBuilderArn(impl.resourceArn())
    override val tagKeys: List[TagKey] = impl
      .tagKeys()
      .asScala
      .map { item =>
        zio.aws.imagebuilder.model.primitives.TagKey(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.UntagResourceRequest
  ): zio.aws.imagebuilder.model.UntagResourceRequest.ReadOnly = new Wrapper(
    impl
  )
}
