package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.{
  ImageBuildVersionArn,
  LifecycleExecutionId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class StartResourceStateUpdateResponse(
    lifecycleExecutionId: Optional[LifecycleExecutionId] = Optional.Absent,
    resourceArn: Optional[ImageBuildVersionArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.StartResourceStateUpdateResponse = {
    import StartResourceStateUpdateResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.StartResourceStateUpdateResponse
      .builder()
      .optionallyWith(
        lifecycleExecutionId.map(value =>
          LifecycleExecutionId.unwrap(value): java.lang.String
        )
      )(_.lifecycleExecutionId)
      .optionallyWith(
        resourceArn.map(value =>
          ImageBuildVersionArn.unwrap(value): java.lang.String
        )
      )(_.resourceArn)
      .build()
  }
  def asReadOnly
      : zio.aws.imagebuilder.model.StartResourceStateUpdateResponse.ReadOnly =
    zio.aws.imagebuilder.model.StartResourceStateUpdateResponse
      .wrap(buildAwsValue())
}
object StartResourceStateUpdateResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.StartResourceStateUpdateResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.imagebuilder.model.StartResourceStateUpdateResponse =
      zio.aws.imagebuilder.model.StartResourceStateUpdateResponse(
        lifecycleExecutionId.map(value => value),
        resourceArn.map(value => value)
      )
    def lifecycleExecutionId: Optional[LifecycleExecutionId]
    def resourceArn: Optional[ImageBuildVersionArn]
    def getLifecycleExecutionId: ZIO[Any, AwsError, LifecycleExecutionId] =
      AwsError.unwrapOptionField("lifecycleExecutionId", lifecycleExecutionId)
    def getResourceArn: ZIO[Any, AwsError, ImageBuildVersionArn] =
      AwsError.unwrapOptionField("resourceArn", resourceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.StartResourceStateUpdateResponse
  ) extends zio.aws.imagebuilder.model.StartResourceStateUpdateResponse.ReadOnly {
    override val lifecycleExecutionId: Optional[LifecycleExecutionId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lifecycleExecutionId())
        .map(value =>
          zio.aws.imagebuilder.model.primitives.LifecycleExecutionId(value)
        )
    override val resourceArn: Optional[ImageBuildVersionArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceArn())
        .map(value =>
          zio.aws.imagebuilder.model.primitives.ImageBuildVersionArn(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.StartResourceStateUpdateResponse
  ): zio.aws.imagebuilder.model.StartResourceStateUpdateResponse.ReadOnly =
    new Wrapper(impl)
}
