package zio.aws.imagebuilder.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.imagebuilder.model.primitives.{
  ClientToken,
  DateTimeTimestamp,
  RoleNameOrArn,
  ImageBuildVersionArn
}
import scala.jdk.CollectionConverters.*
final case class StartResourceStateUpdateRequest(
    resourceArn: ImageBuildVersionArn,
    state: zio.aws.imagebuilder.model.ResourceState,
    executionRole: Optional[RoleNameOrArn] = Optional.Absent,
    includeResources: Optional[
      zio.aws.imagebuilder.model.ResourceStateUpdateIncludeResources
    ] = Optional.Absent,
    exclusionRules: Optional[
      zio.aws.imagebuilder.model.ResourceStateUpdateExclusionRules
    ] = Optional.Absent,
    updateAt: Optional[DateTimeTimestamp] = Optional.Absent,
    clientToken: ClientToken
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.StartResourceStateUpdateRequest = {
    import StartResourceStateUpdateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.StartResourceStateUpdateRequest
      .builder()
      .resourceArn(ImageBuildVersionArn.unwrap(resourceArn): java.lang.String)
      .state(state.buildAwsValue())
      .optionallyWith(
        executionRole.map(value =>
          RoleNameOrArn.unwrap(value): java.lang.String
        )
      )(_.executionRole)
      .optionallyWith(includeResources.map(value => value.buildAwsValue()))(
        _.includeResources
      )
      .optionallyWith(exclusionRules.map(value => value.buildAwsValue()))(
        _.exclusionRules
      )
      .optionallyWith(
        updateAt.map(value => DateTimeTimestamp.unwrap(value): Instant)
      )(_.updateAt)
      .clientToken(ClientToken.unwrap(clientToken): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.imagebuilder.model.StartResourceStateUpdateRequest.ReadOnly =
    zio.aws.imagebuilder.model.StartResourceStateUpdateRequest
      .wrap(buildAwsValue())
}
object StartResourceStateUpdateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.StartResourceStateUpdateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.StartResourceStateUpdateRequest =
      zio.aws.imagebuilder.model.StartResourceStateUpdateRequest(
        resourceArn,
        state.asEditable,
        executionRole.map(value => value),
        includeResources.map(value => value.asEditable),
        exclusionRules.map(value => value.asEditable),
        updateAt.map(value => value),
        clientToken
      )
    def resourceArn: ImageBuildVersionArn
    def state: zio.aws.imagebuilder.model.ResourceState.ReadOnly
    def executionRole: Optional[RoleNameOrArn]
    def includeResources: Optional[
      zio.aws.imagebuilder.model.ResourceStateUpdateIncludeResources.ReadOnly
    ]
    def exclusionRules: Optional[
      zio.aws.imagebuilder.model.ResourceStateUpdateExclusionRules.ReadOnly
    ]
    def updateAt: Optional[DateTimeTimestamp]
    def clientToken: ClientToken
    def getResourceArn: ZIO[Any, Nothing, ImageBuildVersionArn] =
      ZIO.succeed(resourceArn)
    def getState
        : ZIO[Any, Nothing, zio.aws.imagebuilder.model.ResourceState.ReadOnly] =
      ZIO.succeed(state)
    def getExecutionRole: ZIO[Any, AwsError, RoleNameOrArn] =
      AwsError.unwrapOptionField("executionRole", executionRole)
    def getIncludeResources: ZIO[
      Any,
      AwsError,
      zio.aws.imagebuilder.model.ResourceStateUpdateIncludeResources.ReadOnly
    ] = AwsError.unwrapOptionField("includeResources", includeResources)
    def getExclusionRules: ZIO[
      Any,
      AwsError,
      zio.aws.imagebuilder.model.ResourceStateUpdateExclusionRules.ReadOnly
    ] = AwsError.unwrapOptionField("exclusionRules", exclusionRules)
    def getUpdateAt: ZIO[Any, AwsError, DateTimeTimestamp] =
      AwsError.unwrapOptionField("updateAt", updateAt)
    def getClientToken: ZIO[Any, Nothing, ClientToken] =
      ZIO.succeed(clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.StartResourceStateUpdateRequest
  ) extends zio.aws.imagebuilder.model.StartResourceStateUpdateRequest.ReadOnly {
    override val resourceArn: ImageBuildVersionArn =
      zio.aws.imagebuilder.model.primitives
        .ImageBuildVersionArn(impl.resourceArn())
    override val state: zio.aws.imagebuilder.model.ResourceState.ReadOnly =
      zio.aws.imagebuilder.model.ResourceState.wrap(impl.state())
    override val executionRole: Optional[RoleNameOrArn] = zio.aws.core.internal
      .optionalFromNullable(impl.executionRole())
      .map(value => zio.aws.imagebuilder.model.primitives.RoleNameOrArn(value))
    override val includeResources: Optional[
      zio.aws.imagebuilder.model.ResourceStateUpdateIncludeResources.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.includeResources())
      .map(value =>
        zio.aws.imagebuilder.model.ResourceStateUpdateIncludeResources
          .wrap(value)
      )
    override val exclusionRules: Optional[
      zio.aws.imagebuilder.model.ResourceStateUpdateExclusionRules.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.exclusionRules())
      .map(value =>
        zio.aws.imagebuilder.model.ResourceStateUpdateExclusionRules.wrap(value)
      )
    override val updateAt: Optional[DateTimeTimestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.updateAt())
      .map(value =>
        zio.aws.imagebuilder.model.primitives.DateTimeTimestamp(value)
      )
    override val clientToken: ClientToken =
      zio.aws.imagebuilder.model.primitives.ClientToken(impl.clientToken())
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.StartResourceStateUpdateRequest
  ): zio.aws.imagebuilder.model.StartResourceStateUpdateRequest.ReadOnly =
    new Wrapper(impl)
}
