package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.{ClientToken, ImagePipelineArn}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class StartImagePipelineExecutionRequest(
    imagePipelineArn: ImagePipelineArn,
    clientToken: ClientToken
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.StartImagePipelineExecutionRequest = {
    import StartImagePipelineExecutionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.StartImagePipelineExecutionRequest
      .builder()
      .imagePipelineArn(
        ImagePipelineArn.unwrap(imagePipelineArn): java.lang.String
      )
      .clientToken(ClientToken.unwrap(clientToken): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.imagebuilder.model.StartImagePipelineExecutionRequest.ReadOnly =
    zio.aws.imagebuilder.model.StartImagePipelineExecutionRequest
      .wrap(buildAwsValue())
}
object StartImagePipelineExecutionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.StartImagePipelineExecutionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.imagebuilder.model.StartImagePipelineExecutionRequest =
      zio.aws.imagebuilder.model
        .StartImagePipelineExecutionRequest(imagePipelineArn, clientToken)
    def imagePipelineArn: ImagePipelineArn
    def clientToken: ClientToken
    def getImagePipelineArn: ZIO[Any, Nothing, ImagePipelineArn] =
      ZIO.succeed(imagePipelineArn)
    def getClientToken: ZIO[Any, Nothing, ClientToken] =
      ZIO.succeed(clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.StartImagePipelineExecutionRequest
  ) extends zio.aws.imagebuilder.model.StartImagePipelineExecutionRequest.ReadOnly {
    override val imagePipelineArn: ImagePipelineArn =
      zio.aws.imagebuilder.model.primitives
        .ImagePipelineArn(impl.imagePipelineArn())
    override val clientToken: ClientToken =
      zio.aws.imagebuilder.model.primitives.ClientToken(impl.clientToken())
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.StartImagePipelineExecutionRequest
  ): zio.aws.imagebuilder.model.StartImagePipelineExecutionRequest.ReadOnly =
    new Wrapper(impl)
}
