package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.{
  ClientToken,
  ImageBuildVersionArn,
  WorkflowStepExecutionId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SendWorkflowStepActionResponse(
    stepExecutionId: Optional[WorkflowStepExecutionId] = Optional.Absent,
    imageBuildVersionArn: Optional[ImageBuildVersionArn] = Optional.Absent,
    clientToken: Optional[ClientToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.SendWorkflowStepActionResponse = {
    import SendWorkflowStepActionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.SendWorkflowStepActionResponse
      .builder()
      .optionallyWith(
        stepExecutionId.map(value =>
          WorkflowStepExecutionId.unwrap(value): java.lang.String
        )
      )(_.stepExecutionId)
      .optionallyWith(
        imageBuildVersionArn.map(value =>
          ImageBuildVersionArn.unwrap(value): java.lang.String
        )
      )(_.imageBuildVersionArn)
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .build()
  }
  def asReadOnly
      : zio.aws.imagebuilder.model.SendWorkflowStepActionResponse.ReadOnly =
    zio.aws.imagebuilder.model.SendWorkflowStepActionResponse
      .wrap(buildAwsValue())
}
object SendWorkflowStepActionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.SendWorkflowStepActionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.SendWorkflowStepActionResponse =
      zio.aws.imagebuilder.model.SendWorkflowStepActionResponse(
        stepExecutionId.map(value => value),
        imageBuildVersionArn.map(value => value),
        clientToken.map(value => value)
      )
    def stepExecutionId: Optional[WorkflowStepExecutionId]
    def imageBuildVersionArn: Optional[ImageBuildVersionArn]
    def clientToken: Optional[ClientToken]
    def getStepExecutionId: ZIO[Any, AwsError, WorkflowStepExecutionId] =
      AwsError.unwrapOptionField("stepExecutionId", stepExecutionId)
    def getImageBuildVersionArn: ZIO[Any, AwsError, ImageBuildVersionArn] =
      AwsError.unwrapOptionField("imageBuildVersionArn", imageBuildVersionArn)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.SendWorkflowStepActionResponse
  ) extends zio.aws.imagebuilder.model.SendWorkflowStepActionResponse.ReadOnly {
    override val stepExecutionId: Optional[WorkflowStepExecutionId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stepExecutionId())
        .map(value =>
          zio.aws.imagebuilder.model.primitives.WorkflowStepExecutionId(value)
        )
    override val imageBuildVersionArn: Optional[ImageBuildVersionArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.imageBuildVersionArn())
        .map(value =>
          zio.aws.imagebuilder.model.primitives.ImageBuildVersionArn(value)
        )
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.imagebuilder.model.primitives.ClientToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.SendWorkflowStepActionResponse
  ): zio.aws.imagebuilder.model.SendWorkflowStepActionResponse.ReadOnly =
    new Wrapper(impl)
}
