package zio.aws.imagebuilder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ResourceStateUpdateIncludeResources(
    amis: Optional[Boolean] = Optional.Absent,
    snapshots: Optional[Boolean] = Optional.Absent,
    containers: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.ResourceStateUpdateIncludeResources = {
    import ResourceStateUpdateIncludeResources.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.ResourceStateUpdateIncludeResources
      .builder()
      .optionallyWith(amis.map(value => value: java.lang.Boolean))(_.amis)
      .optionallyWith(snapshots.map(value => value: java.lang.Boolean))(
        _.snapshots
      )
      .optionallyWith(containers.map(value => value: java.lang.Boolean))(
        _.containers
      )
      .build()
  }
  def asReadOnly
      : zio.aws.imagebuilder.model.ResourceStateUpdateIncludeResources.ReadOnly =
    zio.aws.imagebuilder.model.ResourceStateUpdateIncludeResources
      .wrap(buildAwsValue())
}
object ResourceStateUpdateIncludeResources {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.ResourceStateUpdateIncludeResources
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.imagebuilder.model.ResourceStateUpdateIncludeResources =
      zio.aws.imagebuilder.model.ResourceStateUpdateIncludeResources(
        amis.map(value => value),
        snapshots.map(value => value),
        containers.map(value => value)
      )
    def amis: Optional[Boolean]
    def snapshots: Optional[Boolean]
    def containers: Optional[Boolean]
    def getAmis: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("amis", amis)
    def getSnapshots: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("snapshots", snapshots)
    def getContainers: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("containers", containers)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.ResourceStateUpdateIncludeResources
  ) extends zio.aws.imagebuilder.model.ResourceStateUpdateIncludeResources.ReadOnly {
    override val amis: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.amis())
      .map(value => value: Boolean)
    override val snapshots: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.snapshots())
      .map(value => value: Boolean)
    override val containers: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.containers())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.ResourceStateUpdateIncludeResources
  ): zio.aws.imagebuilder.model.ResourceStateUpdateIncludeResources.ReadOnly =
    new Wrapper(impl)
}
